/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ReferenceType;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;

public class ObjectType
extends ReferenceType {
    private final @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String className;

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType getInstance(@BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String className) {
        return new ObjectType(className);
    }

    public ObjectType(@BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String className) {
        super((byte)14, "L" + className.replace('.', '/') + ";");
        this.className = className.replace('/', '.');
    }

    public @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String getClassName() {
        return this.className;
    }

    @Override
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return this.className.hashCode();
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object type) {
        return type instanceof ObjectType ? ((ObjectType)type).className.equals(this.className) : false;
    }

    @Deprecated
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean referencesClass() {
        try {
            JavaClass jc = Repository.lookupClass(this.className);
            return jc.isClass();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Deprecated
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean referencesInterface() {
        try {
            JavaClass jc = Repository.lookupClass(this.className);
            return !jc.isClass();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean referencesClassExact() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.className);
        return jc.isClass();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean referencesInterfaceExact() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.className);
        return !jc.isClass();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean subclassOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType superclass) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        if (this.referencesInterfaceExact() || superclass.referencesInterfaceExact()) {
            return false;
        }
        return Repository.instanceOf(this.className, superclass.className);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean accessibleTo(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType accessor) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.className);
        if (jc.isPublic()) {
            return true;
        }
        JavaClass acc = Repository.lookupClass(accessor.className);
        return acc.getPackageName().equals(jc.getPackageName());
    }
}

