/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ElementValueGen;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class ArrayElementValueGen
extends ElementValueGen {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValueGen> evalues;

    public ArrayElementValueGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        super(91, cp);
        this.evalues = new ArrayList<ElementValueGen>();
    }

    public ArrayElementValueGen(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValue @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] datums, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpool) {
        super(type, cpool);
        if (type != 91) {
            throw new IllegalArgumentException("Only element values of type array can be built with this ctor - type specified: " + type);
        }
        this.evalues = new ArrayList<ElementValueGen>();
        for (ElementValue datum : datums) {
            this.evalues.add(ElementValueGen.copy(datum, cpool, true));
        }
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValue getElementValue() {
        ElementValue[] immutableData = new ElementValue[this.evalues.size()];
        int i = 0;
        for (ElementValueGen element : this.evalues) {
            immutableData[i++] = element.getElementValue();
        }
        return new ArrayElementValue(super.getElementValueType(), immutableData, this.getConstantPool().getConstantPool());
    }

    public ArrayElementValueGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArrayElementValue value, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean copyPoolEntries) {
        super(91, cpool);
        ElementValue[] in;
        this.evalues = new ArrayList<ElementValueGen>();
        for (ElementValue element : in = value.getElementValuesArray()) {
            this.evalues.add(ElementValueGen.copy(element, cpool, copyPoolEntries));
        }
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        dos.writeByte(super.getElementValueType());
        dos.writeShort(this.evalues.size());
        for (ElementValueGen element : this.evalues) {
            element.dump(dos);
        }
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String stringifyValue() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        String comma = "";
        for (ElementValueGen element : this.evalues) {
            sb.append(comma);
            comma = ",";
            sb.append(element.stringifyValue());
        }
        sb.append("]");
        return sb.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValueGen> getElementValues() {
        return this.evalues;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getElementValuesSize() {
        return this.evalues.size();
    }

    public void addElement(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValueGen gen) {
        this.evalues.add(gen);
    }
}

