/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Visitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;

public class MethodParameter
implements Cloneable {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int accessFlags;

    public MethodParameter() {
    }

    MethodParameter(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.nameIndex = input.readUnsignedShort();
        this.accessFlags = input.readUnsignedShort();
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index) {
        this.nameIndex = name_index;
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown String getParameterName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        if (this.nameIndex == 0) {
            return null;
        }
        return ((ConstantUtf8)constant_pool.getConstant(this.nameIndex, (byte)1)).getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags) {
        this.accessFlags = access_flags;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isSynthetic() {
        return (this.accessFlags & 0x1000) != 0;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isMandated() {
        return (this.accessFlags & Short.MIN_VALUE) != 0;
    }

    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitMethodParameter(this);
    }

    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.nameIndex);
        file.writeShort(this.accessFlags);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodParameter copy() {
        try {
            return (MethodParameter)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

