/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.Visitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class ConstantMethodHandle
extends Constant {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int referenceKind;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int referenceIndex;

    public ConstantMethodHandle(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantMethodHandle c) {
        this(c.getReferenceKind(), c.getReferenceIndex());
    }

    ConstantMethodHandle(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(file.readUnsignedByte(), file.readUnsignedShort());
    }

    public ConstantMethodHandle(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int reference_kind, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int reference_index) {
        super((byte)15);
        this.referenceKind = reference_kind;
        this.referenceIndex = reference_index;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitConstantMethodHandle(this);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeByte(super.getTag());
        file.writeByte(this.referenceKind);
        file.writeShort(this.referenceIndex);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getReferenceKind() {
        return this.referenceKind;
    }

    public void setReferenceKind(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int reference_kind) {
        this.referenceKind = reference_kind;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getReferenceIndex() {
        return this.referenceIndex;
    }

    public void setReferenceIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int reference_index) {
        this.referenceIndex = reference_index;
    }

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return super.toString() + "(referenceKind = " + this.referenceKind + ", referenceIndex = " + this.referenceIndex + ")";
    }
}

