/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.bcelutil;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.formatter.qual.FormatMethod;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public final class SimpleLog {
    public @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean enabled;
    private @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown int indentLevel = 0;
    private final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String INDENT_STR_ONE_LEVEL = "  ";
    private @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown String indentString = null;
    private @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown List<@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String> indentStrings;

    public SimpleLog() {
        this(true);
    }

    public SimpleLog(@UnknownFormat @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean enabled) {
        this.enabled = enabled;
        this.indentStrings = new ArrayList<String>();
        this.indentStrings.add("");
    }

    public @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean enabled() {
        return this.enabled;
    }

    @FormatMethod
    public void log(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String format, Object ... args) {
        if (this.enabled) {
            System.out.print(this.getIndentString());
            System.out.printf(format, args);
        }
    }

    public void logStackTrace() {
        if (this.enabled) {
            Throwable t = new Throwable();
            t.fillInStackTrace();
            StackTraceElement[] ste_arr = t.getStackTrace();
            for (int ii = 2; ii < ste_arr.length; ++ii) {
                StackTraceElement ste = ste_arr[ii];
                System.out.printf("%s  %s%n", this.getIndentString(), ste);
            }
        }
    }

    private @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String getIndentString() {
        assert (this.enabled);
        if (this.indentString == null) {
            for (int i = this.indentStrings.size(); i <= this.indentLevel; ++i) {
                this.indentStrings.add(this.indentStrings.get(i - 1) + "  ");
            }
            this.indentString = this.indentStrings.get(this.indentLevel);
        }
        return this.indentString;
    }

    public void indent() {
        if (this.enabled) {
            ++this.indentLevel;
            this.indentString = null;
        }
    }

    public void exdent() {
        if (this.enabled) {
            if (this.indentLevel == 0) {
                this.log("Called exdent when indentation level was 0.", new Object[0]);
                this.logStackTrace();
            } else {
                --this.indentLevel;
                this.indentString = null;
            }
        }
    }

    public void resetIndent() {
        if (this.enabled) {
            this.indentLevel = 0;
            this.indentString = "";
        }
    }
}

