/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.bcelutil;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.ReturnaddressType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.VerifierConstraintViolatedException;
import org.apache.bcel.verifier.structurals.ControlFlowGraph;
import org.apache.bcel.verifier.structurals.ExceptionHandler;
import org.apache.bcel.verifier.structurals.ExecutionVisitor;
import org.apache.bcel.verifier.structurals.Frame;
import org.apache.bcel.verifier.structurals.InstConstraintVisitor;
import org.apache.bcel.verifier.structurals.InstructionContext;
import org.apache.bcel.verifier.structurals.LocalVariables;
import org.apache.bcel.verifier.structurals.OperandStack;
import org.apache.bcel.verifier.structurals.UninitializedObjectType;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.plumelib.bcelutil.LimitedConstraintVisitor;
import org.plumelib.bcelutil.StackTypes;

public final class StackVer {
    private static final @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown boolean DEBUG = true;
    private @MonotonicNonNull @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown StackTypes stack_types;
    private @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown ArrayList<@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown String> messages = new ArrayList();

    public @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown StackTypes get_stack_types() {
        return this.stack_types;
    }

    private void circulationPump(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown ControlFlowGraph cfg, @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown InstructionContext start, @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown Frame vanillaFrame, @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown InstConstraintVisitor icv, @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown ExecutionVisitor ev) {
        Random random = new Random();
        InstructionContextQueue icq = new InstructionContextQueue();
        this.stack_types.set(start.getInstruction().getPosition(), vanillaFrame);
        start.execute(vanillaFrame, new ArrayList(), icv, ev);
        icq.add(start, new ArrayList<InstructionContext>());
        while (!icq.isEmpty()) {
            Frame f;
            InstructionContext v;
            int s;
            InstructionContext u = icq.getIC(0);
            ArrayList<InstructionContext> ec = icq.getEC(0);
            icq.remove(0);
            ArrayList<InstructionContext> oldchain = new ArrayList<InstructionContext>(ec);
            ArrayList<InstructionContext> newchain = new ArrayList<InstructionContext>(ec);
            newchain.add(u);
            if (u.getInstruction().getInstruction() instanceof RET) {
                RET ret = (RET)u.getInstruction().getInstruction();
                ReturnaddressType t = (ReturnaddressType)u.getOutFrame(oldchain).getLocals().get(ret.getIndex());
                InstructionContext theSuccessor = cfg.contextOf(t.getTarget());
                InstructionContext lastJSR = null;
                int skip_jsr = 0;
                for (int ss = oldchain.size() - 1; ss >= 0; --ss) {
                    if (skip_jsr < 0) {
                        throw new AssertionViolatedException("More RET than JSR in execution chain?!");
                    }
                    if (oldchain.get(ss).getInstruction().getInstruction() instanceof JsrInstruction) {
                        if (skip_jsr == 0) {
                            lastJSR = oldchain.get(ss);
                            break;
                        }
                        --skip_jsr;
                    }
                    if (!(oldchain.get(ss).getInstruction().getInstruction() instanceof RET)) continue;
                    ++skip_jsr;
                }
                if (lastJSR == null) {
                    throw new AssertionViolatedException("RET without a JSR before in ExecutionChain?! EC: '" + oldchain + "'.");
                }
                JsrInstruction jsr = (JsrInstruction)lastJSR.getInstruction().getInstruction();
                if (theSuccessor != cfg.contextOf(jsr.physicalSuccessor())) {
                    throw new AssertionViolatedException("RET '" + u.getInstruction() + "' info inconsistent: jump back to '" + theSuccessor + "' or '" + cfg.contextOf(jsr.physicalSuccessor()) + "'?");
                }
                Frame f2 = u.getOutFrame(oldchain);
                this.stack_types.set(theSuccessor.getInstruction().getPosition(), f2);
                if (theSuccessor.execute(f2, newchain, icv, ev)) {
                    icq.add(theSuccessor, new ArrayList<InstructionContext>(newchain));
                }
            } else {
                InstructionContext[] succs = u.getSuccessors();
                for (s = 0; s < succs.length; ++s) {
                    v = succs[s];
                    f = u.getOutFrame(oldchain);
                    this.stack_types.set(v.getInstruction().getPosition(), f);
                    if (!v.execute(f, newchain, icv, ev)) continue;
                    icq.add(v, new ArrayList<InstructionContext>(newchain));
                }
            }
            ExceptionHandler[] exc_hds = u.getExceptionHandlers();
            for (s = 0; s < exc_hds.length; ++s) {
                v = cfg.contextOf(exc_hds[s].getHandlerStart());
                f = new Frame(u.getOutFrame(oldchain).getLocals(), new OperandStack(u.getOutFrame(oldchain).getStack().maxStack(), exc_hds[s].getExceptionType() == null ? Type.THROWABLE : exc_hds[s].getExceptionType()));
                this.stack_types.set(v.getInstruction().getPosition(), f);
                if (!v.execute(f, new ArrayList(), icv, ev)) continue;
                icq.add(v, new ArrayList<InstructionContext>());
            }
        }
        InstructionHandle ih = start.getInstruction();
        do {
            if (!(ih.getInstruction() instanceof ReturnInstruction) || cfg.isDead(ih)) continue;
            InstructionContext ic = cfg.contextOf(ih);
            Frame f = ic.getOutFrame(new ArrayList());
            LocalVariables lvs = f.getLocals();
            for (int i = 0; i < lvs.maxLocals(); ++i) {
                if (!(lvs.get(i) instanceof UninitializedObjectType)) continue;
                this.addMessage("Warning: ReturnInstruction '" + ic + "' may leave method with an uninitialized object in the local variables array '" + lvs + "'.");
            }
            OperandStack os = f.getStack();
            for (int i = 0; i < os.size(); ++i) {
                if (!(os.peek(i) instanceof UninitializedObjectType)) continue;
                this.addMessage("Warning: ReturnInstruction '" + ic + "' may leave method with an uninitialized object on the operand stack '" + os + "'.");
            }
        } while ((ih = ih.getNext()) != null);
    }

    public @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown VerificationResult do_stack_ver(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown MethodGen mg) {
        ConstantPoolGen constantPoolGen = mg.getConstantPool();
        LimitedConstraintVisitor icv = new LimitedConstraintVisitor();
        icv.setConstantPoolGen(constantPoolGen);
        ExecutionVisitor ev = new ExecutionVisitor();
        ev.setConstantPoolGen(constantPoolGen);
        try {
            this.stack_types = new StackTypes(mg);
            icv.setMethodGen(mg);
            if (!mg.isAbstract() && !mg.isNative()) {
                ControlFlowGraph cfg = new ControlFlowGraph(mg, false);
                Frame f = new Frame(mg.getMaxLocals(), mg.getMaxStack());
                if (!mg.isStatic()) {
                    if (mg.getName().equals("<init>")) {
                        Frame.setThis((UninitializedObjectType)new UninitializedObjectType(new ObjectType(mg.getClassName())));
                        f.getLocals().set(0, (Type)Frame.getThis());
                    } else {
                        UninitializedObjectType dummy = null;
                        Frame.setThis(dummy);
                        f.getLocals().set(0, (Type)new ObjectType(mg.getClassName()));
                    }
                }
                Type[] argtypes = mg.getArgumentTypes();
                int twoslotoffset = 0;
                for (int j = 0; j < argtypes.length; ++j) {
                    if (argtypes[j] == Type.SHORT || argtypes[j] == Type.BYTE || argtypes[j] == Type.CHAR || argtypes[j] == Type.BOOLEAN) {
                        argtypes[j] = Type.INT;
                    }
                    f.getLocals().set(twoslotoffset + j + (mg.isStatic() ? 0 : 1), argtypes[j]);
                    if (argtypes[j].getSize() != 2) continue;
                    f.getLocals().set(++twoslotoffset + j + (mg.isStatic() ? 0 : 1), Type.UNKNOWN);
                }
                this.circulationPump(cfg, cfg.contextOf(mg.getInstructionList().getStart()), f, icv, ev);
            }
        }
        catch (VerifierConstraintViolatedException ce) {
            ce.extendMessage("Constraint violated in method '" + mg + "':\n", "");
            return new VerificationResult(2, ce.getMessage());
        }
        catch (RuntimeException re) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            re.printStackTrace(pw);
            throw new AssertionViolatedException("Some RuntimeException occured while verify()ing class '" + mg.getClassName() + "', method '" + mg + "'. Original RuntimeException's stack trace:\n---\n" + sw + "---\n");
        }
        return VerificationResult.VR_OK;
    }

    public void addMessage(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown String message) {
        this.messages.add(message);
    }

    private static final class InstructionContextQueue {
        private @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown List<@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown InstructionContext> ics = new ArrayList<InstructionContext>();
        private @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown List<@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown ArrayList<@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown InstructionContext>> ecs = new ArrayList<ArrayList<InstructionContext>>();

        private InstructionContextQueue() {
        }

        public void add(@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown InstructionContext ic, @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown ArrayList<@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown InstructionContext> executionChain) {
            this.ics.add(ic);
            this.ecs.add(executionChain);
        }

        public @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown boolean isEmpty() {
            return this.ics.isEmpty();
        }

        public void remove() {
            this.remove(0);
        }

        public void remove(@Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @NonNegative @UnknownFormat @UnknownRegex @SignatureUnknown int i) {
            this.ics.remove(i);
            this.ecs.remove(i);
        }

        public @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown InstructionContext getIC(@Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @NonNegative @UnknownFormat @UnknownRegex @SignatureUnknown int i) {
            return this.ics.get(i);
        }

        public @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown ArrayList<@UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown InstructionContext> getEC(@Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @NonNegative @UnknownFormat @UnknownRegex @SignatureUnknown int i) {
            return this.ecs.get(i);
        }

        public @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @NonRaw @UnknownFormat @UnknownRegex @SignatureUnknown int size() {
            return this.ics.size();
        }
    }
}

