/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.bcelutil;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.ReturnaddressType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.bcel.verifier.exc.VerifierConstraintViolatedException;
import org.apache.bcel.verifier.structurals.ControlFlowGraph;
import org.apache.bcel.verifier.structurals.ExceptionHandler;
import org.apache.bcel.verifier.structurals.ExecutionVisitor;
import org.apache.bcel.verifier.structurals.Frame;
import org.apache.bcel.verifier.structurals.InstConstraintVisitor;
import org.apache.bcel.verifier.structurals.InstructionContext;
import org.apache.bcel.verifier.structurals.LocalVariables;
import org.apache.bcel.verifier.structurals.OperandStack;
import org.apache.bcel.verifier.structurals.UninitializedObjectType;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.mustcall.qual.MustCall;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.common.initializedfields.qual.InitializedFields;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.UnknownVal;
import org.plumelib.bcelutil.NoConstraintsVisitor;
import org.plumelib.bcelutil.StackTypes;

public final class StackVer {
    private static final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean DEBUG = true;
    private @MonotonicNonNull @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) StackTypes stack_types;
    private @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ArrayList<@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String> messages = new ArrayList();

    public @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) StackTypes get_stack_types() {
        return this.stack_types;
    }

    private void circulationPump(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen m, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ControlFlowGraph cfg, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionContext start, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Frame vanillaFrame, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstConstraintVisitor icv, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ExecutionVisitor ev) {
        Random random = new Random();
        InstructionContextQueue icq = new InstructionContextQueue();
        this.execute(start, vanillaFrame, new ArrayList<InstructionContext>(), icv, ev);
        icq.add(start, new ArrayList<InstructionContext>());
        while (!icq.isEmpty()) {
            InstructionContext u = icq.getIC(0);
            ArrayList<InstructionContext> ec = icq.getEC(0);
            icq.remove(0);
            ArrayList oldchain = (ArrayList)ec.clone();
            ArrayList newchain = (ArrayList)ec.clone();
            newchain.add(u);
            if (u.getInstruction().getInstruction() instanceof RET) {
                RET ret = (RET)u.getInstruction().getInstruction();
                ReturnaddressType t = (ReturnaddressType)u.getOutFrame(oldchain).getLocals().get(ret.getIndex());
                InstructionContext theSuccessor = cfg.contextOf(t.getTarget());
                InstructionContext lastJSR = null;
                int skip_jsr = 0;
                for (int ss = oldchain.size() - 1; ss >= 0; --ss) {
                    if (skip_jsr < 0) {
                        throw new AssertionViolatedException("More RET than JSR in execution chain?!");
                    }
                    if (((InstructionContext)oldchain.get(ss)).getInstruction().getInstruction() instanceof JsrInstruction) {
                        if (skip_jsr == 0) {
                            lastJSR = (InstructionContext)oldchain.get(ss);
                            break;
                        }
                        --skip_jsr;
                    }
                    if (!(((InstructionContext)oldchain.get(ss)).getInstruction().getInstruction() instanceof RET)) continue;
                    ++skip_jsr;
                }
                if (lastJSR == null) {
                    throw new AssertionViolatedException("RET without a JSR before in ExecutionChain?! EC: '" + oldchain + "'.");
                }
                JsrInstruction jsr = (JsrInstruction)lastJSR.getInstruction().getInstruction();
                if (theSuccessor != cfg.contextOf(jsr.physicalSuccessor())) {
                    throw new AssertionViolatedException("RET '" + u.getInstruction() + "' info inconsistent: jump back to '" + theSuccessor + "' or '" + cfg.contextOf(jsr.physicalSuccessor()) + "'?");
                }
                if (this.execute(theSuccessor, u.getOutFrame(oldchain), newchain, icv, ev)) {
                    ArrayList newchainClone = (ArrayList)newchain.clone();
                    icq.add(theSuccessor, newchainClone);
                }
            } else {
                InstructionContext[] succs = u.getSuccessors();
                for (InstructionContext v : succs) {
                    if (!this.execute(v, u.getOutFrame(oldchain), newchain, icv, ev)) continue;
                    ArrayList newchainClone = (ArrayList)newchain.clone();
                    icq.add(v, newchainClone);
                }
            }
            ExceptionHandler[] exc_hds = u.getExceptionHandlers();
            for (ExceptionHandler exc_hd : exc_hds) {
                InstructionContext v = cfg.contextOf(exc_hd.getHandlerStart());
                if (!this.execute(v, new Frame(u.getOutFrame(oldchain).getLocals(), new OperandStack(u.getOutFrame(oldchain).getStack().maxStack(), exc_hd.getExceptionType() == null ? Type.THROWABLE : exc_hd.getExceptionType())), new ArrayList<InstructionContext>(), icv, ev)) continue;
                icq.add(v, new ArrayList<InstructionContext>());
            }
        }
        InstructionHandle ih = start.getInstruction();
        do {
            if (!(ih.getInstruction() instanceof ReturnInstruction) || cfg.isDead(ih)) continue;
            InstructionContext ic = cfg.contextOf(ih);
            Frame f = ic.getOutFrame(new ArrayList<InstructionContext>());
            LocalVariables lvs = f.getLocals();
            for (int i = 0; i < lvs.maxLocals(); ++i) {
                if (!(lvs.get(i) instanceof UninitializedObjectType)) continue;
                this.addMessage("Warning: ReturnInstruction '" + ic + "' may leave method with an uninitialized object in the local variables array '" + lvs + "'.");
            }
            OperandStack os = f.getStack();
            for (int i = 0; i < os.size(); ++i) {
                if (!(os.peek(i) instanceof UninitializedObjectType)) continue;
                this.addMessage("Warning: ReturnInstruction '" + ic + "' may leave method with an uninitialized object on the operand stack '" + os + "'.");
            }
        } while ((ih = ih.getNext()) != null);
    }

    public void invalidReturnTypeError(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Type returnedType, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen m) {
        throw new StructuralCodeConstraintException("Returned type " + returnedType + " does not match Method's return type " + m.getReturnType());
    }

    public @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) VerificationResult do_stack_ver(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) MethodGen mg) {
        ConstantPoolGen constantPoolGen = mg.getConstantPool();
        NoConstraintsVisitor icv = new NoConstraintsVisitor();
        ((InstConstraintVisitor)icv).setConstantPoolGen(constantPoolGen);
        ExecutionVisitor ev = new ExecutionVisitor();
        ev.setConstantPoolGen(constantPoolGen);
        try {
            this.stack_types = new StackTypes(mg);
            ((InstConstraintVisitor)icv).setMethodGen(mg);
            if (!mg.isAbstract() && !mg.isNative()) {
                ControlFlowGraph cfg = new ControlFlowGraph(mg, false);
                Frame f = new Frame(mg.getMaxLocals(), mg.getMaxStack());
                if (!mg.isStatic()) {
                    if (mg.getName().equals("<init>")) {
                        Frame.setThis(new UninitializedObjectType(new ObjectType(mg.getClassName())));
                        f.getLocals().set(0, Frame.getThis());
                    } else {
                        UninitializedObjectType dummy = null;
                        Frame.setThis(dummy);
                        f.getLocals().set(0, new ObjectType(mg.getClassName()));
                    }
                }
                Type[] argtypes = mg.getArgumentTypes();
                int twoslotoffset = 0;
                for (int j = 0; j < argtypes.length; ++j) {
                    if (argtypes[j] == Type.SHORT || argtypes[j] == Type.BYTE || argtypes[j] == Type.CHAR || argtypes[j] == Type.BOOLEAN) {
                        argtypes[j] = Type.INT;
                    }
                    f.getLocals().set(twoslotoffset + j + (mg.isStatic() ? 0 : 1), argtypes[j]);
                    if (argtypes[j].getSize() != 2) continue;
                    f.getLocals().set(++twoslotoffset + j + (mg.isStatic() ? 0 : 1), Type.UNKNOWN);
                }
                this.circulationPump(mg, cfg, cfg.contextOf(mg.getInstructionList().getStart()), f, icv, ev);
            }
        }
        catch (VerifierConstraintViolatedException ce) {
            ce.extendMessage("Constraint violated in method '" + mg + "':\n", "");
            return new VerificationResult(2, ce.getMessage());
        }
        catch (RuntimeException re) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            re.printStackTrace(pw);
            throw new AssertionViolatedException("Some RuntimeException occured while verify()ing class '" + mg.getClassName() + "', method '" + mg + "'. Original RuntimeException's stack trace:\n---\n" + sw + "---\n", re);
        }
        return VerificationResult.VR_OK;
    }

    @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean execute(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionContext ic, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) Frame inFrame, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ArrayList<@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionContext> executionPredecessors, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstConstraintVisitor icv, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ExecutionVisitor ev) {
        this.stack_types.set(ic.getInstruction().getPosition(), inFrame);
        return ic.execute(inFrame, executionPredecessors, icv, ev);
    }

    public void addMessage(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) String message) {
        this.messages.add(message);
    }

    private static final class InstructionContextQueue {
        private final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) List<@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionContext> ics = new Vector<InstructionContext>();
        private final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) List<@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ArrayList<@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionContext>> ecs = new Vector<ArrayList<InstructionContext>>();

        private InstructionContextQueue() {
        }

        public void add(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionContext ic, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ArrayList<@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionContext> executionChain) {
            this.ics.add(ic);
            this.ecs.add(executionChain);
        }

        public @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) boolean isEmpty() {
            return this.ics.isEmpty();
        }

        public void remove(@NonNegative @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) int i) {
            this.ics.remove(i);
            this.ecs.remove(i);
        }

        public @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionContext getIC(@NonNegative @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) int i) {
            return this.ics.get(i);
        }

        public @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) ArrayList<@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) InstructionContext> getEC(@NonNegative @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) int i) {
            return this.ecs.get(i);
        }

        public @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownVal @Signed @InitializedFields(value={}) int size() {
            return this.ics.size();
        }
    }
}

