/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.util.LinkedHashMap;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.AbstractClassPathRepository;
import org.apache.bcel.util.ClassPath;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class LruCacheClassPathRepository
extends AbstractClassPathRepository {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LinkedHashMap<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass> loadedClasses;

    public LruCacheClassPathRepository(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath path, final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int cacheSize) {
        super(path);
        if (cacheSize < 1) {
            throw new IllegalArgumentException("cacheSize must be a positive number.");
        }
        int initialCapacity = (int)(0.75 * (double)cacheSize);
        boolean accessOrder = true;
        this.loadedClasses = new LinkedHashMap<String, JavaClass>(initialCapacity, (float)cacheSize, true){
            private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long serialVersionUID = 1L;

            @Override
            protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean removeEldestEntry( @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map.Entry<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass> eldest) {
                return this.size() > cacheSize;
            }
        };
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass findClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String className) {
        return this.loadedClasses.get(className);
    }

    @Override
    public void storeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass javaClass) {
        this.loadedClasses.put(javaClass.getClassName(), javaClass);
        javaClass.setRepository(this);
    }

    @Override
    public void removeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass javaClass) {
        this.loadedClasses.remove(javaClass.getClassName());
    }

    @Override
    public void clear() {
        this.loadedClasses.clear();
    }
}

