/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.util.ModularRuntimeImage;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ClassPath
implements Closeable {
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FilenameFilter ARCHIVE_FILTER = (dir, name) -> (name = name.toLowerCase(Locale.ENGLISH)).endsWith(".zip") || name.endsWith(".jar");
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FilenameFilter MODULES_FILTER = (dir, name) -> {
        name = name.toLowerCase(Locale.ENGLISH);
        return name.endsWith(".jmod");
    };
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath SYSTEM_CLASS_PATH = new ClassPath(ClassPath.getClassPath());
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String classPath;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath parent;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AbstractPathEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] paths;

    private static void addJdkModules(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String javaHome, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String> list) {
        File modulesDir;
        String modulesPath = System.getProperty("java.modules.path");
        if (modulesPath == null || modulesPath.trim().isEmpty()) {
            modulesPath = javaHome + File.separator + "jmods";
        }
        if ((modulesDir = new File(modulesPath)).exists()) {
            String[] modules;
            for (String module : modules = modulesDir.list(MODULES_FILTER)) {
                list.add(modulesDir.getPath() + File.separatorChar + module);
            }
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getClassPath() {
        String classPathProp = System.getProperty("java.class.path");
        String bootClassPathProp = System.getProperty("sun.boot.class.path");
        String extDirs = System.getProperty("java.ext.dirs");
        String javaHome = System.getProperty("java.home");
        ArrayList<String> list = new ArrayList<String>();
        Path modulesPath = Paths.get(javaHome, new String[0]).resolve("lib/modules");
        if (Files.exists(modulesPath, new LinkOption[0]) && Files.isRegularFile(modulesPath, new LinkOption[0])) {
            list.add(modulesPath.toAbsolutePath().toString());
        }
        ClassPath.addJdkModules(javaHome, list);
        ClassPath.getPathComponents(classPathProp, list);
        ClassPath.getPathComponents(bootClassPathProp, list);
        ArrayList<String> dirs = new ArrayList<String>();
        ClassPath.getPathComponents(extDirs, dirs);
        for (String d : dirs) {
            File ext_dir = new File(d);
            String[] extensions = ext_dir.list(ARCHIVE_FILTER);
            if (extensions == null) continue;
            for (String extension : extensions) {
                list.add(ext_dir.getPath() + File.separatorChar + extension);
            }
        }
        StringBuilder buf = new StringBuilder();
        String separator = "";
        for (String path : list) {
            buf.append(separator);
            separator = File.pathSeparator;
            buf.append(path);
        }
        return buf.toString().intern();
    }

    private static void getPathComponents(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String path, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String> list) {
        if (path != null) {
            StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken();
                File file = new File(name);
                if (!file.exists()) continue;
                list.add(name);
            }
        }
    }

    static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String packageToFolder(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        return name.replace('.', '/');
    }

    @Deprecated
    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    public ClassPath(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath parent, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String classPath) {
        this(classPath);
        this.parent = parent;
    }

    public ClassPath(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String classPath) {
        this.classPath = classPath;
        ArrayList<AbstractPathEntry> list = new ArrayList<AbstractPathEntry>();
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            if (path.isEmpty()) continue;
            File file = new File(path);
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    list.add(new Dir(path));
                    continue;
                }
                if (path.endsWith(".jmod")) {
                    list.add(new Module(new ZipFile(file)));
                    continue;
                }
                if (path.endsWith(ModularRuntimeImage.MODULES_PATH)) {
                    list.add(new JrtModules(ModularRuntimeImage.MODULES_PATH));
                    continue;
                }
                list.add(new Jar(new ZipFile(file)));
            }
            catch (IOException e) {
                if (!path.endsWith(".zip") && !path.endsWith(".jar")) continue;
                System.err.println("CLASSPATH component " + file + ": " + e);
            }
        }
        this.paths = new AbstractPathEntry[list.size()];
        list.toArray(this.paths);
    }

    @Override
    public void close() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        if (this.paths != null) {
            for (AbstractPathEntry path : this.paths) {
                path.close();
            }
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object o) {
        if (o instanceof ClassPath) {
            ClassPath cp = (ClassPath)o;
            return this.classPath.equals(cp.toString());
        }
        return false;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getBytes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        return this.getBytes(name, ".class");
    }

    /*
     * Loose catch block
     */
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getBytes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        try (FilterInputStream dis = null;){
            try (InputStream inputStream = this.getInputStream(name, suffix);){
                if (inputStream == null) {
                    throw new IOException("Couldn't find: " + name + suffix);
                }
                dis = new DataInputStream(inputStream);
                byte[] bytes = new byte[inputStream.available()];
                ((DataInputStream)dis).readFully(bytes);
                byte[] byArray = bytes;
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        return this.getClassFile(name, ".class");
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        ClassFile cf = null;
        if (this.parent != null) {
            cf = this.parent.getClassFileInternal(name, suffix);
        }
        if (cf == null) {
            cf = this.getClassFileInternal(name, suffix);
        }
        if (cf != null) {
            return cf;
        }
        throw new IOException("Couldn't find: " + name + suffix);
    }

    private @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown ClassFile getClassFileInternal(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        for (AbstractPathEntry path : this.paths) {
            ClassFile cf = path.getClassFile(name, suffix);
            if (cf == null) continue;
            return cf;
        }
        return null;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getInputStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        return this.getInputStream(ClassPath.packageToFolder(name), ".class");
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getInputStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(name + suffix);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream != null) {
            return inputStream;
        }
        return this.getClassFile(name, suffix).getInputStream();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getPath(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        int index = name.lastIndexOf(46);
        String suffix = "";
        if (index > 0) {
            suffix = name.substring(index);
            name = name.substring(0, index);
        }
        return this.getPath(name, suffix);
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown String getPath(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        return this.getClassFile(name, suffix).getPath();
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown URL getResource(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        for (AbstractPathEntry path : this.paths) {
            URL url = path.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown InputStream getResourceAsStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        for (AbstractPathEntry path : this.paths) {
            InputStream is = path.getResourceAsStream(name);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Enumeration<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown URL> getResources(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        Vector<URL> results = new Vector<URL>();
        for (AbstractPathEntry path : this.paths) {
            URL url = path.getResource(name);
            if (url == null) continue;
            results.add(url);
        }
        return results.elements();
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        if (this.parent != null) {
            return this.classPath.hashCode() + this.parent.hashCode();
        }
        return this.classPath.hashCode();
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        if (this.parent != null) {
            return this.parent + File.pathSeparator + this.classPath;
        }
        return this.classPath;
    }

    private static class Module
    extends AbstractZip {
        Module(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ZipFile zip) {
            super(zip);
        }

        @Override
        protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toEntryName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) {
            return "classes/" + ClassPath.packageToFolder(name) + suffix;
        }
    }

    private static class JrtModules
    extends AbstractPathEntry {
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModularRuntimeImage modularRuntimeImage = new ModularRuntimeImage();
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JrtModule @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] modules;

        public JrtModules(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String path) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
            List<Path> list = this.modularRuntimeImage.list(path);
            this.modules = new JrtModule[list.size()];
            for (int i = 0; i < this.modules.length; ++i) {
                this.modules[i] = new JrtModule(list.get(i));
            }
        }

        @Override
        public void close() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
            if (this.modules != null) {
                for (JrtModule module : this.modules) {
                    module.close();
                }
            }
            if (this.modularRuntimeImage != null) {
                this.modularRuntimeImage.close();
            }
        }

        @Override
        @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
            for (JrtModule module : this.modules) {
                ClassFile classFile = module.getClassFile(name, suffix);
                if (classFile == null) continue;
                return classFile;
            }
            return null;
        }

        @Override
        @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown URL getResource(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
            for (JrtModule module : this.modules) {
                URL url = module.getResource(name);
                if (url == null) continue;
                return url;
            }
            return null;
        }

        @Override
        @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown InputStream getResourceAsStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
            for (JrtModule module : this.modules) {
                InputStream inputStream = module.getResourceAsStream(name);
                if (inputStream == null) continue;
                return inputStream;
            }
            return null;
        }

        @SideEffectFree
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
            return Arrays.toString(this.modules);
        }
    }

    private static class JrtModule
    extends AbstractPathEntry {
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Path modulePath;

        public JrtModule(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Path modulePath) {
            this.modulePath = Objects.requireNonNull(modulePath, "modulePath");
        }

        @Override
        public void close() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        }

        @Override
        @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
            final Path resolved = this.modulePath.resolve(ClassPath.packageToFolder(name) + suffix);
            if (Files.exists(resolved, new LinkOption[0])) {
                return new ClassFile(){

                    @Override
                    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getBase() {
                        return resolved.getFileName().toString();
                    }

                    @Override
                    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getInputStream() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
                        return Files.newInputStream(resolved, new OpenOption[0]);
                    }

                    @Override
                    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown String getPath() {
                        return resolved.toString();
                    }

                    @Override
                    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long getSize() {
                        try {
                            return Files.size(resolved);
                        }
                        catch (IOException e) {
                            return 0L;
                        }
                    }

                    @Override
                    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long getTime() {
                        try {
                            return Files.getLastModifiedTime(resolved, new LinkOption[0]).toMillis();
                        }
                        catch (IOException e) {
                            return 0L;
                        }
                    }
                };
            }
            return null;
        }

        @Override
        @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown URL getResource(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
            Path resovled = this.modulePath.resolve(name);
            try {
                return Files.exists(resovled, new LinkOption[0]) ? new URL("jrt:" + this.modulePath + "/" + name) : null;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown InputStream getResourceAsStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
            try {
                return Files.newInputStream(this.modulePath.resolve(name), new OpenOption[0]);
            }
            catch (IOException e) {
                return null;
            }
        }

        @SideEffectFree
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
            return this.modulePath.toString();
        }
    }

    private static class Jar
    extends AbstractZip {
        Jar(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ZipFile zip) {
            super(zip);
        }

        @Override
        protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toEntryName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) {
            return ClassPath.packageToFolder(name) + suffix;
        }
    }

    private static class Dir
    extends AbstractPathEntry {
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String dir;

        Dir(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String d) {
            this.dir = d;
        }

        @Override
        public void close() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        }

        @Override
        @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
            final File file = new File(this.dir + File.separatorChar + name.replace('.', File.separatorChar) + suffix);
            return file.exists() ? new ClassFile(){

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getBase() {
                    return dir;
                }

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getInputStream() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
                    return new FileInputStream(file);
                }

                @Override
                public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown String getPath() {
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        return null;
                    }
                }

                @Override
                public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long getSize() {
                    return file.length();
                }

                @Override
                public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long getTime() {
                    return file.lastModified();
                }
            } : null;
        }

        @Override
        @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown URL getResource(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
            File file = this.toFile(name);
            try {
                return file.exists() ? file.toURI().toURL() : null;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown InputStream getResourceAsStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
            File file = this.toFile(name);
            try {
                return file.exists() ? new FileInputStream(file) : null;
            }
            catch (IOException e) {
                return null;
            }
        }

        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown File toFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
            return new File(this.dir + File.separatorChar + name.replace('/', File.separatorChar));
        }

        @SideEffectFree
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
            return this.dir;
        }
    }

    public static interface ClassFile {
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getBase();

        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getInputStream() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException;

        public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown String getPath();

        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long getSize();

        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long getTime();
    }

    private static abstract class AbstractZip
    extends AbstractPathEntry {
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ZipFile zipFile;

        AbstractZip(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ZipFile zipFile) {
            this.zipFile = Objects.requireNonNull(zipFile, "zipFile");
        }

        @Override
        public void close() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
            if (this.zipFile != null) {
                this.zipFile.close();
            }
        }

        @Override
        @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
            final ZipEntry entry = this.zipFile.getEntry(this.toEntryName(name, suffix));
            if (entry == null) {
                return null;
            }
            return new ClassFile(){

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getBase() {
                    return zipFile.getName();
                }

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getInputStream() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
                    return zipFile.getInputStream(entry);
                }

                @Override
                public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown String getPath() {
                    return entry.toString();
                }

                @Override
                public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long getSize() {
                    return entry.getSize();
                }

                @Override
                public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long getTime() {
                    return entry.getTime();
                }
            };
        }

        @Override
        @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown URL getResource(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
            ZipEntry entry = this.zipFile.getEntry(name);
            try {
                return entry != null ? new URL("jar:file:" + this.zipFile.getName() + "!/" + name) : null;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown InputStream getResourceAsStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
            ZipEntry entry = this.zipFile.getEntry(name);
            try {
                return entry != null ? this.zipFile.getInputStream(entry) : null;
            }
            catch (IOException e) {
                return null;
            }
        }

        protected abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toEntryName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String var1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String var2);

        @SideEffectFree
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
            return this.zipFile.getName();
        }
    }

    private static abstract class AbstractPathEntry
    implements Closeable {
        private AbstractPathEntry() {
        }

        abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String var1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String var2) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException;

        abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown URL getResource(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String var1);

        abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream getResourceAsStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String var1);
    }
}

