/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.AllocationInstruction;
import org.apache.bcel.generic.ArrayInstruction;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConst;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.BCELifier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

class BCELFactory
extends EmptyVisitor {
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String CONSTANT_PREFIX = Const.class.getSimpleName() + ".";
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen _mg;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown PrintWriter _out;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen _cp;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle> branch_map = new HashMap<Instruction, InstructionHandle>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BranchInstruction> branches = new ArrayList<BranchInstruction>();

    BCELFactory(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodGen mg, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown PrintWriter out) {
        this._mg = mg;
        this._cp = mg.getConstantPool();
        this._out = out;
    }

    public void start() {
        if (!this._mg.isAbstract() && !this._mg.isNative()) {
            for (InstructionHandle ih = this._mg.getInstructionList().getStart(); ih != null; ih = ih.getNext()) {
                Instruction i = ih.getInstruction();
                if (i instanceof BranchInstruction) {
                    this.branch_map.put(i, ih);
                }
                if (ih.hasTargeters()) {
                    if (i instanceof BranchInstruction) {
                        this._out.println("    InstructionHandle ih_" + ih.getPosition() + ";");
                    } else {
                        this._out.print("    InstructionHandle ih_" + ih.getPosition() + " = ");
                    }
                } else {
                    this._out.print("    ");
                }
                if (this.visitInstruction(i)) continue;
                i.accept(this);
            }
            this.updateBranchTargets();
            this.updateExceptionHandlers();
        }
    }

    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean visitInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction i) {
        short opcode = i.getOpcode();
        if (InstructionConst.getInstruction(opcode) != null && !(i instanceof ConstantPushInstruction) && !(i instanceof ReturnInstruction)) {
            this._out.println("il.append(InstructionConst." + i.getName().toUpperCase(Locale.ENGLISH) + ");");
            return true;
        }
        return false;
    }

    @Override
    public void visitLocalVariableInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableInstruction i) {
        short opcode = i.getOpcode();
        Type type = i.getType(this._cp);
        if (opcode == 132) {
            this._out.println("il.append(new IINC(" + i.getIndex() + ", " + ((IINC)i).getIncrement() + "));");
        } else {
            String kind = opcode < 54 ? "Load" : "Store";
            this._out.println("il.append(_factory.create" + kind + "(" + BCELifier.printType(type) + ", " + i.getIndex() + "));");
        }
    }

    @Override
    public void visitArrayInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArrayInstruction i) {
        short opcode = i.getOpcode();
        Type type = i.getType(this._cp);
        String kind = opcode < 79 ? "Load" : "Store";
        this._out.println("il.append(_factory.createArray" + kind + "(" + BCELifier.printType(type) + "));");
    }

    @Override
    public void visitFieldInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FieldInstruction i) {
        short opcode = i.getOpcode();
        String class_name = i.getClassName(this._cp);
        String field_name = i.getFieldName(this._cp);
        Type type = i.getFieldType(this._cp);
        this._out.println("il.append(_factory.createFieldAccess(\"" + class_name + "\", \"" + field_name + "\", " + BCELifier.printType(type) + ", " + CONSTANT_PREFIX + Const.getOpcodeName(opcode).toUpperCase(Locale.ENGLISH) + "));");
    }

    @Override
    public void visitInvokeInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InvokeInstruction i) {
        short opcode = i.getOpcode();
        String class_name = i.getClassName(this._cp);
        String method_name = i.getMethodName(this._cp);
        Type type = i.getReturnType(this._cp);
        Type[] arg_types = i.getArgumentTypes(this._cp);
        this._out.println("il.append(_factory.createInvoke(\"" + class_name + "\", \"" + method_name + "\", " + BCELifier.printType(type) + ", " + BCELifier.printArgumentTypes(arg_types) + ", " + CONSTANT_PREFIX + Const.getOpcodeName(opcode).toUpperCase(Locale.ENGLISH) + "));");
    }

    @Override
    public void visitAllocationInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AllocationInstruction i) {
        Type type = i instanceof CPInstruction ? ((CPInstruction)((Object)i)).getType(this._cp) : ((NEWARRAY)i).getType();
        short opcode = ((Instruction)((Object)i)).getOpcode();
        short dim = 1;
        switch (opcode) {
            case 187: {
                this._out.println("il.append(_factory.createNew(\"" + ((ObjectType)type).getClassName() + "\"));");
                break;
            }
            case 197: {
                dim = ((MULTIANEWARRAY)i).getDimensions();
            }
            case 188: 
            case 189: {
                if (type instanceof ArrayType) {
                    type = ((ArrayType)type).getBasicType();
                }
                this._out.println("il.append(_factory.createNewArray(" + BCELifier.printType(type) + ", (short) " + dim + "));");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled opcode: " + opcode);
            }
        }
    }

    private void createConstant(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object value) {
        String embed = value.toString();
        if (value instanceof String) {
            embed = '\"' + Utility.convertString(embed) + '\"';
        } else if (value instanceof Character) {
            embed = "(char)0x" + Integer.toHexString(((Character)value).charValue());
        } else if (value instanceof Float) {
            embed = embed + "f";
        } else if (value instanceof Long) {
            embed = embed + "L";
        } else if (value instanceof ObjectType) {
            ObjectType ot = (ObjectType)value;
            embed = "new ObjectType(\"" + ot.getClassName() + "\")";
        }
        this._out.println("il.append(new PUSH(_cp, " + embed + "));");
    }

    @Override
    public void visitLDC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LDC i) {
        this.createConstant(i.getValue(this._cp));
    }

    @Override
    public void visitLDC2_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LDC2_W i) {
        this.createConstant(i.getValue(this._cp));
    }

    @Override
    public void visitConstantPushInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPushInstruction i) {
        this.createConstant(i.getValue());
    }

    @Override
    public void visitINSTANCEOF(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INSTANCEOF i) {
        Type type = i.getType(this._cp);
        this._out.println("il.append(new INSTANCEOF(_cp.addClass(" + BCELifier.printType(type) + ")));");
    }

    @Override
    public void visitCHECKCAST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CHECKCAST i) {
        Type type = i.getType(this._cp);
        this._out.println("il.append(_factory.createCheckCast(" + BCELifier.printType(type) + "));");
    }

    @Override
    public void visitReturnInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ReturnInstruction i) {
        Type type = i.getType(this._cp);
        this._out.println("il.append(_factory.createReturn(" + BCELifier.printType(type) + "));");
    }

    @Override
    public void visitBranchInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BranchInstruction bi) {
        BranchHandle bh = (BranchHandle)this.branch_map.get(bi);
        int pos = bh.getPosition();
        String name = bi.getName() + "_" + pos;
        if (bi instanceof Select) {
            int i;
            Select s = (Select)bi;
            this.branches.add(bi);
            StringBuilder args = new StringBuilder("new int[] { ");
            int[] matchs = s.getMatchs();
            for (i = 0; i < matchs.length; ++i) {
                args.append(matchs[i]);
                if (i >= matchs.length - 1) continue;
                args.append(", ");
            }
            args.append(" }");
            this._out.print("Select " + name + " = new " + bi.getName().toUpperCase(Locale.ENGLISH) + "(" + args + ", new InstructionHandle[] { ");
            for (i = 0; i < matchs.length; ++i) {
                this._out.print("null");
                if (i >= matchs.length - 1) continue;
                this._out.print(", ");
            }
            this._out.println(" }, null);");
        } else {
            String target;
            int t_pos = bh.getTarget().getPosition();
            if (pos > t_pos) {
                target = "ih_" + t_pos;
            } else {
                this.branches.add(bi);
                target = "null";
            }
            this._out.println("    BranchInstruction " + name + " = _factory.createBranchInstruction(" + CONSTANT_PREFIX + bi.getName().toUpperCase(Locale.ENGLISH) + ", " + target + ");");
        }
        if (bh.hasTargeters()) {
            this._out.println("    ih_" + pos + " = il.append(" + name + ");");
        } else {
            this._out.println("    il.append(" + name + ");");
        }
    }

    @Override
    public void visitRET(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown RET i) {
        this._out.println("il.append(new RET(" + i.getIndex() + ")));");
    }

    private void updateBranchTargets() {
        for (BranchInstruction bi : this.branches) {
            BranchHandle bh = (BranchHandle)this.branch_map.get(bi);
            int pos = bh.getPosition();
            String name = bi.getName() + "_" + pos;
            int t_pos = bh.getTarget().getPosition();
            this._out.println("    " + name + ".setTarget(ih_" + t_pos + ");");
            if (!(bi instanceof Select)) continue;
            InstructionHandle[] ihs = ((Select)bi).getTargets();
            for (int j = 0; j < ihs.length; ++j) {
                t_pos = ihs[j].getPosition();
                this._out.println("    " + name + ".setTarget(" + j + ", ih_" + t_pos + ");");
            }
        }
    }

    private void updateExceptionHandlers() {
        CodeExceptionGen[] handlers;
        for (CodeExceptionGen h : handlers = this._mg.getExceptionHandlers()) {
            String type = h.getCatchType() == null ? "null" : BCELifier.printType(h.getCatchType());
            this._out.println("    method.addExceptionHandler(ih_" + h.getStartPC().getPosition() + ", ih_" + h.getEndPC().getPosition() + ", ih_" + h.getHandlerPC().getPosition() + ", " + type + ");");
        }
    }
}

