/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.util.ByteSequence;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.checker.signature.qual.FieldDescriptor;
import org.checkerframework.checker.signature.qual.FullyQualifiedName;
import org.checkerframework.checker.signature.qual.InternalForm;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public abstract class Utility {
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ThreadLocal<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Integer> consumed_chars;
    private static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean wide;
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int FREE_CHARS = 48;
    private static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] CHAR_MAP;
    private static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] MAP_CHAR;
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown char ESCAPE_CHAR = '$';

    private static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int unwrap(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ThreadLocal<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Integer> tl) {
        return tl.get();
    }

    private static void wrap(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ThreadLocal<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Integer> tl, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int value) {
        tl.set(value);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String accessToString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags) {
        return Utility.accessToString(access_flags, false);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String accessToString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean for_class) {
        StringBuilder buf = new StringBuilder();
        int p = 0;
        int i = 0;
        while (p < 32768) {
            p = Utility.pow2(i);
            if ((access_flags & p) != 0 && (!for_class || p != 32 && p != 512)) {
                buf.append(Const.getAccessName(i)).append(" ");
            }
            ++i;
        }
        return buf.toString().trim();
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String classOrInterface(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags) {
        return (access_flags & 0x200) != 0 ? "interface" : "class";
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String codeToString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] code, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean verbose) {
        StringBuilder buf = new StringBuilder(code.length * 20);
        try (ByteSequence stream = new ByteSequence(code);){
            int i;
            for (i = 0; i < index; ++i) {
                Utility.codeToString(stream, constant_pool, verbose);
            }
            i = 0;
            while (stream.available() > 0) {
                if (length < 0 || i < length) {
                    String indices = Utility.fillup(stream.getIndex() + ":", 6, true, ' ');
                    buf.append(indices).append(Utility.codeToString(stream, constant_pool, verbose)).append('\n');
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new ClassFormatException("Byte code error: " + buf.toString(), e);
        }
        return buf.toString();
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String codeToString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] code, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length) {
        return Utility.codeToString(code, constant_pool, index, length, true);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String codeToString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ByteSequence bytes, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean verbose) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        short opcode = (short)bytes.readUnsignedByte();
        int default_offset = 0;
        int no_pad_bytes = 0;
        StringBuilder buf = new StringBuilder(Const.getOpcodeName(opcode));
        if (opcode == 170 || opcode == 171) {
            int remainder = bytes.getIndex() % 4;
            no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
            for (int i = 0; i < no_pad_bytes; ++i) {
                byte b = bytes.readByte();
                if (b == 0) continue;
                System.err.println("Warning: Padding byte != 0 in " + Const.getOpcodeName(opcode) + ":" + b);
            }
            default_offset = bytes.readInt();
        }
        switch (opcode) {
            case 170: {
                int i;
                int low = bytes.readInt();
                int high = bytes.readInt();
                int offset = bytes.getIndex() - 12 - no_pad_bytes - 1;
                buf.append("\tdefault = ").append(default_offset += offset).append(", low = ").append(low).append(", high = ").append(high).append("(");
                int[] jump_table = new int[high - low + 1];
                for (i = 0; i < jump_table.length; ++i) {
                    jump_table[i] = offset + bytes.readInt();
                    buf.append(jump_table[i]);
                    if (i >= jump_table.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
                break;
            }
            case 171: {
                int i;
                int npairs = bytes.readInt();
                int offset = bytes.getIndex() - 8 - no_pad_bytes - 1;
                int[] match = new int[npairs];
                int[] jump_table = new int[npairs];
                buf.append("\tdefault = ").append(default_offset += offset).append(", npairs = ").append(npairs).append(" (");
                for (i = 0; i < npairs; ++i) {
                    match[i] = bytes.readInt();
                    jump_table[i] = offset + bytes.readInt();
                    buf.append("(").append(match[i]).append(", ").append(jump_table[i]).append(")");
                    if (i >= npairs - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                buf.append("\t\t#").append(bytes.getIndex() - 1 + bytes.readShort());
                break;
            }
            case 200: 
            case 201: {
                buf.append("\t\t#").append(bytes.getIndex() - 1 + bytes.readInt());
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int vindex;
                if (wide) {
                    vindex = bytes.readUnsignedShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                }
                buf.append("\t\t%").append(vindex);
                break;
            }
            case 196: {
                wide = true;
                buf.append("\t(wide)");
                break;
            }
            case 188: {
                buf.append("\t\t<").append(Const.getTypeName(bytes.readByte())).append(">");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t").append(constant_pool.constantToString(index, (byte)9)).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 187: 
            case 192: {
                buf.append("\t");
            }
            case 193: {
                int index = bytes.readUnsignedShort();
                buf.append("\t<").append(constant_pool.constantToString(index, (byte)7)).append(">").append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 183: 
            case 184: {
                int index = bytes.readUnsignedShort();
                Constant c = constant_pool.getConstant(index);
                buf.append("\t").append(constant_pool.constantToString(index, c.getTag())).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 182: {
                int index = bytes.readUnsignedShort();
                buf.append("\t").append(constant_pool.constantToString(index, (byte)10)).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 185: {
                int index = bytes.readUnsignedShort();
                int nargs = bytes.readUnsignedByte();
                buf.append("\t").append(constant_pool.constantToString(index, (byte)11)).append(verbose ? " (" + index + ")\t" : "").append(nargs).append("\t").append(bytes.readUnsignedByte());
                break;
            }
            case 186: {
                int index = bytes.readUnsignedShort();
                buf.append("\t").append(constant_pool.constantToString(index, (byte)18)).append(verbose ? " (" + index + ")\t" : "").append(bytes.readUnsignedByte()).append(bytes.readUnsignedByte());
                break;
            }
            case 19: 
            case 20: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t").append(constant_pool.constantToString(index, constant_pool.getConstant(index).getTag())).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 18: {
                int index = bytes.readUnsignedByte();
                buf.append("\t\t").append(constant_pool.constantToString(index, constant_pool.getConstant(index).getTag())).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 189: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t<").append(Utility.compactClassName(constant_pool.getConstantString(index, (byte)7), false)).append(">").append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 197: {
                int index = bytes.readUnsignedShort();
                int dimensions = bytes.readUnsignedByte();
                buf.append("\t<").append(Utility.compactClassName(constant_pool.getConstantString(index, (byte)7), false)).append(">\t").append(dimensions).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 132: {
                short constant;
                int vindex;
                if (wide) {
                    vindex = bytes.readUnsignedShort();
                    constant = bytes.readShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                    constant = bytes.readByte();
                }
                buf.append("\t\t%").append(vindex).append("\t").append(constant);
                break;
            }
            default: {
                if (Const.getNoOfOperands(opcode) <= 0) break;
                int i = 0;
                while ((long)i < Const.getOperandTypeCount(opcode)) {
                    buf.append("\t\t");
                    switch (Const.getOperandType(opcode, i)) {
                        case 8: {
                            buf.append(bytes.readByte());
                            break;
                        }
                        case 9: {
                            buf.append(bytes.readShort());
                            break;
                        }
                        case 10: {
                            buf.append(bytes.readInt());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unreachable default case reached!");
                        }
                    }
                    ++i;
                }
                break block0;
            }
        }
        return buf.toString();
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String codeToString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ByteSequence bytes, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        return Utility.codeToString(bytes, constant_pool, true);
    }

    public static @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String compactClassName(@InternalForm @UnknownInterned @UnknownKeyFor @NonNull @Initialized String str) {
        return Utility.compactClassName(str, true);
    }

    public static @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String compactClassName(@InternalForm @UnknownInterned @UnknownKeyFor @NonNull @Initialized String str, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean chopit) {
        return Utility.compactClassName(str, "java.lang.", chopit);
    }

    public static @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String compactClassName(@InternalForm @UnknownInterned @UnknownKeyFor @NonNull @Initialized String strIn, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String prefix, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean chopit) {
        int len = prefix.length();
        String str = strIn.replace('/', '.');
        if (chopit && str.startsWith(prefix) && str.substring(len).indexOf(46) == -1) {
            str = str.substring(len);
        }
        return str;
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int setBit(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int flag, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
        return flag | Utility.pow2(i);
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int clearBit(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int flag, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
        int bit = Utility.pow2(i);
        return (flag & bit) == 0 ? flag : flag ^ bit;
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isSet(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int flag, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
        return (flag & Utility.pow2(i)) != 0;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String methodTypeToSignature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String ret, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] argv) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        String str;
        StringBuilder buf = new StringBuilder("(");
        if (argv != null) {
            for (String element : argv) {
                str = Utility.getSignature(element);
                if (str.endsWith("V")) {
                    throw new ClassFormatException("Invalid type: " + element);
                }
                buf.append(str);
            }
        }
        str = Utility.getSignature(ret);
        buf.append(")").append(str);
        return buf.toString();
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] methodSignatureArgumentTypes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        return Utility.methodSignatureArgumentTypes(signature, true);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] methodSignatureArgumentTypes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean chopit) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        ArrayList<String> vec = new ArrayList<String>();
        try {
            int index = signature.indexOf(40) + 1;
            if (index <= 0) {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            while (signature.charAt(index) != ')') {
                vec.add(Utility.typeSignatureToString(signature.substring(index), chopit));
                index += Utility.unwrap(consumed_chars);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
        return vec.toArray(new String[vec.size()]);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String methodSignatureReturnType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        return Utility.methodSignatureReturnType(signature, true);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String methodSignatureReturnType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean chopit) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        String type;
        try {
            int index = signature.lastIndexOf(41) + 1;
            if (index <= 0) {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            type = Utility.typeSignatureToString(signature.substring(index), chopit);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
        return type;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String methodSignatureToString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String access) {
        return Utility.methodSignatureToString(signature, name, access, true);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String methodSignatureToString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String access, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean chopit) {
        return Utility.methodSignatureToString(signature, name, access, chopit, null);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String methodSignatureToString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String access, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean chopit, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableTable vars) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        String type;
        StringBuilder buf = new StringBuilder("(");
        int var_index = access.contains("static") ? 0 : 1;
        try {
            int index = signature.indexOf(40) + 1;
            if (index <= 0) {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            while (signature.charAt(index) != ')') {
                String param_type = Utility.typeSignatureToString(signature.substring(index), chopit);
                buf.append(param_type);
                if (vars != null) {
                    LocalVariable l = vars.getLocalVariable(var_index, 0);
                    if (l != null) {
                        buf.append(" ").append(l.getName());
                    }
                } else {
                    buf.append(" arg").append(var_index);
                }
                var_index = "double".equals(param_type) || "long".equals(param_type) ? (var_index += 2) : ++var_index;
                buf.append(", ");
                index += Utility.unwrap(consumed_chars);
            }
            type = Utility.typeSignatureToString(signature.substring(++index), chopit);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
        if (buf.length() > 1) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        return access + (access.length() > 0 ? " " : "") + type + " " + name + buf.toString();
    }

    private static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int pow2(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int n) {
        return 1 << n;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String replace(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String str, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String old, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String new_) {
        try {
            if (str.contains(old)) {
                int index;
                StringBuilder buf = new StringBuilder();
                int old_index = 0;
                while ((index = str.indexOf(old, old_index)) != -1) {
                    buf.append(str.substring(old_index, index));
                    buf.append(new_);
                    old_index = index + old.length();
                }
                buf.append(str.substring(old_index));
                str = buf.toString();
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            System.err.println(e);
        }
        return str;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signatureToString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) {
        return Utility.signatureToString(signature, true);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signatureToString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean chopit) {
        String type = "";
        String typeParams = "";
        int index = 0;
        if (signature.charAt(0) == '<') {
            typeParams = Utility.typeParamTypesToString(signature, chopit);
            index += Utility.unwrap(consumed_chars);
        }
        if (signature.charAt(index) == '(') {
            type = typeParams + Utility.typeSignaturesToString(signature.substring(index), chopit, ')');
            type = type + Utility.typeSignatureToString(signature.substring(index += Utility.unwrap(consumed_chars)), chopit);
            index += Utility.unwrap(consumed_chars);
            return type;
        }
        type = Utility.typeSignatureToString(signature.substring(index), chopit);
        if (typeParams.length() == 0 && (index += Utility.unwrap(consumed_chars)) == signature.length()) {
            return type;
        }
        StringBuilder typeClass = new StringBuilder(typeParams);
        typeClass.append(" extends ");
        typeClass.append(type);
        if (index < signature.length()) {
            typeClass.append(" implements ");
            typeClass.append(Utility.typeSignatureToString(signature.substring(index), chopit));
            index += Utility.unwrap(consumed_chars);
        }
        while (index < signature.length()) {
            typeClass.append(", ");
            typeClass.append(Utility.typeSignatureToString(signature.substring(index), chopit));
            index += Utility.unwrap(consumed_chars);
        }
        return typeClass.toString();
    }

    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String typeParamTypesToString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean chopit) {
        StringBuilder typeParams = new StringBuilder("<");
        int index = 1;
        typeParams.append(Utility.typeParamTypeToString(signature.substring(index), chopit));
        index += Utility.unwrap(consumed_chars);
        while (signature.charAt(index) != '>') {
            typeParams.append(", ");
            typeParams.append(Utility.typeParamTypeToString(signature.substring(index), chopit));
            index += Utility.unwrap(consumed_chars);
        }
        Utility.wrap(consumed_chars, index + 1);
        return typeParams.append(">").toString();
    }

    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String typeParamTypeToString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean chopit) {
        int index = signature.indexOf(58);
        if (index <= 0) {
            throw new ClassFormatException("Invalid type parameter signature: " + signature);
        }
        StringBuilder typeParam = new StringBuilder(signature.substring(0, index));
        if (signature.charAt(++index) != ':') {
            typeParam.append(" extends ");
            typeParam.append(Utility.typeSignatureToString(signature.substring(index), chopit));
            index += Utility.unwrap(consumed_chars);
        }
        while (signature.charAt(index) == ':') {
            typeParam.append(" & ");
            typeParam.append(Utility.typeSignatureToString(signature.substring(++index), chopit));
            index += Utility.unwrap(consumed_chars);
        }
        Utility.wrap(consumed_chars, index);
        return typeParam.toString();
    }

    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String typeSignaturesToString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean chopit, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown char term) {
        StringBuilder typeList = new StringBuilder(signature.substring(0, 1));
        int index = 1;
        if (signature.charAt(index) != term) {
            typeList.append(Utility.typeSignatureToString(signature.substring(index), chopit));
            index += Utility.unwrap(consumed_chars);
        }
        while (signature.charAt(index) != term) {
            typeList.append(", ");
            typeList.append(Utility.typeSignatureToString(signature.substring(index), chopit));
            index += Utility.unwrap(consumed_chars);
        }
        Utility.wrap(consumed_chars, index + 1);
        return typeList.append(term).toString();
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String typeSignatureToString(@FieldDescriptor @UnknownInterned @UnknownKeyFor @NonNull @Initialized String signature, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean chopit) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        Utility.wrap(consumed_chars, 1);
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'T': {
                    int index = signature.indexOf(59);
                    if (index < 0) {
                        throw new ClassFormatException("Invalid type variable signature: " + signature);
                    }
                    Utility.wrap(consumed_chars, index + 1);
                    return Utility.compactClassName(signature.substring(1, index), chopit);
                }
                case 'L': {
                    int fromIndex = signature.indexOf(60);
                    if (fromIndex < 0) {
                        fromIndex = 0;
                    } else if ((fromIndex = signature.indexOf(62, fromIndex)) < 0) {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    int index = signature.indexOf(59, fromIndex);
                    if (index < 0) {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    int bracketIndex = signature.substring(0, index).indexOf(60);
                    if (bracketIndex < 0) {
                        Utility.wrap(consumed_chars, index + 1);
                        return Utility.compactClassName(signature.substring(1, index), chopit);
                    }
                    fromIndex = signature.indexOf(59);
                    if (fromIndex < 0) {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    if (fromIndex < bracketIndex) {
                        Utility.wrap(consumed_chars, fromIndex + 1);
                        return Utility.compactClassName(signature.substring(1, fromIndex), chopit);
                    }
                    StringBuilder type = new StringBuilder(Utility.compactClassName(signature.substring(1, bracketIndex), chopit)).append("<");
                    int consumed_chars = bracketIndex + 1;
                    if (signature.charAt(consumed_chars) == '+') {
                        type.append("? extends ");
                        ++consumed_chars;
                    } else if (signature.charAt(consumed_chars) == '-') {
                        type.append("? super ");
                        ++consumed_chars;
                    }
                    if (signature.charAt(consumed_chars) == '*') {
                        type.append("?");
                        ++consumed_chars;
                    } else {
                        type.append(Utility.typeSignatureToString(signature.substring(consumed_chars), chopit));
                        consumed_chars = Utility.unwrap(Utility.consumed_chars) + consumed_chars;
                        Utility.wrap(Utility.consumed_chars, consumed_chars);
                    }
                    while (signature.charAt(consumed_chars) != '>') {
                        type.append(", ");
                        if (signature.charAt(consumed_chars) == '+') {
                            type.append("? extends ");
                            ++consumed_chars;
                        } else if (signature.charAt(consumed_chars) == '-') {
                            type.append("? super ");
                            ++consumed_chars;
                        }
                        if (signature.charAt(consumed_chars) == '*') {
                            type.append("?");
                            ++consumed_chars;
                            continue;
                        }
                        type.append(Utility.typeSignatureToString(signature.substring(consumed_chars), chopit));
                        consumed_chars = Utility.unwrap(Utility.consumed_chars) + consumed_chars;
                        Utility.wrap(Utility.consumed_chars, consumed_chars);
                    }
                    type.append(">");
                    if (signature.charAt(++consumed_chars) == '.') {
                        type.append(".");
                        type.append(Utility.typeSignatureToString("L" + signature.substring(consumed_chars + 1), chopit));
                        consumed_chars = Utility.unwrap(Utility.consumed_chars) + consumed_chars;
                        Utility.wrap(Utility.consumed_chars, consumed_chars);
                        return type.toString();
                    }
                    if (signature.charAt(consumed_chars) != ';') {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    Utility.wrap(Utility.consumed_chars, consumed_chars + 1);
                    return type.toString();
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case '[': {
                    StringBuilder brackets = new StringBuilder();
                    int n = 0;
                    while (signature.charAt(n) == '[') {
                        brackets.append("[]");
                        ++n;
                    }
                    int consumed_chars = n;
                    String type = Utility.typeSignatureToString(signature.substring(n), chopit);
                    int _temp = Utility.unwrap(Utility.consumed_chars) + consumed_chars;
                    Utility.wrap(Utility.consumed_chars, _temp);
                    return type + brackets.toString();
                }
                case 'V': {
                    return "void";
                }
            }
            throw new ClassFormatException("Invalid signature: `" + signature + "'");
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid signature: " + signature, e);
        }
    }

    public static @FieldDescriptor @UnknownInterned @UnknownKeyFor @NonNull @Initialized String getSignature(@FullyQualifiedName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String type) {
        StringBuilder buf = new StringBuilder();
        char[] chars = type.toCharArray();
        boolean char_found = false;
        boolean delim = false;
        int index = -1;
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!char_found) continue block4;
                    delim = true;
                    continue block4;
                }
                case '[': {
                    if (!char_found) {
                        throw new IllegalArgumentException("Illegal type: " + type);
                    }
                    index = i;
                    break block4;
                }
                default: {
                    char_found = true;
                    if (delim) continue block4;
                    buf.append(chars[i]);
                }
            }
        }
        int brackets = 0;
        if (index > 0) {
            brackets = Utility.countBrackets(type.substring(index));
        }
        type = buf.toString();
        buf.setLength(0);
        for (int i = 0; i < brackets; ++i) {
            buf.append('[');
        }
        boolean found = false;
        for (int i = 4; i <= 12 && !found; ++i) {
            if (!Const.getTypeName(i).equals(type)) continue;
            found = true;
            buf.append(Const.getShortTypeName(i));
        }
        if (!found) {
            buf.append('L').append(type.replace('.', '/')).append(';');
        }
        return buf.toString();
    }

    private static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int countBrackets(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String brackets) {
        char[] chars = brackets.toCharArray();
        int count = 0;
        boolean open = false;
        block4: for (char c : chars) {
            switch (c) {
                case '[': {
                    if (open) {
                        throw new IllegalArgumentException("Illegally nested brackets:" + brackets);
                    }
                    open = true;
                    continue block4;
                }
                case ']': {
                    if (!open) {
                        throw new IllegalArgumentException("Illegally nested brackets:" + brackets);
                    }
                    open = false;
                    ++count;
                    continue block4;
                }
            }
        }
        if (open) {
            throw new IllegalArgumentException("Illegally nested brackets:" + brackets);
        }
        return count;
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte typeOfMethodSignature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = signature.lastIndexOf(41) + 1;
            return Utility.typeOfSignature(signature.substring(index));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte typeOfSignature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassFormatException {
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return 8;
                }
                case 'C': {
                    return 5;
                }
                case 'D': {
                    return 7;
                }
                case 'F': {
                    return 6;
                }
                case 'I': {
                    return 10;
                }
                case 'J': {
                    return 11;
                }
                case 'L': 
                case 'T': {
                    return 14;
                }
                case '[': {
                    return 13;
                }
                case 'V': {
                    return 12;
                }
                case 'Z': {
                    return 4;
                }
                case 'S': {
                    return 9;
                }
                case '!': 
                case '*': 
                case '+': {
                    return Utility.typeOfSignature(signature.substring(1));
                }
            }
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short searchOpcode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        name = name.toLowerCase(Locale.ENGLISH);
        for (short i = 0; i < Const.OPCODE_NAMES_LENGTH; i = (short)(i + 1)) {
            if (!Const.getOpcodeName(i).equals(name)) continue;
            return i;
        }
        return -1;
    }

    private static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short byteToShort(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte b) {
        return b < 0 ? (short)(256 + b) : (short)b;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toHexString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bytes) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            short b = Utility.byteToShort(bytes[i]);
            String hex = Integer.toHexString(b);
            if (b < 16) {
                buf.append('0');
            }
            buf.append(hex);
            if (i >= bytes.length - 1) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String format(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean left_justify, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown char fill) {
        return Utility.fillup(Integer.toString(i), length, left_justify, fill);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String fillup(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String str, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean left_justify, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown char fill) {
        int len = length - str.length();
        char[] buf = new char[len < 0 ? 0 : len];
        for (int j = 0; j < buf.length; ++j) {
            buf[j] = fill;
        }
        if (left_justify) {
            return str + new String(buf);
        }
        return new String(buf) + str;
    }

    static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] a, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] b) {
        int size = a.length;
        if (size != b.length) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static void printArray(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown PrintStream out, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] obj) {
        out.println(Utility.printArray(obj, true));
    }

    public static void printArray(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown PrintWriter out, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] obj) {
        out.println(Utility.printArray(obj, true));
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String printArray(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] obj) {
        return Utility.printArray(obj, true);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String printArray(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] obj, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean braces) {
        return Utility.printArray(obj, braces, false);
    }

    public static @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown String printArray(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] obj, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean braces, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean quote) {
        if (obj == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (braces) {
            buf.append('{');
        }
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] != null) {
                buf.append(quote ? "\"" : "").append(obj[i]).append(quote ? "\"" : "");
            } else {
                buf.append("null");
            }
            if (i >= obj.length - 1) continue;
            buf.append(", ");
        }
        if (braces) {
            buf.append('}');
        }
        return buf.toString();
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isJavaIdentifierPart(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_';
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String encode(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bytes, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean compress) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        if (compress) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Throwable object = null;
                try (GZIPOutputStream gos = new GZIPOutputStream(baos);){
                    gos.write(bytes, 0, bytes.length);
                    bytes = baos.toByteArray();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throw throwable;
                }
            }
        }
        CharArrayWriter caw = new CharArrayWriter();
        try (JavaWriter jw = new JavaWriter(caw);){
            for (byte b : bytes) {
                int in = b & 0xFF;
                jw.write(in);
            }
        }
        return caw.toString();
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] decode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String s, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean uncompress) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        byte[] bytes;
        try (JavaReader jr = new JavaReader(new CharArrayReader(s.toCharArray()));
             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int ch;
            while ((ch = jr.read()) >= 0) {
                bos.write(ch);
            }
            bytes = bos.toByteArray();
        }
        if (uncompress) {
            int b;
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(bytes));
            byte[] tmp = new byte[bytes.length * 3];
            int count = 0;
            while ((b = gis.read()) >= 0) {
                tmp[count++] = (byte)b;
            }
            bytes = new byte[count];
            System.arraycopy(tmp, 0, bytes, 0, count);
        }
        return bytes;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String convertString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String label) {
        char[] ch = label.toCharArray();
        StringBuilder buf = new StringBuilder();
        block7: for (char element : ch) {
            switch (element) {
                case '\n': {
                    buf.append("\\n");
                    continue block7;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block7;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block7;
                }
                case '\'': {
                    buf.append("\\'");
                    continue block7;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block7;
                }
                default: {
                    buf.append(element);
                }
            }
        }
        return buf.toString();
    }

    static {
        int i;
        consumed_chars = new ThreadLocal<Integer>(){

            @Override
            protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Integer initialValue() {
                return 0;
            }
        };
        wide = false;
        CHAR_MAP = new int[48];
        MAP_CHAR = new int[256];
        int j = 0;
        for (i = 65; i <= 90; ++i) {
            Utility.CHAR_MAP[j] = i;
            Utility.MAP_CHAR[i] = j++;
        }
        for (i = 103; i <= 122; ++i) {
            Utility.CHAR_MAP[j] = i;
            Utility.MAP_CHAR[i] = j++;
        }
        Utility.CHAR_MAP[j] = 36;
        Utility.MAP_CHAR[36] = j++;
        Utility.CHAR_MAP[j] = 95;
        Utility.MAP_CHAR[95] = j;
    }

    private static class JavaWriter
    extends FilterWriter {
        public JavaWriter(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Writer out) {
            super(out);
        }

        @Override
        public void write(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int b) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
            if (Utility.isJavaIdentifierPart((char)b) && b != 36) {
                this.out.write(b);
            } else {
                this.out.write(36);
                if (b >= 0 && b < 48) {
                    this.out.write(CHAR_MAP[b]);
                } else {
                    char[] tmp = Integer.toHexString(b).toCharArray();
                    if (tmp.length == 1) {
                        this.out.write(48);
                        this.out.write(tmp[0]);
                    } else {
                        this.out.write(tmp[0]);
                        this.out.write(tmp[1]);
                    }
                }
            }
        }

        @Override
        public void write(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown char @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] cbuf, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int off, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int len) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
            for (int i = 0; i < len; ++i) {
                this.write(cbuf[off + i]);
            }
        }

        @Override
        public void write(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String str, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int off, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int len) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
            this.write(str.toCharArray(), off, len);
        }
    }

    private static class JavaReader
    extends FilterReader {
        public JavaReader(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Reader in) {
            super(in);
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int read() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
            int b = this.in.read();
            if (b != 36) {
                return b;
            }
            int i = this.in.read();
            if (i < 0) {
                return -1;
            }
            if (i >= 48 && i <= 57 || i >= 97 && i <= 102) {
                int j = this.in.read();
                if (j < 0) {
                    return -1;
                }
                char[] tmp = new char[]{(char)i, (char)j};
                int s = Integer.parseInt(new String(tmp), 16);
                return s;
            }
            return MAP_CHAR[i];
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int read(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown char @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] cbuf, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int off, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int len) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
            for (int i = 0; i < len; ++i) {
                cbuf[off + i] = (char)this.read();
            }
            return len;
        }
    }
}

