/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.StackMapType;
import org.apache.bcel.classfile.Visitor;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class StackMapEntry
implements Node,
Cloneable {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int frameType;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int byteCodeOffset;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapType @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] typesOfLocals;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapType @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] typesOfStackItems;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool;

    StackMapEntry(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(input.readByte() & 0xFF, -1, null, null, constantPool);
        if (this.frameType >= 0 && this.frameType <= 63) {
            this.byteCodeOffset = this.frameType - 0;
        } else if (this.frameType >= 64 && this.frameType <= 127) {
            this.byteCodeOffset = this.frameType - 64;
            this.typesOfStackItems = new StackMapType[1];
            this.typesOfStackItems[0] = new StackMapType(input, constantPool);
        } else if (this.frameType == 247) {
            this.byteCodeOffset = input.readShort();
            this.typesOfStackItems = new StackMapType[1];
            this.typesOfStackItems[0] = new StackMapType(input, constantPool);
        } else if (this.frameType >= 248 && this.frameType <= 250) {
            this.byteCodeOffset = input.readShort();
        } else if (this.frameType == 251) {
            this.byteCodeOffset = input.readShort();
        } else if (this.frameType >= 252 && this.frameType <= 254) {
            this.byteCodeOffset = input.readShort();
            int number_of_locals = this.frameType - 251;
            this.typesOfLocals = new StackMapType[number_of_locals];
            for (int i = 0; i < number_of_locals; ++i) {
                this.typesOfLocals[i] = new StackMapType(input, constantPool);
            }
        } else if (this.frameType == 255) {
            this.byteCodeOffset = input.readShort();
            int number_of_locals = input.readShort();
            this.typesOfLocals = new StackMapType[number_of_locals];
            for (int i = 0; i < number_of_locals; ++i) {
                this.typesOfLocals[i] = new StackMapType(input, constantPool);
            }
            int number_of_stack_items = input.readShort();
            this.typesOfStackItems = new StackMapType[number_of_stack_items];
            for (int i = 0; i < number_of_stack_items; ++i) {
                this.typesOfStackItems[i] = new StackMapType(input, constantPool);
            }
        } else {
            throw new ClassFormatException("Invalid frame type found while parsing stack map table: " + this.frameType);
        }
    }

    @Deprecated
    public StackMapEntry(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int byteCodeOffset, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int numberOfLocals, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapType @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] typesOfLocals, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int numberOfStackItems, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapType @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] typesOfStackItems, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool) {
        this.byteCodeOffset = byteCodeOffset;
        this.typesOfLocals = typesOfLocals != null ? typesOfLocals : new StackMapType[]{};
        this.typesOfStackItems = typesOfStackItems != null ? typesOfStackItems : new StackMapType[]{};
        this.constantPool = constantPool;
    }

    public StackMapEntry(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int tag, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int byteCodeOffset, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapType @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] typesOfLocals, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapType @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] typesOfStackItems, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool) {
        this.frameType = tag;
        this.byteCodeOffset = byteCodeOffset;
        this.typesOfLocals = typesOfLocals != null ? typesOfLocals : new StackMapType[]{};
        this.typesOfStackItems = typesOfStackItems != null ? typesOfStackItems : new StackMapType[]{};
        this.constantPool = constantPool;
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.write(this.frameType);
        if (this.frameType < 0 || this.frameType > 63) {
            if (this.frameType >= 64 && this.frameType <= 127) {
                this.typesOfStackItems[0].dump(file);
            } else if (this.frameType == 247) {
                file.writeShort(this.byteCodeOffset);
                this.typesOfStackItems[0].dump(file);
            } else if (this.frameType >= 248 && this.frameType <= 250) {
                file.writeShort(this.byteCodeOffset);
            } else if (this.frameType == 251) {
                file.writeShort(this.byteCodeOffset);
            } else if (this.frameType >= 252 && this.frameType <= 254) {
                file.writeShort(this.byteCodeOffset);
                for (StackMapType type : this.typesOfLocals) {
                    type.dump(file);
                }
            } else if (this.frameType == 255) {
                file.writeShort(this.byteCodeOffset);
                file.writeShort(this.typesOfLocals.length);
                for (StackMapType type : this.typesOfLocals) {
                    type.dump(file);
                }
                file.writeShort(this.typesOfStackItems.length);
                for (StackMapType type : this.typesOfStackItems) {
                    type.dump(file);
                }
            } else {
                throw new ClassFormatException("Invalid Stack map table tag: " + this.frameType);
            }
        }
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        int i;
        StringBuilder buf = new StringBuilder(64);
        buf.append("(");
        if (this.frameType >= 0 && this.frameType <= 63) {
            buf.append("SAME");
        } else if (this.frameType >= 64 && this.frameType <= 127) {
            buf.append("SAME_LOCALS_1_STACK");
        } else if (this.frameType == 247) {
            buf.append("SAME_LOCALS_1_STACK_EXTENDED");
        } else if (this.frameType >= 248 && this.frameType <= 250) {
            buf.append("CHOP ").append(String.valueOf(251 - this.frameType));
        } else if (this.frameType == 251) {
            buf.append("SAME_EXTENDED");
        } else if (this.frameType >= 252 && this.frameType <= 254) {
            buf.append("APPEND ").append(String.valueOf(this.frameType - 251));
        } else if (this.frameType == 255) {
            buf.append("FULL");
        } else {
            buf.append("UNKNOWN (").append(this.frameType).append(")");
        }
        buf.append(", offset delta=").append(this.byteCodeOffset);
        if (this.typesOfLocals.length > 0) {
            buf.append(", locals={");
            for (i = 0; i < this.typesOfLocals.length; ++i) {
                buf.append(this.typesOfLocals[i]);
                if (i >= this.typesOfLocals.length - 1) continue;
                buf.append(", ");
            }
            buf.append("}");
        }
        if (this.typesOfStackItems.length > 0) {
            buf.append(", stack items={");
            for (i = 0; i < this.typesOfStackItems.length; ++i) {
                buf.append(this.typesOfStackItems[i]);
                if (i >= this.typesOfStackItems.length - 1) continue;
                buf.append(", ");
            }
            buf.append("}");
        }
        buf.append(")");
        return buf.toString();
    }

    @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMapEntrySize() {
        if (this.frameType >= 0 && this.frameType <= 63) {
            return 1;
        }
        if (this.frameType >= 64 && this.frameType <= 127) {
            return 1 + (this.typesOfStackItems[0].hasIndex() ? 3 : 1);
        }
        if (this.frameType == 247) {
            return 3 + (this.typesOfStackItems[0].hasIndex() ? 3 : 1);
        }
        if (this.frameType >= 248 && this.frameType <= 250) {
            return 3;
        }
        if (this.frameType == 251) {
            return 3;
        }
        if (this.frameType >= 252 && this.frameType <= 254) {
            int len = 3;
            for (StackMapType types_of_local : this.typesOfLocals) {
                len += types_of_local.hasIndex() ? 3 : 1;
            }
            return len;
        }
        if (this.frameType == 255) {
            int len = 7;
            for (StackMapType types_of_local : this.typesOfLocals) {
                len += types_of_local.hasIndex() ? 3 : 1;
            }
            for (StackMapType types_of_stack_item : this.typesOfStackItems) {
                len += types_of_stack_item.hasIndex() ? 3 : 1;
            }
            return len;
        }
        throw new IllegalStateException("Invalid StackMap frameType: " + this.frameType);
    }

    public void setFrameType(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int f) {
        if (f >= 0 && f <= 63) {
            this.byteCodeOffset = f - 0;
        } else if (f >= 64 && f <= 127) {
            this.byteCodeOffset = f - 64;
        } else if (!(f == 247 || f >= 248 && f <= 250 || f == 251 || f >= 252 && f <= 254 || f == 255)) {
            throw new IllegalArgumentException("Invalid StackMap frameType");
        }
        this.frameType = f;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getFrameType() {
        return this.frameType;
    }

    public void setByteCodeOffset(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int new_offset) {
        if (new_offset < 0 || new_offset > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid StackMap offset: " + new_offset);
        }
        if (this.frameType >= 0 && this.frameType <= 63) {
            this.frameType = new_offset > 63 ? 251 : new_offset;
        } else if (this.frameType >= 64 && this.frameType <= 127) {
            this.frameType = new_offset > 63 ? 247 : 64 + new_offset;
        } else if (!(this.frameType == 247 || this.frameType >= 248 && this.frameType <= 250 || this.frameType == 251 || this.frameType >= 252 && this.frameType <= 254 || this.frameType == 255)) {
            throw new IllegalStateException("Invalid StackMap frameType: " + this.frameType);
        }
        this.byteCodeOffset = new_offset;
    }

    public void updateByteCodeOffset(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int delta) {
        this.setByteCodeOffset(this.byteCodeOffset + delta);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getByteCodeOffset() {
        return this.byteCodeOffset;
    }

    @Deprecated
    public void setNumberOfLocals(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int n) {
    }

    public @NonNegative @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNumberOfLocals() {
        return this.typesOfLocals.length;
    }

    public void setTypesOfLocals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapType @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] types) {
        this.typesOfLocals = types != null ? types : new StackMapType[]{};
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapType @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getTypesOfLocals() {
        return this.typesOfLocals;
    }

    @Deprecated
    public void setNumberOfStackItems(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int n) {
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNumberOfStackItems() {
        return this.typesOfStackItems.length;
    }

    public void setTypesOfStackItems(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapType @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] types) {
        this.typesOfStackItems = types != null ? types : new StackMapType[]{};
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapType @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getTypesOfStackItems() {
        return this.typesOfStackItems;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapEntry copy() {
        int i;
        StackMapEntry e;
        try {
            e = (StackMapEntry)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("Clone Not Supported");
        }
        e.typesOfLocals = new StackMapType[this.typesOfLocals.length];
        for (i = 0; i < this.typesOfLocals.length; ++i) {
            e.typesOfLocals[i] = this.typesOfLocals[i].copy();
        }
        e.typesOfStackItems = new StackMapType[this.typesOfStackItems.length];
        for (i = 0; i < this.typesOfStackItems.length; ++i) {
            e.typesOfStackItems[i] = this.typesOfStackItems[i].copy();
        }
        return e;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitStackMapEntry(this);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constantPool) {
        this.constantPool = constantPool;
    }
}

