/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class ModuleRequires
implements Cloneable,
Node {
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int requiresIndex;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int requiresFlags;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int requiresVersionIndex;

    ModuleRequires(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.requiresIndex = file.readUnsignedShort();
        this.requiresFlags = file.readUnsignedShort();
        this.requiresVersionIndex = file.readUnsignedShort();
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitModuleRequires(this);
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.requiresIndex);
        file.writeShort(this.requiresFlags);
        file.writeShort(this.requiresVersionIndex);
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "requires(" + this.requiresIndex + ", " + String.format("%04x", this.requiresFlags) + ", " + this.requiresVersionIndex + ")";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String module_name = constant_pool.constantToString(this.requiresIndex, (byte)19);
        buf.append(Utility.compactClassName(module_name, false));
        buf.append(", ").append(String.format("%04x", this.requiresFlags));
        String version = this.requiresVersionIndex == 0 ? "0" : constant_pool.getConstantString(this.requiresVersionIndex, (byte)1);
        buf.append(", ").append(version);
        return buf.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModuleRequires copy() {
        try {
            return (ModuleRequires)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

