/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class ConstantUtf8
extends Constant {
    private static volatile @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int considered = 0;
    private static volatile @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int created = 0;
    private static volatile @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hits = 0;
    private static volatile @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int skipped = 0;
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String SYS_PROP_CACHE_MAX_ENTRIES = "bcel.maxcached";
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String SYS_PROP_CACHE_MAX_ENTRY_SIZE = "bcel.maxcached.size";
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String SYS_PROP_STATISTICS = "bcel.statistics";
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String value;

    public static synchronized void clearCache() {
        Cache.CACHE.clear();
    }

    static synchronized void clearStats() {
        created = 0;
        skipped = 0;
        considered = 0;
        hits = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantUtf8 getCachedInstance(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String value) {
        if (value.length() > Cache.MAX_ENTRY_SIZE) {
            ++skipped;
            return new ConstantUtf8(value);
        }
        ++considered;
        Class<ConstantUtf8> clazz = ConstantUtf8.class;
        synchronized (ConstantUtf8.class) {
            ConstantUtf8 result = (ConstantUtf8)Cache.CACHE.get(value);
            if (result != null) {
                ++hits;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
            result = new ConstantUtf8(value);
            Cache.CACHE.put(value, result);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantUtf8 getInstance(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput dataInput) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        return ConstantUtf8.getInstance(dataInput.readUTF());
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantUtf8 getInstance(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String value) {
        return Cache.isEnabled() ? ConstantUtf8.getCachedInstance(value) : new ConstantUtf8(value);
    }

    static void printStats() {
        String prefix = "[Apache Commons BCEL]";
        System.err.printf("%s Cache hit %,d/%,d, %d skipped.%n", "[Apache Commons BCEL]", hits, considered, skipped);
        System.err.printf("%s Total of %,d ConstantUtf8 objects created.%n", "[Apache Commons BCEL]", created);
        System.err.printf("%s Configuration: %s=%,d, %s=%,d.%n", "[Apache Commons BCEL]", SYS_PROP_CACHE_MAX_ENTRIES, Cache.MAX_ENTRIES, SYS_PROP_CACHE_MAX_ENTRY_SIZE, Cache.MAX_ENTRY_SIZE);
    }

    public ConstantUtf8(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantUtf8 constantUtf8) {
        this(constantUtf8.getBytes());
    }

    ConstantUtf8(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput dataInput) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super((byte)1);
        this.value = dataInput.readUTF();
        ++created;
    }

    public ConstantUtf8(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String value) {
        super((byte)1);
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null.");
        }
        this.value = value;
        ++created;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitConstantUtf8(this);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeByte(super.getTag());
        file.writeUTF(this.value);
    }

    @Pure
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getBytes() {
        return this.value;
    }

    @Deprecated
    public void setBytes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return super.toString() + "(\"" + Utility.replace(this.value, "\n", "\\n") + "\")";
    }

    static {
        if (Cache.BCEL_STATISTICS) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ConstantUtf8.printStats();
                }
            });
        }
    }

    private static class Cache {
        private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean BCEL_STATISTICS = Boolean.getBoolean("bcel.statistics");
        private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int MAX_ENTRIES = Integer.getInteger("bcel.maxcached", 0);
        private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int INITIAL_CAPACITY = (int)((double)MAX_ENTRIES / 0.75);
        private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown HashMap<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantUtf8> CACHE = new LinkedHashMap<String, ConstantUtf8>(INITIAL_CAPACITY, 0.75f, true){
            private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long serialVersionUID = -8506975356158971766L;

            @Override
            protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean removeEldestEntry( @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map.Entry<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantUtf8> eldest) {
                return this.size() > MAX_ENTRIES;
            }
        };
        private static final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int MAX_ENTRY_SIZE = Integer.getInteger("bcel.maxcached.size", 200);

        private Cache() {
        }

        static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isEnabled() {
            return MAX_ENTRIES > 0 && MAX_ENTRY_SIZE > 0;
        }
    }
}

