/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.AbstractClassPathRepository;
import org.apache.bcel.util.ClassPath;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class MemorySensitiveClassPathRepository
extends AbstractClassPathRepository {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SoftReference<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass>> loadedClasses = new HashMap<String, SoftReference<JavaClass>>();

    public MemorySensitiveClassPathRepository(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath path) {
        super(path);
    }

    @Override
    public void storeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz) {
        this.loadedClasses.put(clazz.getClassName(), new SoftReference<JavaClass>(clazz));
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz) {
        this.loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown JavaClass findClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String className) {
        SoftReference<JavaClass> ref = this.loadedClasses.get(className);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    @Override
    public void clear() {
        this.loadedClasses.clear();
    }
}

