/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class TABLESWITCH
extends Select {
    TABLESWITCH() {
    }

    public TABLESWITCH(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] match, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] targets, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle defaultTarget) {
        super((short)170, match, targets, defaultTarget);
        short _length = (short)(13 + this.getMatch_length() * 4);
        super.setLength(_length);
        this.setFixed_length(_length);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(out);
        int _match_length = this.getMatch_length();
        int low = _match_length > 0 ? super.getMatch(0) : 0;
        out.writeInt(low);
        int high = _match_length > 0 ? super.getMatch(_match_length - 1) : 0;
        out.writeInt(high);
        for (int i = 0; i < _match_length; ++i) {
            out.writeInt(this.setIndices(i, this.getTargetOffset(super.getTarget(i))));
        }
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.initFromFile(bytes, wide);
        int low = bytes.readInt();
        int high = bytes.readInt();
        int _match_length = high - low + 1;
        this.setMatch_length(_match_length);
        short _fixed_length = (short)(13 + _match_length * 4);
        this.setFixed_length(_fixed_length);
        super.setLength((short)(_fixed_length + super.getPadding()));
        super.setMatches(new int[_match_length]);
        super.setIndices(new int[_match_length]);
        super.setTargets(new InstructionHandle[_match_length]);
        for (int i = 0; i < _match_length; ++i) {
            super.setMatch(i, low + i);
            super.setIndices(i, bytes.readInt());
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitVariableLengthInstruction(this);
        v.visitStackConsumer(this);
        v.visitBranchInstruction(this);
        v.visitSelect(this);
        v.visitTABLESWITCH(this);
    }
}

