/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.RuntimeInvisibleAnnotations;
import org.apache.bcel.classfile.RuntimeVisibleAnnotations;
import org.apache.bcel.classfile.SourceFile;
import org.apache.bcel.generic.AnnotationEntryGen;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ClassObserver;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.InstructionConst;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.BCELComparator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ClassGen
extends AccessFlags
implements Cloneable {
    private @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String className;
    private @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String superClassName;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String fileName;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int classNameIndex = -1;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int superclass_name_index = -1;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int major = 45;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int minor = 3;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field> fieldList = new ArrayList<Field>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method> methodList = new ArrayList<Method>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute> attributeList = new ArrayList<Attribute>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String> interfaceList = new ArrayList<String>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen> annotationList = new ArrayList<AnnotationEntryGen>();
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o2) {
            ClassGen THIS = (ClassGen)o1;
            ClassGen THAT = (ClassGen)o2;
            return Objects.equals(THIS.getClassName(), THAT.getClassName());
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o) {
            ClassGen THIS = (ClassGen)o;
            return THIS.getClassName().hashCode();
        }
    };
    private @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassObserver> observers;

    public ClassGen(@BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String className, @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String superClassName, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String fileName, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int accessFlags, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] interfaces, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        super(accessFlags);
        this.className = className;
        this.superClassName = superClassName;
        this.fileName = fileName;
        this.cp = cp;
        if (fileName != null) {
            this.addAttribute(new SourceFile(cp.addUtf8("SourceFile"), 2, cp.addUtf8(fileName), cp.getConstantPool()));
        }
        this.classNameIndex = cp.addClass(className);
        this.superclass_name_index = cp.addClass(superClassName);
        if (interfaces != null) {
            for (String interface1 : interfaces) {
                this.addInterface(interface1);
            }
        }
    }

    public ClassGen(@BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String className, @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String superClassName, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String fileName, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int accessFlags, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] interfaces) {
        this(className, superClassName, fileName, accessFlags, interfaces, new ConstantPoolGen());
    }

    public ClassGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz) {
        super(clazz.getAccessFlags());
        this.classNameIndex = clazz.getClassNameIndex();
        this.superclass_name_index = clazz.getSuperclassNameIndex();
        this.className = clazz.getClassName();
        this.superClassName = clazz.getSuperclassName();
        this.fileName = clazz.getSourceFileName();
        this.cp = new ConstantPoolGen(clazz.getConstantPool());
        this.major = clazz.getMajor();
        this.minor = clazz.getMinor();
        Attribute[] attributes = clazz.getAttributes();
        AnnotationEntryGen[] annotations = this.unpackAnnotations(attributes);
        Method[] methods = clazz.getMethods();
        Field[] fields = clazz.getFields();
        String[] interfaces = clazz.getInterfaceNames();
        for (String interface1 : interfaces) {
            this.addInterface(interface1);
        }
        for (Attribute attribute : attributes) {
            if (attribute instanceof Annotations) continue;
            this.addAttribute(attribute);
        }
        for (AnnotationEntryGen annotation : annotations) {
            this.addAnnotationEntry(annotation);
        }
        for (Method method : methods) {
            this.addMethod(method);
        }
        for (Field field : fields) {
            this.addField(field);
        }
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] unpackAnnotations(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] attrs) {
        ArrayList<AnnotationEntryGen> annotationGenObjs = new ArrayList<AnnotationEntryGen>();
        for (Attribute attr : attrs) {
            AnnotationEntry[] annos;
            if (attr instanceof RuntimeVisibleAnnotations) {
                RuntimeVisibleAnnotations rva = (RuntimeVisibleAnnotations)attr;
                for (AnnotationEntry a : annos = rva.getAnnotationEntries()) {
                    annotationGenObjs.add(new AnnotationEntryGen(a, this.getConstantPool(), false));
                }
                continue;
            }
            if (!(attr instanceof RuntimeInvisibleAnnotations)) continue;
            RuntimeInvisibleAnnotations ria = (RuntimeInvisibleAnnotations)attr;
            for (AnnotationEntry a : annos = ria.getAnnotationEntries()) {
                annotationGenObjs.add(new AnnotationEntryGen(a, this.getConstantPool(), false));
            }
        }
        return annotationGenObjs.toArray(new AnnotationEntryGen[annotationGenObjs.size()]);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass getJavaClass() {
        int[] interfaces = this.getInterfaces();
        Field[] fields = this.getFields();
        Method[] methods = this.getMethods();
        Attribute[] attributes = null;
        if (this.annotationList.isEmpty()) {
            attributes = this.getAttributes();
        } else {
            Attribute[] annAttributes = AnnotationEntryGen.getAnnotationAttributes(this.cp, this.getAnnotationEntries());
            attributes = new Attribute[this.attributeList.size() + annAttributes.length];
            this.attributeList.toArray(attributes);
            System.arraycopy(annAttributes, 0, attributes, this.attributeList.size(), annAttributes.length);
        }
        ConstantPool _cp = this.cp.getFinalConstantPool();
        return new JavaClass(this.classNameIndex, this.superclass_name_index, this.fileName, this.major, this.minor, super.getAccessFlags(), _cp, interfaces, fields, methods, attributes);
    }

    public void addInterface(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        this.interfaceList.add(name);
    }

    public void removeInterface(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        this.interfaceList.remove(name);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMajor() {
        return this.major;
    }

    public void setMajor(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int major) {
        this.major = major;
    }

    public void setMinor(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int minor) {
        this.minor = minor;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMinor() {
        return this.minor;
    }

    public void addAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute a) {
        this.attributeList.add(a);
    }

    public void addAnnotationEntry(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen a) {
        this.annotationList.add(a);
    }

    public void addMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method m) {
        this.methodList.add(m);
    }

    public void addEmptyConstructor(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags) {
        InstructionList il = new InstructionList();
        il.append(InstructionConst.THIS);
        il.append(new INVOKESPECIAL(this.cp.addMethodref(this.superClassName, "<init>", "()V")));
        il.append(InstructionConst.RETURN);
        MethodGen mg = new MethodGen(access_flags, Type.VOID, Type.NO_ARGS, null, "<init>", this.className, il, this.cp);
        mg.setMaxStack(1);
        this.addMethod(mg.getMethod());
    }

    public void addField(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field f) {
        this.fieldList.add(f);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean containsField(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field f) {
        return this.fieldList.contains(f);
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Field containsField(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        for (Field f : this.fieldList) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Method containsMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) {
        for (Method m : this.methodList) {
            if (!m.getName().equals(name) || !m.getSignature().equals(signature)) continue;
            return m;
        }
        return null;
    }

    public void removeAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute a) {
        this.attributeList.remove(a);
    }

    public void removeMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method m) {
        this.methodList.remove(m);
    }

    public void replaceMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method old, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method new_) {
        if (new_ == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int i = this.methodList.indexOf(old);
        if (i < 0) {
            this.methodList.add(new_);
        } else {
            this.methodList.set(i, new_);
        }
    }

    public void replaceField(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field old, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field new_) {
        if (new_ == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int i = this.fieldList.indexOf(old);
        if (i < 0) {
            this.fieldList.add(new_);
        } else {
            this.fieldList.set(i, new_);
        }
    }

    public void removeField(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field f) {
        this.fieldList.remove(f);
    }

    public @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String getClassName() {
        return this.className;
    }

    public @BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String getSuperclassName() {
        return this.superClassName;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getFileName() {
        return this.fileName;
    }

    public void setClassName(@BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String name) {
        this.className = name.replace('/', '.');
        this.classNameIndex = this.cp.addClass(name);
    }

    public void setSuperclassName(@BinaryName @UnknownInterned @UnknownKeyFor @NonNull @Initialized String name) {
        this.superClassName = name.replace('/', '.');
        this.superclass_name_index = this.cp.addClass(name);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getMethods() {
        return this.methodList.toArray(new Method[this.methodList.size()]);
    }

    public void setMethods(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] methods) {
        this.methodList.clear();
        for (Method method : methods) {
            this.addMethod(method);
        }
    }

    public void setMethodAt(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method method, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int pos) {
        this.methodList.set(pos, method);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method getMethodAt(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int pos) {
        return this.methodList.get(pos);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getInterfaceNames() {
        int size = this.interfaceList.size();
        String[] interfaces = new String[size];
        this.interfaceList.toArray(interfaces);
        return interfaces;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getInterfaces() {
        int size = this.interfaceList.size();
        int[] interfaces = new int[size];
        for (int i = 0; i < size; ++i) {
            interfaces[i] = this.cp.addClass(this.interfaceList.get(i));
        }
        return interfaces;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getFields() {
        return this.fieldList.toArray(new Field[this.fieldList.size()]);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getAttributes() {
        return this.attributeList.toArray(new Attribute[this.attributeList.size()]);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getAnnotationEntries() {
        return this.annotationList.toArray(new AnnotationEntryGen[this.annotationList.size()]);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen constant_pool) {
        this.cp = constant_pool;
    }

    public void setClassNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int class_name_index) {
        this.classNameIndex = class_name_index;
        this.className = this.cp.getConstantPool().getConstantString(class_name_index, (byte)7).replace('/', '.');
    }

    public void setSuperclassNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int superclass_name_index) {
        this.superclass_name_index = superclass_name_index;
        this.superClassName = this.cp.getConstantPool().getConstantString(superclass_name_index, (byte)7).replace('/', '.');
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getClassNameIndex() {
        return this.classNameIndex;
    }

    public void addObserver(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList<ClassObserver>();
        }
        this.observers.add(o);
    }

    public void removeObserver(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            for (ClassObserver observer : this.observers) {
                observer.notify(this);
            }
        }
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator comparator) {
        bcelComparator = comparator;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object obj) {
        return bcelComparator.equals(this, obj);
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return bcelComparator.hashCode(this);
    }
}

