/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantObject;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Visitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class ConstantClass
extends Constant
implements ConstantObject {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex;

    public ConstantClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantClass c) {
        this(c.getNameIndex());
    }

    ConstantClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput dataInput) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(dataInput.readUnsignedShort());
    }

    public ConstantClass(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex) {
        super((byte)7);
        this.nameIndex = nameIndex;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitConstantClass(this);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeByte(super.getTag());
        file.writeShort(this.nameIndex);
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex) {
        this.nameIndex = nameIndex;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object getConstantValue(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cp) {
        Constant c = cp.getConstant(this.nameIndex, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getBytes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cp) {
        return (String)this.getConstantValue(cp);
    }

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return super.toString() + "(nameIndex = " + this.nameIndex + ")";
    }
}

