/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.bcelutil;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.formatter.qual.FormatMethod;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.common.initializedfields.qual.InitializedFields;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public final class SimpleLog {
    public @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean enabled;
    private @MonotonicNonNull @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) PrintStream logfile = null;
    private @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String filename = null;
    private @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int indentLevel = 0;
    private final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String INDENT_STR_ONE_LEVEL = "  ";
    private @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String indentString = null;
    private @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) List<@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String> indentStrings;

    public SimpleLog() {
        this(true);
    }

    public SimpleLog(@UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean enabled) {
        this(null, enabled);
    }

    public SimpleLog(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String filename) {
        this(filename, true);
    }

    public SimpleLog(@Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String filename, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean enabled) {
        this.filename = filename;
        this.enabled = enabled;
        this.indentStrings = new ArrayList<String>();
        this.indentStrings.add("");
    }

    public @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean enabled() {
        return this.enabled;
    }

    @EnsuresNonNull(value={"logfile"})
    private void setLogfile() {
        if (this.logfile != null) {
            return;
        }
        if (this.filename == null || this.filename.equals("-")) {
            this.logfile = System.out;
        } else {
            try {
                this.logfile = new PrintStream(this.filename);
            }
            catch (Exception e) {
                throw new RuntimeException("Can't open " + this.filename, e);
            }
        }
    }

    @FormatMethod
    public void log(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String format, Object ... args) {
        if (this.enabled) {
            this.setLogfile();
            this.logfile.print(this.getIndentString());
            this.logfile.printf(format, args);
            this.logfile.flush();
        }
    }

    public void logStackTrace() {
        if (this.enabled) {
            this.setLogfile();
            Throwable t = new Throwable();
            t.fillInStackTrace();
            StackTraceElement[] ste_arr = t.getStackTrace();
            for (int ii = 2; ii < ste_arr.length; ++ii) {
                StackTraceElement ste = ste_arr[ii];
                this.logfile.printf("%s  %s%n", this.getIndentString(), ste);
            }
            this.logfile.flush();
        }
    }

    private @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String getIndentString() {
        assert (this.enabled);
        if (this.indentString == null) {
            for (int i = this.indentStrings.size(); i <= this.indentLevel; ++i) {
                this.indentStrings.add(this.indentStrings.get(i - 1) + "  ");
            }
            this.indentString = this.indentStrings.get(this.indentLevel);
        }
        return this.indentString;
    }

    public void indent() {
        if (this.enabled) {
            ++this.indentLevel;
            this.indentString = null;
        }
    }

    public void exdent() {
        if (this.enabled) {
            if (this.indentLevel == 0) {
                this.log("Called exdent when indentation level was 0.", new Object[0]);
                this.logStackTrace();
            } else {
                --this.indentLevel;
                this.indentString = null;
            }
        }
    }

    public void resetIndent() {
        if (this.enabled) {
            this.indentLevel = 0;
            this.indentString = "";
        }
    }
}

