/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.bcelutil;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.StackMap;
import org.apache.bcel.classfile.StackMapEntry;
import org.apache.bcel.classfile.StackMapType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.VerificationResult;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.IndexOrLow;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.InternedDistinct;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.ClassGetName;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.common.initializedfields.qual.InitializedFields;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.dataflow.qual.Pure;
import org.plumelib.bcelutil.BcelUtil;
import org.plumelib.bcelutil.SimpleLog;
import org.plumelib.bcelutil.StackTypes;
import org.plumelib.bcelutil.StackVer;

public abstract class StackMapUtils {
    protected @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) ConstantPoolGen pool = null;
    protected @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) SimpleLog debug_instrument = new SimpleLog(false);
    protected @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean needStackMap = false;
    protected @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) StackMapEntry @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) [] stack_map_table = null;
    protected @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) StackMap smta = null;
    protected @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) StackMapType @MonotonicNonNull @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) [] initial_type_list;
    protected @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int initial_locals_count;
    protected @NonNegative @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int number_active_locals;
    protected @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int running_offset;
    protected @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int first_local_index;
    private @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) StackMapEntry @InternedDistinct @UnknownFormat @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) [] empty_stack_map_table = new StackMapEntry[0];
    private @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Map<@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) InstructionHandle, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Integer> uninitialized_NEW_map = new HashMap<InstructionHandle, Integer>();

    protected @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) [] add_string(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) [] arr, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String new_string) {
        String[] new_arr = new String[arr.length + 1];
        for (int ii = 0; ii < arr.length; ++ii) {
            new_arr[ii] = arr[ii];
        }
        new_arr[arr.length] = new_string;
        return new_arr;
    }

    @Pure
    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String get_attribute_name(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Attribute a) {
        int con_index = a.getNameIndex();
        Constant c = this.pool.getConstant(con_index);
        String att_name = ((ConstantUtf8)c).getBytes();
        return att_name;
    }

    @Pure
    protected final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean is_local_variable_type_table(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Attribute a) {
        return this.get_attribute_name(a).equals("LocalVariableTypeTable");
    }

    @Pure
    protected final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean is_stack_map_table(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Attribute a) {
        return this.get_attribute_name(a).equals("StackMapTable");
    }

    @Pure
    protected final @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Attribute get_stack_map_table_attribute(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) MethodGen mgen) {
        for (Attribute a : mgen.getCodeAttributes()) {
            if (!this.is_stack_map_table(a)) continue;
            return a;
        }
        return null;
    }

    @Pure
    protected final @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Attribute get_local_variable_type_table_attribute(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) MethodGen mgen) {
        for (Attribute a : mgen.getCodeAttributes()) {
            if (!this.is_local_variable_type_table(a)) continue;
            return a;
        }
        return null;
    }

    protected final void remove_local_variable_type_table(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) MethodGen mgen) {
        mgen.removeLocalVariableTypeTable();
    }

    protected final void update_stack_map_offset(@UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int position, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int delta) {
        this.running_offset = -1;
        for (int i = 0; i < this.stack_map_table.length; ++i) {
            this.running_offset = this.stack_map_table[i].getByteCodeOffset() + this.running_offset + 1;
            if (this.running_offset <= position) continue;
            this.stack_map_table[i].updateByteCodeOffset(delta);
            return;
        }
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) StackMapEntry find_stack_map_equal(@UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int offset) {
        this.running_offset = -1;
        for (int i = 0; i < this.stack_map_table.length; ++i) {
            this.running_offset = this.stack_map_table[i].getByteCodeOffset() + this.running_offset + 1;
            if (this.running_offset > offset) {
                throw new RuntimeException("Invalid StackMap offset 1");
            }
            if (this.running_offset != offset) continue;
            return this.stack_map_table[i];
        }
        throw new RuntimeException("Invalid StackMap offset 2");
    }

    protected final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int find_stack_map_index_before(@UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int offset) {
        this.number_active_locals = this.initial_locals_count;
        this.running_offset = -1;
        for (int i = 0; i < this.stack_map_table.length; ++i) {
            this.running_offset = this.running_offset + this.stack_map_table[i].getByteCodeOffset() + 1;
            if (this.running_offset >= offset) {
                if (i == 0) {
                    this.running_offset = -1;
                    return -1;
                }
                this.running_offset = this.running_offset - this.stack_map_table[i].getByteCodeOffset() - 1;
                return i - 1;
            }
            int frame_type = this.stack_map_table[i].getFrameType();
            if (frame_type >= 252 && frame_type <= 254) {
                this.number_active_locals += frame_type - 251;
                continue;
            }
            if (frame_type >= 248 && frame_type <= 250) {
                this.number_active_locals -= 251 - frame_type;
                continue;
            }
            if (frame_type != 255) continue;
            this.number_active_locals = this.stack_map_table[i].getNumberOfLocals();
        }
        if (this.stack_map_table.length == 0) {
            return -1;
        }
        return this.stack_map_table.length - 1;
    }

    protected final @IndexOrLow(value={"stack_map_table"}) @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int find_stack_map_index_after(@UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int offset) {
        this.running_offset = -1;
        for (int i = 0; i < this.stack_map_table.length; ++i) {
            this.running_offset = this.running_offset + this.stack_map_table[i].getByteCodeOffset() + 1;
            if (this.running_offset <= offset) continue;
            return i;
        }
        return -1;
    }

    protected final void modify_stack_maps_for_switches(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) InstructionHandle ih, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) InstructionList il) {
        if (!this.needStackMap) {
            return;
        }
        il.setPositions();
        while (ih != null) {
            Instruction inst = ih.getInstruction();
            short opcode = inst.getOpcode();
            if (opcode == 170 || opcode == 171) {
                int current_offset = ih.getPosition();
                int index = this.find_stack_map_index_after(current_offset);
                if (index == -1) {
                    throw new RuntimeException("Invalid StackMap offset 3");
                }
                StackMapEntry stack_map = this.stack_map_table[index];
                int delta = current_offset + inst.getLength() - this.running_offset;
                if (delta != 0) {
                    stack_map.updateByteCodeOffset(delta);
                }
            }
            ih = ih.getNext();
        }
    }

    @RequiresNonNull(value={"initial_type_list"})
    protected final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int gen_temp_locals(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) MethodGen mgen, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int offset) {
        LocalVariableGen new_lvg;
        int live_start = 0;
        Type live_type = null;
        InstructionList il = mgen.getInstructionList();
        il.setPositions();
        int locals_offset_height = 0;
        int byte_code_offset = -1;
        int min_size = 3;
        this.number_active_locals = this.initial_locals_count;
        StackMapType[] types_of_active_locals = new StackMapType[this.number_active_locals];
        for (int ii = 0; ii < this.number_active_locals; ++ii) {
            types_of_active_locals[ii] = this.initial_type_list[ii];
            locals_offset_height += this.getSize(this.initial_type_list[ii]);
        }
        for (StackMapEntry smte : this.stack_map_table) {
            int n;
            int frame_type = smte.getFrameType();
            byte_code_offset += smte.getByteCodeOffset() + 1;
            if (frame_type >= 252 && frame_type <= 254) {
                types_of_active_locals = Arrays.copyOf(types_of_active_locals, this.number_active_locals + frame_type - 251);
                StackMapType[] stackMapTypeArray = smte.getTypesOfLocals();
                int n2 = stackMapTypeArray.length;
                for (n = 0; n < n2; ++n) {
                    StackMapType smt = stackMapTypeArray[n];
                    types_of_active_locals[this.number_active_locals++] = smt;
                    locals_offset_height += this.getSize(smt);
                }
            } else if (frame_type >= 248 && frame_type <= 250) {
                for (int number_to_chop = 251 - frame_type; number_to_chop > 0; --number_to_chop) {
                    locals_offset_height -= this.getSize(types_of_active_locals[--this.number_active_locals]);
                }
                types_of_active_locals = Arrays.copyOf(types_of_active_locals, this.number_active_locals);
            } else if (frame_type == 255) {
                locals_offset_height = 0;
                this.number_active_locals = 0;
                types_of_active_locals = new StackMapType[smte.getNumberOfLocals()];
                StackMapType[] number_to_chop = smte.getTypesOfLocals();
                int n3 = number_to_chop.length;
                for (n = 0; n < n3; ++n) {
                    StackMapType smt = number_to_chop[n];
                    types_of_active_locals[this.number_active_locals++] = smt;
                    locals_offset_height += this.getSize(smt);
                }
            }
            if (live_start == 0) {
                if (offset >= locals_offset_height) continue;
                live_start = byte_code_offset;
                int running_offset = 0;
                StackMapType[] stackMapTypeArray = types_of_active_locals;
                n = stackMapTypeArray.length;
                for (int i = 0; i < n; ++i) {
                    StackMapType smt = stackMapTypeArray[i];
                    if (running_offset == offset) {
                        live_type = this.generate_Type_from_StackMapType(smt);
                        break;
                    }
                    running_offset += this.getSize(smt);
                }
                if (live_type != null) continue;
                live_start = 0;
                continue;
            }
            if (offset < locals_offset_height) continue;
            new_lvg = mgen.addLocalVariable("DaIkOnTeMp" + offset, live_type, offset, il.findHandle(live_start), il.findHandle(byte_code_offset));
            this.debug_instrument.log("Added local  %s, %d, %d : %s, %s%n", new_lvg.getIndex(), new_lvg.getStart().getPosition(), new_lvg.getEnd().getPosition(), new_lvg.getName(), new_lvg.getType());
            min_size = Math.min(min_size, live_type.getSize());
            live_start = 0;
            live_type = null;
        }
        if (live_start != 0) {
            new_lvg = mgen.addLocalVariable("DaIkOnTeMp" + offset, live_type, offset, il.findHandle(live_start), null);
            this.debug_instrument.log("Added local  %s, %d, %d : %s, %s%n", new_lvg.getIndex(), new_lvg.getStart().getPosition(), il.getEnd().getPosition(), new_lvg.getName(), new_lvg.getType());
            min_size = Math.min(min_size, live_type.getSize());
        } else if (min_size == 3) {
            if (byte_code_offset == -1) {
                byte_code_offset = 0;
            }
            new_lvg = mgen.addLocalVariable("DaIkOnTeMp" + offset, (Type)Type.OBJECT, offset, il.findHandle(byte_code_offset), null);
            this.debug_instrument.log("Added local  %s, %d, %d : %s, %s%n", new_lvg.getIndex(), new_lvg.getStart().getPosition(), il.getEnd().getPosition(), new_lvg.getName(), new_lvg.getType());
            min_size = Math.min(min_size, Type.OBJECT.getSize());
        }
        return offset + min_size;
    }

    protected final void build_unitialized_NEW_map(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) InstructionList il) {
        this.uninitialized_NEW_map.clear();
        il.setPositions();
        for (StackMapEntry smte : this.stack_map_table) {
            int i;
            int frame_type = smte.getFrameType();
            if (!(frame_type >= 64 && frame_type <= 247 || frame_type >= 252 && frame_type <= 254) && frame_type != 255) continue;
            if (smte.getNumberOfLocals() > 0) {
                for (StackMapType smt : smte.getTypesOfLocals()) {
                    if (smt.getType() != 8) continue;
                    i = smt.getIndex();
                    this.uninitialized_NEW_map.put(il.findHandle(i), i);
                }
            }
            if (smte.getNumberOfStackItems() <= 0) continue;
            for (StackMapType smt : smte.getTypesOfStackItems()) {
                if (smt.getType() != 8) continue;
                i = smt.getIndex();
                this.uninitialized_NEW_map.put(il.findHandle(i), i);
            }
        }
    }

    private final void update_NEW_object_stack_map_entries(@UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int old_offset, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int new_offset) {
        for (StackMapEntry smte : this.stack_map_table) {
            int frame_type = smte.getFrameType();
            if (!(frame_type >= 64 && frame_type <= 247 || frame_type >= 252 && frame_type <= 254) && frame_type != 255) continue;
            if (smte.getNumberOfLocals() > 0) {
                for (StackMapType smt : smte.getTypesOfLocals()) {
                    if (smt.getType() != 8 || old_offset != smt.getIndex()) continue;
                    smt.setIndex(new_offset);
                }
            }
            if (smte.getNumberOfStackItems() <= 0) continue;
            for (StackMapType smt : smte.getTypesOfStackItems()) {
                if (smt.getType() != 8 || old_offset != smt.getIndex()) continue;
                smt.setIndex(new_offset);
            }
        }
    }

    protected final void update_uninitialized_NEW_offsets(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) InstructionList il) {
        il.setPositions();
        for (Map.Entry<InstructionHandle, Integer> e : this.uninitialized_NEW_map.entrySet()) {
            int new_offset;
            InstructionHandle ih = e.getKey();
            int old_offset = e.getValue();
            if (old_offset == (new_offset = ih.getPosition())) continue;
            this.update_NEW_object_stack_map_entries(old_offset, new_offset);
            e.setValue(new_offset);
        }
    }

    protected final void adjust_code_for_locals_change(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) MethodGen mgen, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int index_first_moved_local, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int size) {
        InstructionList il = mgen.getInstructionList();
        for (InstructionHandle ih = il.getStart(); ih != null; ih = ih.getNext()) {
            int operand;
            Instruction inst = ih.getInstruction();
            int orig_length = inst.getLength();
            if (inst instanceof RET || inst instanceof IINC) {
                IndexedInstruction index_inst = (IndexedInstruction)inst;
                if (index_inst.getIndex() >= index_first_moved_local) {
                    index_inst.setIndex(index_inst.getIndex() + size);
                }
            } else if (inst instanceof LocalVariableInstruction && (operand = ((LocalVariableInstruction)inst).getIndex()) >= index_first_moved_local) {
                ((LocalVariableInstruction)inst).setIndex(operand + size);
            }
            int delta = inst.getLength() - orig_length;
            if (delta <= 0) continue;
            il.setPositions();
            this.update_stack_map_offset(ih.getPosition(), delta);
            this.modify_stack_maps_for_switches(ih, il);
        }
    }

    @Deprecated
    protected final void fetch_current_stack_map_table(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) MethodGen mgen, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int java_class_version) {
        this.set_current_stack_map_table(mgen, java_class_version);
    }

    @EnsuresNonNull(value={"stack_map_table"})
    protected final void set_current_stack_map_table(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) MethodGen mgen, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int java_class_version) {
        this.needStackMap = false;
        this.smta = (StackMap)this.get_stack_map_table_attribute(mgen);
        if (this.smta != null) {
            this.stack_map_table = ((StackMap)this.smta.copy(this.smta.getConstantPool())).getStackMap();
            this.needStackMap = true;
            this.debug_instrument.log("Attribute tag: %s length: %d nameIndex: %d%n", this.smta.getTag(), this.smta.getLength(), this.smta.getNameIndex());
            mgen.removeCodeAttribute((Attribute)this.smta);
        } else {
            this.stack_map_table = this.empty_stack_map_table;
            if (java_class_version > 50) {
                this.needStackMap = true;
            }
        }
        this.print_stack_map_table("Original");
    }

    protected final void print_stack_map_table(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String prefix) {
        this.debug_instrument.log("%nStackMap(%s) %s items:%n", prefix, this.stack_map_table.length);
        this.running_offset = -1;
        for (int i = 0; i < this.stack_map_table.length; ++i) {
            this.running_offset = this.stack_map_table[i].getByteCodeOffset() + this.running_offset + 1;
            this.debug_instrument.log("@%03d %s %n", this.running_offset, this.stack_map_table[i]);
        }
    }

    protected final void create_new_stack_map_attribute(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) MethodGen mgen) throws @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) IOException {
        if (!this.needStackMap) {
            return;
        }
        if (this.stack_map_table == this.empty_stack_map_table) {
            return;
        }
        this.print_stack_map_table("Final");
        StackMap map_table = new StackMap(this.pool.addUtf8("StackMapTable"), 0, null, this.pool.getConstantPool());
        map_table.setStackMap(this.stack_map_table);
        mgen.addCodeAttribute((Attribute)map_table);
    }

    protected static @ClassGetName @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @InitializedFields(value={}) String typeToClassGetName(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Type t) {
        if (t instanceof ObjectType) {
            return ((ObjectType)t).getClassName();
        }
        if (t instanceof BasicType) {
            return t.toString();
        }
        return t.getSignature().replace('/', '.');
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) StackMapType generate_StackMapType_from_Type(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Type t) {
        switch (t.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new StackMapType(1, -1, this.pool.getConstantPool());
            }
            case 6: {
                return new StackMapType(2, -1, this.pool.getConstantPool());
            }
            case 7: {
                return new StackMapType(3, -1, this.pool.getConstantPool());
            }
            case 11: {
                return new StackMapType(4, -1, this.pool.getConstantPool());
            }
            case 13: 
            case 14: {
                return new StackMapType(7, this.pool.addClass(StackMapUtils.typeToClassGetName(t)), this.pool.getConstantPool());
            }
            case 15: {
                return new StackMapType(8, 0, this.pool.getConstantPool());
            }
        }
        throw new RuntimeException("Invalid type: " + t + t.getType());
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Type generate_Type_from_StackMapType(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) StackMapType smt) {
        switch (smt.getType()) {
            case 0: 
            case 1: {
                return Type.INT;
            }
            case 2: {
                return Type.FLOAT;
            }
            case 3: {
                return Type.DOUBLE;
            }
            case 4: {
                return Type.LONG;
            }
            case 7: {
                return Type.OBJECT;
            }
        }
        Thread.dumpStack();
        assert (false) : "Invalid StackMapType: " + smt + smt.getType();
        throw new RuntimeException("Invalid StackMapType: " + smt + smt.getType());
    }

    protected final @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int getSize(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) StackMapType smt) {
        switch (smt.getType()) {
            case 3: 
            case 4: {
                return 2;
            }
        }
        return 1;
    }

    protected final void update_full_frame_stack_map_entries(@UnknownFormat @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int offset, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Type type_new_var, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) LocalVariableGen @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) [] locals) {
        for (int i = 0; i < this.stack_map_table.length; ++i) {
            int index;
            if (this.stack_map_table[i].getFrameType() != 255) continue;
            int num_locals = this.stack_map_table[i].getNumberOfLocals();
            StackMapType[] new_local_types = new StackMapType[num_locals + 1];
            StackMapType[] old_local_types = this.stack_map_table[i].getTypesOfLocals();
            for (index = 0; index < num_locals && index < locals.length && locals[index].getIndex() < offset; ++index) {
                new_local_types[index] = old_local_types[index];
            }
            new_local_types[index++] = this.generate_StackMapType_from_Type(type_new_var);
            while (index <= num_locals) {
                new_local_types[index] = old_local_types[index - 1];
                ++index;
            }
            this.stack_map_table[i].setTypesOfLocals(new_local_types);
        }
    }

    @Deprecated
    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) LocalVariableGen add_new_argument(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) MethodGen mgen, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String arg_name, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Type arg_type) {
        return this.add_new_parameter(mgen, arg_name, arg_type);
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) LocalVariableGen add_new_parameter(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) MethodGen mgen, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String arg_name, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Type arg_type) {
        boolean has_code;
        LocalVariableGen arg_new = null;
        LocalVariableGen[] locals = mgen.getLocalVariables();
        Type[] arg_types = mgen.getArgumentTypes();
        int new_index = 0;
        int new_offset = 0;
        boolean bl = has_code = mgen.getInstructionList() != null;
        if (has_code) {
            if (!mgen.isStatic()) {
                ++new_index;
                ++new_offset;
            }
            if (arg_types.length > 0) {
                LocalVariableGen last_arg = locals[(new_index += arg_types.length) - 1];
                new_offset = last_arg.getIndex() + last_arg.getType().getSize();
            }
            arg_new = mgen.addLocalVariable(arg_name, arg_type, new_offset, null, null);
            ++this.first_local_index;
        }
        ++this.initial_locals_count;
        arg_types = BcelUtil.postpendToArray(arg_types, arg_type);
        String[] arg_names = this.add_string(mgen.getArgumentNames(), arg_name);
        mgen.setArgumentTypes(arg_types);
        mgen.setArgumentNames(arg_names);
        if (has_code) {
            for (int i = new_index; i < locals.length; ++i) {
                LocalVariableGen lv = locals[i];
                lv.setIndex(lv.getIndex() + arg_type.getSize());
            }
            mgen.setMaxLocals(mgen.getMaxLocals() + arg_type.getSize());
            this.debug_instrument.log("Added arg    %s%n", arg_new.getIndex() + ": " + arg_new.getName() + ", " + arg_new.getType());
            this.adjust_code_for_locals_change(mgen, new_offset, arg_type.getSize());
            this.update_full_frame_stack_map_entries(new_offset, arg_type, locals);
            this.debug_instrument.log("New LocalVariableTable:%n%s%n", mgen.getLocalVariableTable(this.pool));
        }
        return arg_new;
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) LocalVariableGen create_method_scope_local(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) MethodGen mgen, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String local_name, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Type local_type) {
        LocalVariableGen lv_new;
        LocalVariableGen lv;
        int i;
        int max_offset = 0;
        int new_offset = -1;
        LocalVariableGen[] locals = mgen.getLocalVariables();
        int compiler_temp_i = -1;
        int new_index = -1;
        for (i = 0; i < locals.length; ++i) {
            lv = locals[i];
            if (i >= this.first_local_index && lv.getStart().getPosition() != 0 && new_offset == -1) {
                if (compiler_temp_i != -1) {
                    new_offset = locals[compiler_temp_i].getIndex();
                    new_index = compiler_temp_i;
                } else {
                    new_offset = lv.getIndex();
                    new_index = i;
                }
            }
            max_offset = lv.getIndex() + lv.getType().getSize();
            if (lv.getName().startsWith("DaIkOnTeMp")) {
                if (compiler_temp_i != -1) continue;
                compiler_temp_i = i;
                continue;
            }
            compiler_temp_i = -1;
        }
        if (new_offset == -1 && compiler_temp_i != -1) {
            new_offset = locals[compiler_temp_i].getIndex();
            new_index = compiler_temp_i;
        }
        if (new_offset == -1) {
            new_offset = max_offset;
            if (new_offset < mgen.getMaxLocals()) {
                mgen.setMaxLocals(mgen.getMaxLocals() + local_type.getSize());
            }
            lv_new = mgen.addLocalVariable(local_name, local_type, new_offset, null, null);
        } else {
            lv_new = mgen.addLocalVariable(local_name, local_type, new_offset, null, null);
            for (i = new_index; i < locals.length; ++i) {
                lv = locals[i];
                lv.setIndex(lv.getIndex() + local_type.getSize());
            }
            mgen.setMaxLocals(mgen.getMaxLocals() + local_type.getSize());
        }
        this.debug_instrument.log("Added local  %s%n", lv_new.getIndex() + ": " + lv_new.getName() + ", " + lv_new.getType());
        this.adjust_code_for_locals_change(mgen, new_offset, local_type.getSize());
        this.update_full_frame_stack_map_entries(new_offset, local_type, locals);
        this.debug_instrument.log("New LocalVariableTable:%n%s%n", mgen.getLocalVariableTable(this.pool));
        return lv_new;
    }

    @EnsuresNonNull(value={"initial_type_list"})
    protected final void fix_local_variable_table(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) MethodGen mgen) {
        int ii;
        LocalVariableGen new_lvg;
        LocalVariableGen l;
        InstructionList il = mgen.getInstructionList();
        if (il == null) {
            this.first_local_index = 0;
            return;
        }
        LocalVariableGen[] locals = mgen.getLocalVariables();
        for (int ii2 = 0; ii2 < locals.length; ++ii2) {
            locals[ii2] = (LocalVariableGen)locals[ii2].clone();
        }
        Type[] arg_types = mgen.getArgumentTypes();
        int offset = 0;
        int loc_index = 0;
        mgen.setMaxLocals();
        int max_locals = mgen.getMaxLocals();
        mgen.removeLocalVariables();
        mgen.setMaxLocals(0);
        this.first_local_index = arg_types.length;
        if (!mgen.isStatic()) {
            l = locals[0];
            new_lvg = mgen.addLocalVariable(l.getName(), l.getType(), l.getIndex(), null, null);
            this.debug_instrument.log("Added <this> %s%n", new_lvg.getIndex() + ": " + new_lvg.getName() + ", " + new_lvg.getType());
            loc_index = 1;
            offset = 1;
            ++this.first_local_index;
        }
        for (int ii3 = 0; ii3 < arg_types.length; ++ii3) {
            if (loc_index >= locals.length || offset != locals[loc_index].getIndex()) {
                new_lvg = mgen.addLocalVariable("$hidden$" + offset, arg_types[ii3], offset, null, null);
            } else {
                l = locals[loc_index];
                new_lvg = mgen.addLocalVariable(l.getName(), l.getType(), l.getIndex(), null, null);
                ++loc_index;
            }
            this.debug_instrument.log("Added param  %s%n", new_lvg.getIndex() + ": " + new_lvg.getName() + ", " + new_lvg.getType());
            offset += arg_types[ii3].getSize();
        }
        LocalVariableGen[] initial_locals = mgen.getLocalVariables();
        this.initial_locals_count = initial_locals.length;
        this.initial_type_list = new StackMapType[this.initial_locals_count];
        for (ii = 0; ii < this.initial_locals_count; ++ii) {
            this.initial_type_list[ii] = this.generate_StackMapType_from_Type(initial_locals[ii].getType());
        }
        for (ii = this.first_local_index; ii < locals.length; ++ii) {
            l = locals[ii];
            if (l.getIndex() > offset) {
                offset = this.gen_temp_locals(mgen, offset);
                --ii;
                continue;
            }
            new_lvg = mgen.addLocalVariable(l.getName(), l.getType(), l.getIndex(), l.getStart(), l.getEnd());
            this.debug_instrument.log("Added local  %s%n", new_lvg.getIndex() + ": " + new_lvg.getName() + ", " + new_lvg.getType());
            offset = new_lvg.getIndex() + new_lvg.getType().getSize();
        }
        while (offset < max_locals) {
            offset = this.gen_temp_locals(mgen, offset);
        }
        mgen.setMaxLocals();
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) StackTypes bcel_calc_stack_types(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) MethodGen mg) {
        VerificationResult vr;
        StackVer stackver = new StackVer();
        try {
            vr = stackver.do_stack_ver(mg);
        }
        catch (Throwable t) {
            System.out.printf("Warning: StackVer exception for %s.%s%n", mg.getClassName(), mg.getName());
            System.out.printf("Exception: %s%n", t);
            System.out.printf("Method is NOT instrumented%n", new Object[0]);
            return null;
        }
        if (vr != VerificationResult.VR_OK) {
            System.out.printf("Warning: StackVer failed for %s.%s: %s%n", mg.getClassName(), mg.getName(), vr);
            System.out.printf("Method is NOT instrumented%n", new Object[0]);
            return null;
        }
        return stackver.get_stack_types();
    }
}

