/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.bcelutil;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.checker.signature.qual.ClassGetName;
import org.checkerframework.checker.signature.qual.FieldDescriptor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.checker.signature.qual.SourceNameForNonArrayNonInner;

public final class JvmUtil {
    private static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown HashMap<@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @SourceNameForNonArrayNonInner @UnknownFormat String, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @FieldDescriptor @UnknownFormat String> primitiveClassesJvm = new HashMap(8);
    private static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown HashMap<@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String> primitiveClassesFromJvm;

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @FieldDescriptor @UnknownFormat String binaryNameToFieldDescriptor(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @BinaryName @UnknownFormat String classname) {
        int dims = 0;
        String sansArray = classname;
        while (sansArray.endsWith("[]")) {
            ++dims;
            sansArray = sansArray.substring(0, sansArray.length() - 2);
        }
        String result = primitiveClassesJvm.get(sansArray);
        if (result == null) {
            result = "L" + sansArray + ";";
        }
        for (int i = 0; i < dims; ++i) {
            result = "[" + result;
        }
        return result.replace('.', '/');
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @FieldDescriptor @UnknownFormat String primitiveTypeNameToFieldDescriptor(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String primitiveName) {
        String result = primitiveClassesJvm.get(primitiveName);
        if (result == null) {
            throw new IllegalArgumentException("Not the name of a primitive type: " + primitiveName);
        }
        return result;
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @ClassGetName @UnknownFormat String binaryNameToClassGetName(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String bn) {
        if (bn.endsWith("[]")) {
            return JvmUtil.binaryNameToFieldDescriptor(bn).replace('/', '.');
        }
        return bn;
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @ClassGetName @UnknownFormat String fieldDescriptorToClassGetName(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String fd) {
        if (fd.startsWith("[")) {
            return fd.replace('/', '.');
        }
        return JvmUtil.fieldDescriptorToBinaryName(fd);
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String arglistToJvm(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String arglist) {
        if (!arglist.startsWith("(") || !arglist.endsWith(")")) {
            throw new Error("Malformed arglist: " + arglist);
        }
        String result = "(";
        String commaSepArgs = arglist.substring(1, arglist.length() - 1);
        StringTokenizer argsTokenizer = new StringTokenizer(commaSepArgs, ",", false);
        while (argsTokenizer.hasMoreTokens()) {
            @BinaryName String arg = argsTokenizer.nextToken().trim();
            result = result + JvmUtil.binaryNameToFieldDescriptor(arg);
        }
        result = result + ")";
        return result;
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @BinaryName @UnknownFormat String fieldDescriptorToBinaryName(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String classname) {
        String result;
        if (classname.equals("")) {
            throw new Error("Empty string passed to fieldDescriptorToBinaryName");
        }
        int dims = 0;
        while (classname.startsWith("[")) {
            ++dims;
            classname = classname.substring(1);
        }
        if (classname.startsWith("L") && classname.endsWith(";")) {
            result = classname.substring(1, classname.length() - 1);
        } else {
            result = primitiveClassesFromJvm.get(classname);
            if (result == null) {
                throw new Error("Malformed base class: " + classname);
            }
        }
        for (int i = 0; i < dims; ++i) {
            result = result + "[]";
        }
        return result.replace('/', '.');
    }

    public static @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String arglistFromJvm(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown String arglist) {
        if (!arglist.startsWith("(") || !arglist.endsWith(")")) {
            throw new Error("Malformed arglist: " + arglist);
        }
        String result = "(";
        @Positive int pos = 1;
        while (pos < arglist.length() - 1) {
            if (pos > 1) {
                result = result + ", ";
            }
            int nonarrayPos = pos;
            while (arglist.charAt(nonarrayPos) == '[') {
                if (++nonarrayPos < arglist.length()) continue;
                throw new Error("Malformed arglist: " + arglist);
            }
            char c = arglist.charAt(nonarrayPos);
            if (c == 'L') {
                int semicolonPos = arglist.indexOf(59, nonarrayPos);
                if (semicolonPos == -1) {
                    throw new Error("Malformed arglist: " + arglist);
                }
                String fieldDescriptor = arglist.substring(pos, semicolonPos + 1);
                result = result + JvmUtil.fieldDescriptorToBinaryName(fieldDescriptor);
                pos = semicolonPos + 1;
                continue;
            }
            String maybe = JvmUtil.fieldDescriptorToBinaryName(arglist.substring(pos, nonarrayPos + 1));
            if (maybe == null) {
                throw new Error("Malformed arglist: " + arglist);
            }
            result = result + maybe;
            pos = nonarrayPos + 1;
        }
        return result + ")";
    }

    static {
        primitiveClassesJvm.put("boolean", "Z");
        primitiveClassesJvm.put("byte", "B");
        primitiveClassesJvm.put("char", "C");
        primitiveClassesJvm.put("double", "D");
        primitiveClassesJvm.put("float", "F");
        primitiveClassesJvm.put("int", "I");
        primitiveClassesJvm.put("long", "J");
        primitiveClassesJvm.put("short", "S");
        primitiveClassesFromJvm = new HashMap(8);
        primitiveClassesFromJvm.put("Z", "boolean");
        primitiveClassesFromJvm.put("B", "byte");
        primitiveClassesFromJvm.put("C", "char");
        primitiveClassesFromJvm.put("D", "double");
        primitiveClassesFromJvm.put("F", "float");
        primitiveClassesFromJvm.put("I", "int");
        primitiveClassesFromJvm.put("J", "long");
        primitiveClassesFromJvm.put("S", "short");
    }
}

