/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.bcelutil;

import java.util.Arrays;
import org.apache.bcel.classfile.StackMapEntry;
import org.apache.bcel.classfile.StackMapType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.LineNumberGen;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.verifier.structurals.OperandStack;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.plumelib.bcelutil.StackMapUtils;
import org.plumelib.bcelutil.StackTypes;

public abstract class InstructionListUtils
extends StackMapUtils {
    protected final void append_inst(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown InstructionList il, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown Instruction inst) {
        if (inst instanceof LOOKUPSWITCH) {
            LOOKUPSWITCH ls = (LOOKUPSWITCH)inst;
            il.append((BranchInstruction)new LOOKUPSWITCH(ls.getMatchs(), ls.getTargets(), ls.getTarget()));
        } else if (inst instanceof TABLESWITCH) {
            TABLESWITCH ts = (TABLESWITCH)inst;
            il.append((BranchInstruction)new TABLESWITCH(ts.getMatchs(), ts.getTargets(), ts.getTarget()));
        } else if (inst instanceof IfInstruction) {
            IfInstruction ifi = (IfInstruction)inst;
            il.append(InstructionFactory.createBranchInstruction((short)inst.getOpcode(), (InstructionHandle)ifi.getTarget()));
        } else {
            il.append(inst);
        }
    }

    protected final void insert_at_method_start(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown MethodGen mg, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown InstructionList new_il) {
        InstructionList il = mg.getInstructionList();
        if (il == null) {
            return;
        }
        this.insert_before_handle(mg, il.getStart(), new_il, false);
    }

    protected final void insert_before_handle(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown MethodGen mg, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown InstructionHandle ih, @Nullable @LockPossiblyHeld @GuardedBy @UnknownKeyFor @Initialized @UnknownFormat @SignatureUnknown InstructionList new_il, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown boolean redirect_branches) {
        if (new_il == null) {
            return;
        }
        InstructionList il = mg.getInstructionList();
        if (il == null) {
            return;
        }
        new_il.setPositions();
        InstructionHandle new_end = new_il.getEnd();
        int new_length = new_end.getPosition() + new_end.getInstruction().getLength();
        this.print_stack_map_table("Before insert_inst");
        this.debug_instrument.log("  insert_inst: %d%n%s%n", new Object[]{new_il.getLength(), new_il});
        InstructionHandle new_start = il.insert(ih, new_il);
        if (redirect_branches) {
            il.redirectBranches(ih, new_start);
        }
        if (ih.hasTargeters()) {
            for (InstructionTargeter it : ih.getTargeters()) {
                if (it instanceof LineNumberGen) {
                    it.updateTarget(ih, new_start);
                    continue;
                }
                if (it instanceof LocalVariableGen) {
                    it.updateTarget(ih, new_end);
                    continue;
                }
                if (!(it instanceof CodeExceptionGen) || !redirect_branches) continue;
                CodeExceptionGen exc = (CodeExceptionGen)it;
                if (exc.getStartPC() == ih) {
                    exc.updateTarget(ih, new_start);
                    continue;
                }
                if (exc.getEndPC() == ih) {
                    exc.updateTarget(ih, new_end);
                    continue;
                }
                if (exc.getHandlerPC() == ih) {
                    exc.setHandlerPC(new_start);
                    continue;
                }
                System.out.printf("Malformed CodeException: %s%n", exc);
            }
        }
        il.setPositions();
        this.update_stack_map_offset(new_start.getPosition() - 1, new_length);
        this.modify_stack_maps_for_switches(new_start, il);
    }

    protected final @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown InstructionList build_il(Instruction ... instructions) {
        InstructionList il = new InstructionList();
        for (Instruction inst : instructions) {
            this.append_inst(il, inst);
        }
        return il;
    }

    protected final @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown StackMapType @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown [] calculate_live_local_types(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown MethodGen mg, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown int location) {
        int max_local_index = -1;
        Object[] local_map_types = new StackMapType[mg.getMaxLocals()];
        Arrays.fill(local_map_types, new StackMapType(0, -1, this.pool.getConstantPool()));
        for (LocalVariableGen lv : mg.getLocalVariables()) {
            if (location < lv.getStart().getPosition() || !lv.getLiveToEnd() && location >= lv.getEnd().getPosition()) continue;
            int i = lv.getIndex();
            local_map_types[i] = this.generate_StackMapType_from_Type(lv.getType());
            max_local_index = Math.max(max_local_index, i);
        }
        return (StackMapType[])Arrays.copyOf(local_map_types, max_local_index + 1);
    }

    protected final @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown StackMapType @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown [] calculate_live_stack_types(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown OperandStack stack) {
        int ss = stack.size();
        StackMapType[] stack_map_types = new StackMapType[ss];
        for (int ii = 0; ii < ss; ++ii) {
            stack_map_types[ii] = this.generate_StackMapType_from_Type(stack.peek(ss - ii - 1));
        }
        return stack_map_types;
    }

    protected final void replace_instructions(@LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown MethodGen mg, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown InstructionList il, @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownFormat @SignatureUnknown InstructionHandle ih, @Nullable @LockPossiblyHeld @GuardedBy @UnknownKeyFor @Initialized @UnknownFormat @SignatureUnknown InstructionList new_il) {
        InstructionHandle new_end;
        InstructionTargeter it3;
        int n;
        int n2;
        InstructionTargeter[] instructionTargeterArray;
        InstructionHandle tih;
        if (new_il == null) {
            return;
        }
        int old_length = ih.getInstruction().getLength();
        new_il.setPositions();
        InstructionHandle end = new_il.getEnd();
        int new_length = end.getPosition() + end.getInstruction().getLength();
        this.print_stack_map_table("Before replace_inst");
        this.debug_instrument.log("  replace_inst: %s %d%n%s%n", new Object[]{ih, new_il.getLength(), new_il});
        if (this.debug_instrument.enabled) {
            this.debug_instrument.log("replace_inst #0 %n", new Object[0]);
            for (tih = ih; tih != null; tih = tih.getNext()) {
                this.debug_instrument.log("inst: %s %n", new Object[]{tih});
                if (!tih.hasTargeters()) continue;
                instructionTargeterArray = tih.getTargeters();
                n2 = instructionTargeterArray.length;
                for (n = 0; n < n2; ++n) {
                    it3 = instructionTargeterArray[n];
                    this.debug_instrument.log("targeter: %s %n", new Object[]{it3});
                }
            }
        }
        if (new_il.getLength() == 1) {
            ih.setInstruction(new_il.getEnd().getInstruction());
            if (old_length == new_length) {
                return;
            }
            this.print_stack_map_table("replace_inst_with_single_inst B");
            il.setPositions();
            new_end = ih;
            this.update_stack_map_offset(ih.getPosition(), new_length - old_length);
            this.modify_stack_maps_for_switches(new_end, il);
        } else {
            this.print_stack_map_table("replace_inst_with_inst_list B");
            new_end = new_il.getEnd();
            InstructionHandle new_start = il.insert(ih, new_il);
            il.setPositions();
            new_length = new_end.getNext().getPosition() - new_start.getPosition();
            if (this.debug_instrument.enabled) {
                this.debug_instrument.log("replace_inst #0.5 %n", new Object[0]);
                for (tih = new_end; tih != null; tih = tih.getNext()) {
                    this.debug_instrument.log("inst: %s %n", new Object[]{tih});
                    if (!tih.hasTargeters()) continue;
                    instructionTargeterArray = tih.getTargeters();
                    n2 = instructionTargeterArray.length;
                    for (n = 0; n < n2; ++n) {
                        it3 = instructionTargeterArray[n];
                        this.debug_instrument.log("targeter: %s %n", new Object[]{it3});
                    }
                }
            }
            il.redirectBranches(ih, new_start);
            if (this.debug_instrument.enabled) {
                this.debug_instrument.log("replace_inst #1 %n", new Object[0]);
                for (tih = new_end; tih != null; tih = tih.getNext()) {
                    this.debug_instrument.log("inst: %s %n", new Object[]{tih});
                    if (!tih.hasTargeters()) continue;
                    instructionTargeterArray = tih.getTargeters();
                    n2 = instructionTargeterArray.length;
                    for (n = 0; n < n2; ++n) {
                        it3 = instructionTargeterArray[n];
                        this.debug_instrument.log("targeter: %s %n", new Object[]{it3});
                    }
                }
            }
            if (ih.hasTargeters()) {
                tih = ih.getTargeters();
                int n3 = ((InstructionTargeter[])tih).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    InstructionHandle it2 = tih[n2];
                    if (it2 instanceof LineNumberGen) {
                        it2.updateTarget(ih, new_start);
                        continue;
                    }
                    if (it2 instanceof LocalVariableGen) {
                        it2.updateTarget(ih, new_end);
                        continue;
                    }
                    if (it2 instanceof CodeExceptionGen) {
                        CodeExceptionGen exc = (CodeExceptionGen)it2;
                        if (exc.getStartPC() == ih) {
                            exc.updateTarget(ih, new_start);
                            continue;
                        }
                        if (exc.getEndPC() == ih) {
                            exc.updateTarget(ih, new_end);
                            continue;
                        }
                        if (exc.getHandlerPC() == ih) {
                            exc.setHandlerPC(new_start);
                            continue;
                        }
                        System.out.printf("Malformed CodeException: %s%n", exc);
                        continue;
                    }
                    System.out.printf("unexpected target %s%n", it2);
                }
            }
            if (this.debug_instrument.enabled) {
                this.debug_instrument.log("replace_inst #2 %n", new Object[0]);
                for (tih = new_end; tih != null; tih = tih.getNext()) {
                    this.debug_instrument.log("inst: %s %n", new Object[]{tih});
                    if (!tih.hasTargeters()) continue;
                    for (InstructionTargeter it3 : tih.getTargeters()) {
                        this.debug_instrument.log("targeter: %s %n", new Object[]{it3});
                    }
                }
            }
            try {
                il.delete(ih);
            }
            catch (Exception e) {
                System.out.printf("Can't delete instruction: %s at %s%n", mg.getClassName(), mg.getName());
                throw new Error("Can't delete instruction", e);
            }
            il.setPositions();
            if (this.debug_instrument.enabled) {
                this.debug_instrument.log("replace_inst #3 %n", new Object[0]);
                for (tih = new_end; tih != null; tih = tih.getNext()) {
                    this.debug_instrument.log("inst: %s %n", new Object[]{tih});
                    if (!tih.hasTargeters()) continue;
                    for (InstructionTargeter it3 : tih.getTargeters()) {
                        this.debug_instrument.log("targeter: %s %n", new Object[]{it3});
                    }
                }
            }
            if (this.needStackMap) {
                this.update_stack_map_offset(new_start.getPosition(), new_length - old_length);
                this.modify_stack_maps_for_switches(new_end, il);
                this.print_stack_map_table("replace_inst_with_inst_list C");
                InstructionHandle nih = new_start;
                int target_count = 0;
                int[] target_offsets = new int[2];
                new_end = new_end.getNext();
                for (nih = nih.getNext(); nih != new_end; nih = nih.getNext()) {
                    if (!nih.hasTargeters()) continue;
                    for (InstructionTargeter it4 : nih.getTargeters()) {
                        if (!(it4 instanceof BranchInstruction)) continue;
                        target_offsets[target_count++] = nih.getPosition();
                        this.debug_instrument.log("New branch target: %s %n", new Object[]{nih});
                    }
                }
                if (this.debug_instrument.enabled) {
                    this.debug_instrument.log("replace_inst #4 %n", new Object[0]);
                    for (InstructionHandle tih2 = new_end; tih2 != null; tih2 = tih2.getNext()) {
                        this.debug_instrument.log("inst: %s %n", new Object[]{tih2});
                        if (!tih2.hasTargeters()) continue;
                        for (InstructionTargeter it5 : tih2.getTargeters()) {
                            this.debug_instrument.log("targeter: %s %n", new Object[]{it5});
                        }
                    }
                }
                if (target_count != 0) {
                    OperandStack stack;
                    int cur_loc = new_start.getPosition();
                    int orig_size = this.stack_map_table.length;
                    StackMapEntry[] new_stack_map_table = new StackMapEntry[orig_size + target_count];
                    mg.setMaxStack();
                    StackTypes stack_types = this.bcel_calc_stack_types(mg);
                    int new_index = this.find_stack_map_index_before(target_offsets[0]) + 1;
                    StackMapType[] local_map_types = this.calculate_live_local_types(mg, cur_loc);
                    int local_map_index = local_map_types.length;
                    int number_extra_locals = local_map_index - this.number_active_locals;
                    assert (number_extra_locals >= 0) : "invalid extra locals count: " + this.number_active_locals + ", " + local_map_index;
                    System.arraycopy(this.stack_map_table, 0, new_stack_map_table, 0, new_index);
                    boolean need_full_maps = false;
                    for (int i = 0; i < target_count; ++i) {
                        stack = stack_types.get(target_offsets[i]);
                        this.debug_instrument.log("stack: %s %n", new Object[]{stack});
                        if (number_extra_locals == 0 && stack.size() == 1 && !need_full_maps) {
                            StackMapType stack_map_type0 = this.generate_StackMapType_from_Type(stack.peek(0));
                            StackMapType[] stack_map_types0 = new StackMapType[]{stack_map_type0};
                            new_stack_map_table[new_index + i] = new StackMapEntry(64, 0, null, stack_map_types0, this.pool.getConstantPool());
                        } else {
                            need_full_maps = true;
                            new_stack_map_table[new_index + i] = new StackMapEntry(255, 0, this.calculate_live_local_types(mg, target_offsets[i]), this.calculate_live_stack_types(stack), this.pool.getConstantPool());
                        }
                        new_stack_map_table[new_index + i].updateByteCodeOffset(target_offsets[i] - (this.running_offset + 1));
                        this.running_offset = target_offsets[i];
                    }
                    int remainder = orig_size - new_index;
                    if (remainder > 0) {
                        block18: while (nih != null) {
                            if (nih.hasTargeters()) {
                                for (InstructionTargeter it6 : nih.getTargeters()) {
                                    CodeExceptionGen exc;
                                    if (it6 instanceof BranchInstruction) {
                                        this.stack_map_table[new_index].updateByteCodeOffset(nih.getPosition() - target_offsets[target_count - 1] - 1 - this.stack_map_table[new_index].getByteCodeOffset());
                                        break block18;
                                    }
                                    if (!(it6 instanceof CodeExceptionGen) || (exc = (CodeExceptionGen)it6).getHandlerPC() != nih) continue;
                                    this.stack_map_table[new_index].updateByteCodeOffset(nih.getPosition() - target_offsets[target_count - 1] - 1 - this.stack_map_table[new_index].getByteCodeOffset());
                                    break block18;
                                }
                            }
                            nih = nih.getNext();
                        }
                        if (need_full_maps) {
                            while (remainder > 0) {
                                int stack_map_offset = this.stack_map_table[new_index].getByteCodeOffset();
                                this.running_offset = this.running_offset + stack_map_offset + 1;
                                stack = stack_types.get(this.running_offset);
                                new_stack_map_table[new_index + target_count] = new StackMapEntry(255, stack_map_offset, this.calculate_live_local_types(mg, this.running_offset), this.calculate_live_stack_types(stack), this.pool.getConstantPool());
                                ++new_index;
                                --remainder;
                            }
                        } else {
                            System.arraycopy(this.stack_map_table, new_index, new_stack_map_table, new_index + target_count, remainder);
                        }
                    }
                    this.stack_map_table = new_stack_map_table;
                }
            }
        }
        this.debug_instrument.log("%n", new Object[0]);
        this.print_stack_map_table("replace_inst After");
        if (this.debug_instrument.enabled) {
            this.debug_instrument.log("replace_inst #5 %n", new Object[0]);
            while (new_end != null) {
                this.debug_instrument.log("inst: %s %n", new Object[]{new_end});
                if (new_end.hasTargeters()) {
                    for (InstructionTargeter it7 : new_end.getTargeters()) {
                        this.debug_instrument.log("targeter: %s %n", new Object[]{it7});
                    }
                }
                new_end = new_end.getNext();
            }
        }
    }
}

