package org.plasmalabs.sdk.models.transaction

object IoTransactionValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.transaction.IoTransaction] {
  def validate(input: org.plasmalabs.sdk.models.transaction.IoTransaction): scalapb.validate.Result =
    scalapb.validate.Result.optional(input.transactionId) { _value =>
      org.plasmalabs.sdk.models.TransactionIdValidator.validate(_value)
    } &&
    scalapb.validate.Result.repeated(input.inputs.iterator) { _value =>
      org.plasmalabs.sdk.models.transaction.SpentTransactionOutputValidator.validate(_value)
    } &&
    scalapb.validate.Result.repeated(input.outputs.iterator) { _value =>
      org.plasmalabs.sdk.models.transaction.UnspentTransactionOutputValidator.validate(_value)
    } &&
    org.plasmalabs.sdk.models.DatumValidator.IoTransactionValidator.validate(input.datum)
  
}