package org.plasmalabs.sdk.models.box

object ValueValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Value] {
  def validate(input: org.plasmalabs.sdk.models.box.Value): scalapb.validate.Result =
    scalapb.validate.Result.optional(input.value.lvl) { _value =>
      org.plasmalabs.sdk.models.box.ValueValidator.LVLValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.topl) { _value =>
      org.plasmalabs.sdk.models.box.ValueValidator.TOPLValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.asset) { _value =>
      org.plasmalabs.sdk.models.box.ValueValidator.AssetValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.group) { _value =>
      org.plasmalabs.sdk.models.box.ValueValidator.GroupValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.series) { _value =>
      org.plasmalabs.sdk.models.box.ValueValidator.SeriesValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.updateProposal) { _value =>
      org.plasmalabs.sdk.models.box.ValueValidator.UpdateProposalValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.configProposal) { _value =>
      org.plasmalabs.sdk.models.box.ValueValidator.ConfigProposalValidator.validate(_value)
    }
  
  object LVLValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Value.LVL] {
    def validate(input: org.plasmalabs.sdk.models.box.Value.LVL): scalapb.validate.Result =
      org.plasmalabs.quivr.models.Int128Validator.validate(input.quantity)
    
  }
  object TOPLValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Value.TOPL] {
    def validate(input: org.plasmalabs.sdk.models.box.Value.TOPL): scalapb.validate.Result =
      org.plasmalabs.quivr.models.Int128Validator.validate(input.quantity) &&
      scalapb.validate.Result.optional(input.registration) { _value =>
        org.plasmalabs.consensus.models.StakingRegistrationValidator.validate(_value)
      }
    
  }
  object AssetValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Value.Asset] {
    def validate(input: org.plasmalabs.sdk.models.box.Value.Asset): scalapb.validate.Result =
      scalapb.validate.Result.optional(input.groupId) { _value =>
        org.plasmalabs.sdk.models.GroupIdValidator.validate(_value)
      } &&
      scalapb.validate.Result.optional(input.seriesId) { _value =>
        org.plasmalabs.sdk.models.SeriesIdValidator.validate(_value)
      } &&
      org.plasmalabs.quivr.models.Int128Validator.validate(input.quantity) &&
      scalapb.validate.Result.optional(input.groupAlloy) { _value =>
        scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("Value.Asset.groupAlloy", _value, 32))
      } &&
      scalapb.validate.Result.optional(input.seriesAlloy) { _value =>
        scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("Value.Asset.seriesAlloy", _value, 32))
      } &&
      scalapb.validate.Result.optional(input.commitment) { _value =>
        scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("Value.Asset.commitment", _value, 32))
      }
    
  }
  object GroupValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Value.Group] {
    def validate(input: org.plasmalabs.sdk.models.box.Value.Group): scalapb.validate.Result =
      org.plasmalabs.sdk.models.GroupIdValidator.validate(input.groupId) &&
      org.plasmalabs.quivr.models.Int128Validator.validate(input.quantity) &&
      scalapb.validate.Result.optional(input.fixedSeries) { _value =>
        org.plasmalabs.sdk.models.SeriesIdValidator.validate(_value)
      }
    
  }
  object SeriesValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Value.Series] {
    def validate(input: org.plasmalabs.sdk.models.box.Value.Series): scalapb.validate.Result =
      org.plasmalabs.sdk.models.SeriesIdValidator.validate(input.seriesId) &&
      org.plasmalabs.quivr.models.Int128Validator.validate(input.quantity)
    
  }
  object UpdateProposalValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Value.UpdateProposal] {
    def validate(input: org.plasmalabs.sdk.models.box.Value.UpdateProposal): scalapb.validate.Result =
      scalapb.validate.Result.optional(input.fEffective) { _value =>
        org.plasmalabs.quivr.models.RatioValidator.validate(_value)
      } &&
      scalapb.validate.Result.optional(input.vrfBaselineDifficulty) { _value =>
        org.plasmalabs.quivr.models.RatioValidator.validate(_value)
      } &&
      scalapb.validate.Result.optional(input.vrfAmplitude) { _value =>
        org.plasmalabs.quivr.models.RatioValidator.validate(_value)
      }
    
  }
  object ConfigProposalValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Value.ConfigProposal] {
    def validate(input: org.plasmalabs.sdk.models.box.Value.ConfigProposal): scalapb.validate.Result =
      scalapb.validate.Success
    
    object ValueEntryValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Value.ConfigProposal.ValueEntry] {
      def validate(input: org.plasmalabs.sdk.models.box.Value.ConfigProposal.ValueEntry): scalapb.validate.Result =
        scalapb.validate.Success
      
    }
  }
}