package org.plasmalabs.sdk.models.box

object LockValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Lock] {
  def validate(input: org.plasmalabs.sdk.models.box.Lock): scalapb.validate.Result =
    scalapb.validate.Result.optional(input.value.predicate) { _value =>
      org.plasmalabs.sdk.models.box.LockValidator.PredicateValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.image) { _value =>
      org.plasmalabs.sdk.models.box.LockValidator.ImageValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.commitment) { _value =>
      org.plasmalabs.sdk.models.box.LockValidator.CommitmentValidator.validate(_value)
    }
  
  object PredicateValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Lock.Predicate] {
    def validate(input: org.plasmalabs.sdk.models.box.Lock.Predicate): scalapb.validate.Result =
      scalapb.validate.Result.repeated(input.challenges.iterator) { _value =>
        org.plasmalabs.sdk.models.box.ChallengeValidator.validate(_value)
      }
    
  }
  object ImageValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Lock.Image] {
    def validate(input: org.plasmalabs.sdk.models.box.Lock.Image): scalapb.validate.Result =
      scalapb.validate.Result.repeated(input.leaves.iterator) { _value =>
        org.plasmalabs.sdk.models.LockIdValidator.validate(_value)
      }
    
  }
  object CommitmentValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Lock.Commitment] {
    def validate(input: org.plasmalabs.sdk.models.box.Lock.Commitment): scalapb.validate.Result =
      scalapb.validate.Result.optional(input.root) { _value =>
        org.plasmalabs.sdk.models.AccumulatorRootIdValidator.validate(_value)
      }
    
  }
}