package org.plasmalabs.sdk.models.box

object ChallengeValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Challenge] {
  def validate(input: org.plasmalabs.sdk.models.box.Challenge): scalapb.validate.Result =
    scalapb.validate.Result.optional(input.proposition.revealed) { _value =>
      org.plasmalabs.quivr.models.PropositionValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.proposition.previous) { _value =>
      org.plasmalabs.sdk.models.box.ChallengeValidator.PreviousPropositionValidator.validate(_value)
    }
  
  object PreviousPropositionValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Challenge.PreviousProposition] {
    def validate(input: org.plasmalabs.sdk.models.box.Challenge.PreviousProposition): scalapb.validate.Result =
      scalapb.validate.Result.optional(input.address) { _value =>
        org.plasmalabs.sdk.models.TransactionInputAddressValidator.validate(_value)
      }
    
  }
}