package org.plasmalabs.sdk.models.box

object AttestationValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Attestation] {
  def validate(input: org.plasmalabs.sdk.models.box.Attestation): scalapb.validate.Result =
    scalapb.validate.Result.optional(input.value.predicate) { _value =>
      org.plasmalabs.sdk.models.box.AttestationValidator.PredicateValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.image) { _value =>
      org.plasmalabs.sdk.models.box.AttestationValidator.ImageValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.commitment) { _value =>
      org.plasmalabs.sdk.models.box.AttestationValidator.CommitmentValidator.validate(_value)
    }
  
  object PredicateValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Attestation.Predicate] {
    def validate(input: org.plasmalabs.sdk.models.box.Attestation.Predicate): scalapb.validate.Result =
      org.plasmalabs.sdk.models.box.LockValidator.PredicateValidator.validate(input.lock) &&
      scalapb.validate.Result.repeated(input.responses.iterator) { _value =>
        org.plasmalabs.quivr.models.ProofValidator.validate(_value)
      }
    
  }
  object ImageValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Attestation.Image] {
    def validate(input: org.plasmalabs.sdk.models.box.Attestation.Image): scalapb.validate.Result =
      org.plasmalabs.sdk.models.box.LockValidator.ImageValidator.validate(input.lock) &&
      scalapb.validate.Result.repeated(input.known.iterator) { _value =>
        org.plasmalabs.sdk.models.box.ChallengeValidator.validate(_value)
      } &&
      scalapb.validate.Result.repeated(input.responses.iterator) { _value =>
        org.plasmalabs.quivr.models.ProofValidator.validate(_value)
      }
    
  }
  object CommitmentValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.box.Attestation.Commitment] {
    def validate(input: org.plasmalabs.sdk.models.box.Attestation.Commitment): scalapb.validate.Result =
      org.plasmalabs.sdk.models.box.LockValidator.CommitmentValidator.validate(input.lock) &&
      scalapb.validate.Result.repeated(input.known.iterator) { _value =>
        org.plasmalabs.sdk.models.box.ChallengeValidator.validate(_value)
      } &&
      scalapb.validate.Result.repeated(input.witness.iterator) { _value =>
        org.plasmalabs.quivr.models.WitnessValidator.validate(_value)
      } &&
      scalapb.validate.Result.repeated(input.responses.iterator) { _value =>
        org.plasmalabs.quivr.models.ProofValidator.validate(_value)
      }
    
  }
}