package org.plasmalabs.sdk.models

object EventValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.Event] {
  def validate(input: org.plasmalabs.sdk.models.Event): scalapb.validate.Result =
    scalapb.validate.Result.optional(input.value.eon) { _value =>
      org.plasmalabs.sdk.models.EventValidator.EonValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.era) { _value =>
      org.plasmalabs.sdk.models.EventValidator.EraValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.epoch) { _value =>
      org.plasmalabs.sdk.models.EventValidator.EpochValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.header) { _value =>
      org.plasmalabs.sdk.models.EventValidator.HeaderValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.ioTransaction) { _value =>
      org.plasmalabs.sdk.models.EventValidator.IoTransactionValidator.validate(_value)
    }
  
  object EonValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.Event.Eon] {
    def validate(input: org.plasmalabs.sdk.models.Event.Eon): scalapb.validate.Result =
      scalapb.validate.Success
    
  }
  object EraValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.Event.Era] {
    def validate(input: org.plasmalabs.sdk.models.Event.Era): scalapb.validate.Result =
      scalapb.validate.Success
    
  }
  object EpochValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.Event.Epoch] {
    def validate(input: org.plasmalabs.sdk.models.Event.Epoch): scalapb.validate.Result =
      scalapb.validate.Success
    
  }
  object HeaderValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.Event.Header] {
    def validate(input: org.plasmalabs.sdk.models.Event.Header): scalapb.validate.Result =
      scalapb.validate.Success
    
  }
  object IoTransactionValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.Event.IoTransaction] {
    def validate(input: org.plasmalabs.sdk.models.Event.IoTransaction): scalapb.validate.Result =
      org.plasmalabs.sdk.models.transaction.ScheduleValidator.validate(input.schedule) &&
      org.plasmalabs.quivr.models.SmallDataValidator.validate(input.metadata) &&
      scalapb.validate.Result.repeated(input.groupPolicies.iterator) { _value =>
        org.plasmalabs.sdk.models.GroupPolicyValidator.validate(_value)
      } &&
      scalapb.validate.Result.repeated(input.seriesPolicies.iterator) { _value =>
        org.plasmalabs.sdk.models.SeriesPolicyValidator.validate(_value)
      } &&
      scalapb.validate.Result.repeated(input.mintingStatements.iterator) { _value =>
        org.plasmalabs.sdk.models.AssetMintingStatementValidator.validate(_value)
      } &&
      scalapb.validate.Result.repeated(input.mergingStatements.iterator) { _value =>
        org.plasmalabs.sdk.models.AssetMergingStatementValidator.validate(_value)
      } &&
      scalapb.validate.Result.repeated(input.splittingStatements.iterator) { _value =>
        org.plasmalabs.sdk.models.AssetSplittingStatementValidator.validate(_value)
      }
    
  }
}