package org.plasmalabs.sdk.models

object DatumValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.Datum] {
  def validate(input: org.plasmalabs.sdk.models.Datum): scalapb.validate.Result =
    scalapb.validate.Result.optional(input.value.eon) { _value =>
      org.plasmalabs.sdk.models.DatumValidator.EonValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.era) { _value =>
      org.plasmalabs.sdk.models.DatumValidator.EraValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.epoch) { _value =>
      org.plasmalabs.sdk.models.DatumValidator.EpochValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.header) { _value =>
      org.plasmalabs.sdk.models.DatumValidator.HeaderValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.ioTransaction) { _value =>
      org.plasmalabs.sdk.models.DatumValidator.IoTransactionValidator.validate(_value)
    }
  
  object EonValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.Datum.Eon] {
    def validate(input: org.plasmalabs.sdk.models.Datum.Eon): scalapb.validate.Result =
      org.plasmalabs.sdk.models.EventValidator.EonValidator.validate(input.event)
    
  }
  object EraValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.Datum.Era] {
    def validate(input: org.plasmalabs.sdk.models.Datum.Era): scalapb.validate.Result =
      org.plasmalabs.sdk.models.EventValidator.EraValidator.validate(input.event)
    
  }
  object EpochValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.Datum.Epoch] {
    def validate(input: org.plasmalabs.sdk.models.Datum.Epoch): scalapb.validate.Result =
      org.plasmalabs.sdk.models.EventValidator.EpochValidator.validate(input.event)
    
  }
  object HeaderValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.Datum.Header] {
    def validate(input: org.plasmalabs.sdk.models.Datum.Header): scalapb.validate.Result =
      org.plasmalabs.sdk.models.EventValidator.HeaderValidator.validate(input.event)
    
  }
  object IoTransactionValidator extends scalapb.validate.Validator[org.plasmalabs.sdk.models.Datum.IoTransaction] {
    def validate(input: org.plasmalabs.sdk.models.Datum.IoTransaction): scalapb.validate.Result =
      org.plasmalabs.sdk.models.EventValidator.IoTransactionValidator.validate(input.event)
    
  }
}