package org.plasmalabs.quivr.models

object VerificationKeyValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.VerificationKey] {
  def validate(input: org.plasmalabs.quivr.models.VerificationKey): scalapb.validate.Result =
    scalapb.validate.Result.optional(input.vk.ed25519) { _value =>
      org.plasmalabs.quivr.models.VerificationKeyValidator.Ed25519VkValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.vk.extendedEd25519) { _value =>
      org.plasmalabs.quivr.models.VerificationKeyValidator.ExtendedEd25519VkValidator.validate(_value)
    } &&
    scalapb.validate.RequiredValidation("vk", input.vk)
  
  object Ed25519VkValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.VerificationKey.Ed25519Vk] {
    def validate(input: org.plasmalabs.quivr.models.VerificationKey.Ed25519Vk): scalapb.validate.Result =
      scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("VerificationKey.Ed25519Vk.value", input.value, 32))
    
  }
  object ExtendedEd25519VkValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.VerificationKey.ExtendedEd25519Vk] {
    def validate(input: org.plasmalabs.quivr.models.VerificationKey.ExtendedEd25519Vk): scalapb.validate.Result =
      org.plasmalabs.quivr.models.VerificationKeyValidator.Ed25519VkValidator.validate(input.vk) &&
      scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("VerificationKey.ExtendedEd25519Vk.chainCode", input.chainCode, 32))
    
  }
}