package org.plasmalabs.quivr.models

object SigningKeyValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.SigningKey] {
  def validate(input: org.plasmalabs.quivr.models.SigningKey): scalapb.validate.Result =
    scalapb.validate.Result.optional(input.sk.ed25519) { _value =>
      org.plasmalabs.quivr.models.SigningKeyValidator.Ed25519SkValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.sk.extendedEd25519) { _value =>
      org.plasmalabs.quivr.models.SigningKeyValidator.ExtendedEd25519SkValidator.validate(_value)
    } &&
    scalapb.validate.RequiredValidation("sk", input.sk)
  
  object Ed25519SkValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.SigningKey.Ed25519Sk] {
    def validate(input: org.plasmalabs.quivr.models.SigningKey.Ed25519Sk): scalapb.validate.Result =
      scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("SigningKey.Ed25519Sk.value", input.value, 32))
    
  }
  object ExtendedEd25519SkValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.SigningKey.ExtendedEd25519Sk] {
    def validate(input: org.plasmalabs.quivr.models.SigningKey.ExtendedEd25519Sk): scalapb.validate.Result =
      scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("SigningKey.ExtendedEd25519Sk.leftKey", input.leftKey, 32)) &&
      scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("SigningKey.ExtendedEd25519Sk.rightKey", input.rightKey, 32)) &&
      scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("SigningKey.ExtendedEd25519Sk.chainCode", input.chainCode, 32))
    
  }
}