package org.plasmalabs.quivr.models

object PropositionValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proposition] {
  def validate(input: org.plasmalabs.quivr.models.Proposition): scalapb.validate.Result =
    scalapb.validate.Result.optional(input.value.locked) { _value =>
      org.plasmalabs.quivr.models.PropositionValidator.LockedValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.digest) { _value =>
      org.plasmalabs.quivr.models.PropositionValidator.DigestValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.digitalSignature) { _value =>
      org.plasmalabs.quivr.models.PropositionValidator.DigitalSignatureValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.heightRange) { _value =>
      org.plasmalabs.quivr.models.PropositionValidator.HeightRangeValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.tickRange) { _value =>
      org.plasmalabs.quivr.models.PropositionValidator.TickRangeValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.exactMatch) { _value =>
      org.plasmalabs.quivr.models.PropositionValidator.ExactMatchValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.lessThan) { _value =>
      org.plasmalabs.quivr.models.PropositionValidator.LessThanValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.greaterThan) { _value =>
      org.plasmalabs.quivr.models.PropositionValidator.GreaterThanValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.equalTo) { _value =>
      org.plasmalabs.quivr.models.PropositionValidator.EqualToValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.threshold) { _value =>
      org.plasmalabs.quivr.models.PropositionValidator.ThresholdValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.not) { _value =>
      org.plasmalabs.quivr.models.PropositionValidator.NotValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.and) { _value =>
      org.plasmalabs.quivr.models.PropositionValidator.AndValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.or) { _value =>
      org.plasmalabs.quivr.models.PropositionValidator.OrValidator.validate(_value)
    }
  
  object LockedValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proposition.Locked] {
    def validate(input: org.plasmalabs.quivr.models.Proposition.Locked): scalapb.validate.Result =
      scalapb.validate.Result.optional(input.data) { _value =>
        org.plasmalabs.quivr.models.DataValidator.validate(_value)
      }
    
  }
  object DigestValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proposition.Digest] {
    def validate(input: org.plasmalabs.quivr.models.Proposition.Digest): scalapb.validate.Result =
      org.plasmalabs.quivr.models.DigestValidator.validate(input.digest)
    
  }
  object DigitalSignatureValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proposition.DigitalSignature] {
    def validate(input: org.plasmalabs.quivr.models.Proposition.DigitalSignature): scalapb.validate.Result =
      org.plasmalabs.quivr.models.VerificationKeyValidator.validate(input.verificationKey)
    
  }
  object HeightRangeValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proposition.HeightRange] {
    def validate(input: org.plasmalabs.quivr.models.Proposition.HeightRange): scalapb.validate.Result =
      scalapb.validate.Success
    
  }
  object TickRangeValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proposition.TickRange] {
    def validate(input: org.plasmalabs.quivr.models.Proposition.TickRange): scalapb.validate.Result =
      scalapb.validate.Success
    
  }
  object ExactMatchValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proposition.ExactMatch] {
    def validate(input: org.plasmalabs.quivr.models.Proposition.ExactMatch): scalapb.validate.Result =
      scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.maxLength("Proposition.ExactMatch.compareTo", input.compareTo, 64))
    
  }
  object LessThanValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proposition.LessThan] {
    def validate(input: org.plasmalabs.quivr.models.Proposition.LessThan): scalapb.validate.Result =
      org.plasmalabs.quivr.models.Int128Validator.validate(input.compareTo)
    
  }
  object GreaterThanValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proposition.GreaterThan] {
    def validate(input: org.plasmalabs.quivr.models.Proposition.GreaterThan): scalapb.validate.Result =
      org.plasmalabs.quivr.models.Int128Validator.validate(input.compareTo)
    
  }
  object EqualToValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proposition.EqualTo] {
    def validate(input: org.plasmalabs.quivr.models.Proposition.EqualTo): scalapb.validate.Result =
      org.plasmalabs.quivr.models.Int128Validator.validate(input.compareTo)
    
  }
  object ThresholdValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proposition.Threshold] {
    def validate(input: org.plasmalabs.quivr.models.Proposition.Threshold): scalapb.validate.Result =
      scalapb.validate.Result.repeated(input.challenges.iterator) { _value =>
        org.plasmalabs.quivr.models.PropositionValidator.validate(_value)
      }
    
  }
  object NotValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proposition.Not] {
    def validate(input: org.plasmalabs.quivr.models.Proposition.Not): scalapb.validate.Result =
      org.plasmalabs.quivr.models.PropositionValidator.validate(input.proposition)
    
  }
  object AndValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proposition.And] {
    def validate(input: org.plasmalabs.quivr.models.Proposition.And): scalapb.validate.Result =
      org.plasmalabs.quivr.models.PropositionValidator.validate(input.left) &&
      org.plasmalabs.quivr.models.PropositionValidator.validate(input.right)
    
  }
  object OrValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proposition.Or] {
    def validate(input: org.plasmalabs.quivr.models.Proposition.Or): scalapb.validate.Result =
      org.plasmalabs.quivr.models.PropositionValidator.validate(input.left) &&
      org.plasmalabs.quivr.models.PropositionValidator.validate(input.right)
    
  }
}