package org.plasmalabs.quivr.models

object ProofValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proof] {
  def validate(input: org.plasmalabs.quivr.models.Proof): scalapb.validate.Result =
    scalapb.validate.Result.optional(input.value.locked) { _value =>
      org.plasmalabs.quivr.models.ProofValidator.LockedValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.digest) { _value =>
      org.plasmalabs.quivr.models.ProofValidator.DigestValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.digitalSignature) { _value =>
      org.plasmalabs.quivr.models.ProofValidator.DigitalSignatureValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.heightRange) { _value =>
      org.plasmalabs.quivr.models.ProofValidator.HeightRangeValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.tickRange) { _value =>
      org.plasmalabs.quivr.models.ProofValidator.TickRangeValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.exactMatch) { _value =>
      org.plasmalabs.quivr.models.ProofValidator.ExactMatchValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.lessThan) { _value =>
      org.plasmalabs.quivr.models.ProofValidator.LessThanValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.greaterThan) { _value =>
      org.plasmalabs.quivr.models.ProofValidator.GreaterThanValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.equalTo) { _value =>
      org.plasmalabs.quivr.models.ProofValidator.EqualToValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.threshold) { _value =>
      org.plasmalabs.quivr.models.ProofValidator.ThresholdValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.not) { _value =>
      org.plasmalabs.quivr.models.ProofValidator.NotValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.and) { _value =>
      org.plasmalabs.quivr.models.ProofValidator.AndValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.value.or) { _value =>
      org.plasmalabs.quivr.models.ProofValidator.OrValidator.validate(_value)
    }
  
  object LockedValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proof.Locked] {
    def validate(input: org.plasmalabs.quivr.models.Proof.Locked): scalapb.validate.Result =
      scalapb.validate.Success
    
  }
  object DigestValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proof.Digest] {
    def validate(input: org.plasmalabs.quivr.models.Proof.Digest): scalapb.validate.Result =
      org.plasmalabs.quivr.models.TxBindValidator.validate(input.transactionBind) &&
      org.plasmalabs.quivr.models.PreimageValidator.validate(input.preimage)
    
  }
  object DigitalSignatureValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proof.DigitalSignature] {
    def validate(input: org.plasmalabs.quivr.models.Proof.DigitalSignature): scalapb.validate.Result =
      org.plasmalabs.quivr.models.TxBindValidator.validate(input.transactionBind) &&
      org.plasmalabs.quivr.models.WitnessValidator.validate(input.witness)
    
  }
  object HeightRangeValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proof.HeightRange] {
    def validate(input: org.plasmalabs.quivr.models.Proof.HeightRange): scalapb.validate.Result =
      org.plasmalabs.quivr.models.TxBindValidator.validate(input.transactionBind)
    
  }
  object TickRangeValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proof.TickRange] {
    def validate(input: org.plasmalabs.quivr.models.Proof.TickRange): scalapb.validate.Result =
      org.plasmalabs.quivr.models.TxBindValidator.validate(input.transactionBind)
    
  }
  object ExactMatchValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proof.ExactMatch] {
    def validate(input: org.plasmalabs.quivr.models.Proof.ExactMatch): scalapb.validate.Result =
      org.plasmalabs.quivr.models.TxBindValidator.validate(input.transactionBind)
    
  }
  object LessThanValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proof.LessThan] {
    def validate(input: org.plasmalabs.quivr.models.Proof.LessThan): scalapb.validate.Result =
      org.plasmalabs.quivr.models.TxBindValidator.validate(input.transactionBind)
    
  }
  object GreaterThanValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proof.GreaterThan] {
    def validate(input: org.plasmalabs.quivr.models.Proof.GreaterThan): scalapb.validate.Result =
      org.plasmalabs.quivr.models.TxBindValidator.validate(input.transactionBind)
    
  }
  object EqualToValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proof.EqualTo] {
    def validate(input: org.plasmalabs.quivr.models.Proof.EqualTo): scalapb.validate.Result =
      org.plasmalabs.quivr.models.TxBindValidator.validate(input.transactionBind)
    
  }
  object ThresholdValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proof.Threshold] {
    def validate(input: org.plasmalabs.quivr.models.Proof.Threshold): scalapb.validate.Result =
      org.plasmalabs.quivr.models.TxBindValidator.validate(input.transactionBind) &&
      scalapb.validate.Result.repeated(input.responses.iterator) { _value =>
        org.plasmalabs.quivr.models.ProofValidator.validate(_value)
      }
    
  }
  object NotValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proof.Not] {
    def validate(input: org.plasmalabs.quivr.models.Proof.Not): scalapb.validate.Result =
      org.plasmalabs.quivr.models.TxBindValidator.validate(input.transactionBind) &&
      org.plasmalabs.quivr.models.ProofValidator.validate(input.proof)
    
  }
  object AndValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proof.And] {
    def validate(input: org.plasmalabs.quivr.models.Proof.And): scalapb.validate.Result =
      org.plasmalabs.quivr.models.TxBindValidator.validate(input.transactionBind) &&
      org.plasmalabs.quivr.models.ProofValidator.validate(input.left) &&
      org.plasmalabs.quivr.models.ProofValidator.validate(input.right)
    
  }
  object OrValidator extends scalapb.validate.Validator[org.plasmalabs.quivr.models.Proof.Or] {
    def validate(input: org.plasmalabs.quivr.models.Proof.Or): scalapb.validate.Result =
      org.plasmalabs.quivr.models.TxBindValidator.validate(input.transactionBind) &&
      org.plasmalabs.quivr.models.ProofValidator.validate(input.left) &&
      org.plasmalabs.quivr.models.ProofValidator.validate(input.right)
    
  }
}