package org.plasmalabs.node.services

import _root_.cats.syntax.all._

trait NodeRpcFs2GrpcTrailers[F[_], A] {
  def broadcastTransaction(request: org.plasmalabs.node.services.BroadcastTransactionReq, ctx: A): F[(org.plasmalabs.node.services.BroadcastTransactionRes, _root_.io.grpc.Metadata)]
  def currentMempool(request: org.plasmalabs.node.services.CurrentMempoolReq, ctx: A): F[(org.plasmalabs.node.services.CurrentMempoolRes, _root_.io.grpc.Metadata)]
  def currentMempoolContains(request: org.plasmalabs.node.services.CurrentMempoolContainsReq, ctx: A): F[(org.plasmalabs.node.services.CurrentMempoolContainsRes, _root_.io.grpc.Metadata)]
  def fetchBlockHeader(request: org.plasmalabs.node.services.FetchBlockHeaderReq, ctx: A): F[(org.plasmalabs.node.services.FetchBlockHeaderRes, _root_.io.grpc.Metadata)]
  def fetchBlockBody(request: org.plasmalabs.node.services.FetchBlockBodyReq, ctx: A): F[(org.plasmalabs.node.services.FetchBlockBodyRes, _root_.io.grpc.Metadata)]
  def fetchTransaction(request: org.plasmalabs.node.services.FetchTransactionReq, ctx: A): F[(org.plasmalabs.node.services.FetchTransactionRes, _root_.io.grpc.Metadata)]
  def fetchBlockIdAtHeight(request: org.plasmalabs.node.services.FetchBlockIdAtHeightReq, ctx: A): F[(org.plasmalabs.node.services.FetchBlockIdAtHeightRes, _root_.io.grpc.Metadata)]
  def fetchBlockIdAtDepth(request: org.plasmalabs.node.services.FetchBlockIdAtDepthReq, ctx: A): F[(org.plasmalabs.node.services.FetchBlockIdAtDepthRes, _root_.io.grpc.Metadata)]
  def synchronizationTraversal(request: org.plasmalabs.node.services.SynchronizationTraversalReq, ctx: A): _root_.fs2.Stream[F, org.plasmalabs.node.services.SynchronizationTraversalRes]
  def fetchNodeConfig(request: org.plasmalabs.node.services.FetchNodeConfigReq, ctx: A): _root_.fs2.Stream[F, org.plasmalabs.node.services.FetchNodeConfigRes]
  def fetchEpochData(request: org.plasmalabs.node.services.FetchEpochDataReq, ctx: A): F[(org.plasmalabs.node.services.FetchEpochDataRes, _root_.io.grpc.Metadata)]
}

object NodeRpcFs2GrpcTrailers extends _root_.fs2.grpc.GeneratedCompanion[NodeRpcFs2GrpcTrailers] {
  
  def serviceDescriptor: _root_.io.grpc.ServiceDescriptor = org.plasmalabs.node.services.NodeRpcGrpc.SERVICE
  
  def mkClient[F[_]: _root_.cats.effect.Async, A](dispatcher: _root_.cats.effect.std.Dispatcher[F], channel: _root_.io.grpc.Channel, mkMetadata: A => F[_root_.io.grpc.Metadata], clientOptions: _root_.fs2.grpc.client.ClientOptions): NodeRpcFs2GrpcTrailers[F, A] = new NodeRpcFs2GrpcTrailers[F, A] {
    def broadcastTransaction(request: org.plasmalabs.node.services.BroadcastTransactionReq, ctx: A): F[(org.plasmalabs.node.services.BroadcastTransactionRes, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.node.services.NodeRpcGrpc.METHOD_BROADCAST_TRANSACTION, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
    def currentMempool(request: org.plasmalabs.node.services.CurrentMempoolReq, ctx: A): F[(org.plasmalabs.node.services.CurrentMempoolRes, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.node.services.NodeRpcGrpc.METHOD_CURRENT_MEMPOOL, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
    def currentMempoolContains(request: org.plasmalabs.node.services.CurrentMempoolContainsReq, ctx: A): F[(org.plasmalabs.node.services.CurrentMempoolContainsRes, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.node.services.NodeRpcGrpc.METHOD_CURRENT_MEMPOOL_CONTAINS, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
    def fetchBlockHeader(request: org.plasmalabs.node.services.FetchBlockHeaderReq, ctx: A): F[(org.plasmalabs.node.services.FetchBlockHeaderRes, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.node.services.NodeRpcGrpc.METHOD_FETCH_BLOCK_HEADER, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
    def fetchBlockBody(request: org.plasmalabs.node.services.FetchBlockBodyReq, ctx: A): F[(org.plasmalabs.node.services.FetchBlockBodyRes, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.node.services.NodeRpcGrpc.METHOD_FETCH_BLOCK_BODY, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
    def fetchTransaction(request: org.plasmalabs.node.services.FetchTransactionReq, ctx: A): F[(org.plasmalabs.node.services.FetchTransactionRes, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.node.services.NodeRpcGrpc.METHOD_FETCH_TRANSACTION, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
    def fetchBlockIdAtHeight(request: org.plasmalabs.node.services.FetchBlockIdAtHeightReq, ctx: A): F[(org.plasmalabs.node.services.FetchBlockIdAtHeightRes, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.node.services.NodeRpcGrpc.METHOD_FETCH_BLOCK_ID_AT_HEIGHT, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
    def fetchBlockIdAtDepth(request: org.plasmalabs.node.services.FetchBlockIdAtDepthReq, ctx: A): F[(org.plasmalabs.node.services.FetchBlockIdAtDepthRes, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.node.services.NodeRpcGrpc.METHOD_FETCH_BLOCK_ID_AT_DEPTH, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
    def synchronizationTraversal(request: org.plasmalabs.node.services.SynchronizationTraversalReq, ctx: A): _root_.fs2.Stream[F, org.plasmalabs.node.services.SynchronizationTraversalRes] = {
      _root_.fs2.Stream.eval(mkMetadata(ctx)).flatMap { m =>
        _root_.fs2.Stream.eval(_root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.node.services.NodeRpcGrpc.METHOD_SYNCHRONIZATION_TRAVERSAL, dispatcher, clientOptions)).flatMap(_.unaryToStreamingCall(request, m))
      }
    }
    def fetchNodeConfig(request: org.plasmalabs.node.services.FetchNodeConfigReq, ctx: A): _root_.fs2.Stream[F, org.plasmalabs.node.services.FetchNodeConfigRes] = {
      _root_.fs2.Stream.eval(mkMetadata(ctx)).flatMap { m =>
        _root_.fs2.Stream.eval(_root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.node.services.NodeRpcGrpc.METHOD_FETCH_NODE_CONFIG, dispatcher, clientOptions)).flatMap(_.unaryToStreamingCall(request, m))
      }
    }
    def fetchEpochData(request: org.plasmalabs.node.services.FetchEpochDataReq, ctx: A): F[(org.plasmalabs.node.services.FetchEpochDataRes, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.node.services.NodeRpcGrpc.METHOD_FETCH_EPOCH_DATA, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
  }
  
  protected def serviceBinding[F[_]: _root_.cats.effect.Async, A](dispatcher: _root_.cats.effect.std.Dispatcher[F], serviceImpl: NodeRpcFs2GrpcTrailers[F, A], mkCtx: _root_.io.grpc.Metadata => F[A], serverOptions: _root_.fs2.grpc.server.ServerOptions): _root_.io.grpc.ServerServiceDefinition = {
    _root_.io.grpc.ServerServiceDefinition
      .builder(org.plasmalabs.node.services.NodeRpcGrpc.SERVICE)
      .addMethod(org.plasmalabs.node.services.NodeRpcGrpc.METHOD_BROADCAST_TRANSACTION, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.node.services.BroadcastTransactionReq, org.plasmalabs.node.services.BroadcastTransactionRes]((r, m) => mkCtx(m).flatMap(serviceImpl.broadcastTransaction(r, _))))
      .addMethod(org.plasmalabs.node.services.NodeRpcGrpc.METHOD_CURRENT_MEMPOOL, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.node.services.CurrentMempoolReq, org.plasmalabs.node.services.CurrentMempoolRes]((r, m) => mkCtx(m).flatMap(serviceImpl.currentMempool(r, _))))
      .addMethod(org.plasmalabs.node.services.NodeRpcGrpc.METHOD_CURRENT_MEMPOOL_CONTAINS, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.node.services.CurrentMempoolContainsReq, org.plasmalabs.node.services.CurrentMempoolContainsRes]((r, m) => mkCtx(m).flatMap(serviceImpl.currentMempoolContains(r, _))))
      .addMethod(org.plasmalabs.node.services.NodeRpcGrpc.METHOD_FETCH_BLOCK_HEADER, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.node.services.FetchBlockHeaderReq, org.plasmalabs.node.services.FetchBlockHeaderRes]((r, m) => mkCtx(m).flatMap(serviceImpl.fetchBlockHeader(r, _))))
      .addMethod(org.plasmalabs.node.services.NodeRpcGrpc.METHOD_FETCH_BLOCK_BODY, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.node.services.FetchBlockBodyReq, org.plasmalabs.node.services.FetchBlockBodyRes]((r, m) => mkCtx(m).flatMap(serviceImpl.fetchBlockBody(r, _))))
      .addMethod(org.plasmalabs.node.services.NodeRpcGrpc.METHOD_FETCH_TRANSACTION, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.node.services.FetchTransactionReq, org.plasmalabs.node.services.FetchTransactionRes]((r, m) => mkCtx(m).flatMap(serviceImpl.fetchTransaction(r, _))))
      .addMethod(org.plasmalabs.node.services.NodeRpcGrpc.METHOD_FETCH_BLOCK_ID_AT_HEIGHT, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.node.services.FetchBlockIdAtHeightReq, org.plasmalabs.node.services.FetchBlockIdAtHeightRes]((r, m) => mkCtx(m).flatMap(serviceImpl.fetchBlockIdAtHeight(r, _))))
      .addMethod(org.plasmalabs.node.services.NodeRpcGrpc.METHOD_FETCH_BLOCK_ID_AT_DEPTH, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.node.services.FetchBlockIdAtDepthReq, org.plasmalabs.node.services.FetchBlockIdAtDepthRes]((r, m) => mkCtx(m).flatMap(serviceImpl.fetchBlockIdAtDepth(r, _))))
      .addMethod(org.plasmalabs.node.services.NodeRpcGrpc.METHOD_SYNCHRONIZATION_TRAVERSAL, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToStreamingCall[org.plasmalabs.node.services.SynchronizationTraversalReq, org.plasmalabs.node.services.SynchronizationTraversalRes]((r, m) => _root_.fs2.Stream.eval(mkCtx(m)).flatMap(serviceImpl.synchronizationTraversal(r, _))))
      .addMethod(org.plasmalabs.node.services.NodeRpcGrpc.METHOD_FETCH_NODE_CONFIG, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToStreamingCall[org.plasmalabs.node.services.FetchNodeConfigReq, org.plasmalabs.node.services.FetchNodeConfigRes]((r, m) => _root_.fs2.Stream.eval(mkCtx(m)).flatMap(serviceImpl.fetchNodeConfig(r, _))))
      .addMethod(org.plasmalabs.node.services.NodeRpcGrpc.METHOD_FETCH_EPOCH_DATA, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.node.services.FetchEpochDataReq, org.plasmalabs.node.services.FetchEpochDataRes]((r, m) => mkCtx(m).flatMap(serviceImpl.fetchEpochData(r, _))))
      .build()
  }

}