package org.plasmalabs.node.services

import _root_.cats.syntax.all._

trait NetworkControlRpcFs2Grpc[F[_], A] {
  def getHostId(request: org.plasmalabs.node.services.GetHostIdReq, ctx: A): F[org.plasmalabs.node.services.GetHostIdRes]
  def forgetPeer(request: org.plasmalabs.node.services.ForgetPeerReq, ctx: A): F[org.plasmalabs.node.services.ForgetPeerRes]
  def addPeer(request: org.plasmalabs.node.services.AddPeerReq, ctx: A): F[org.plasmalabs.node.services.AddPeerRes]
}

object NetworkControlRpcFs2Grpc extends _root_.fs2.grpc.GeneratedCompanion[NetworkControlRpcFs2Grpc] {
  
  def serviceDescriptor: _root_.io.grpc.ServiceDescriptor = org.plasmalabs.node.services.NetworkControlRpcGrpc.SERVICE
  
  def mkClient[F[_]: _root_.cats.effect.Async, A](dispatcher: _root_.cats.effect.std.Dispatcher[F], channel: _root_.io.grpc.Channel, mkMetadata: A => F[_root_.io.grpc.Metadata], clientOptions: _root_.fs2.grpc.client.ClientOptions): NetworkControlRpcFs2Grpc[F, A] = new NetworkControlRpcFs2Grpc[F, A] {
    def getHostId(request: org.plasmalabs.node.services.GetHostIdReq, ctx: A): F[org.plasmalabs.node.services.GetHostIdRes] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.node.services.NetworkControlRpcGrpc.METHOD_GET_HOST_ID, dispatcher, clientOptions).flatMap(_.unaryToUnaryCall(request, m))
      }
    }
    def forgetPeer(request: org.plasmalabs.node.services.ForgetPeerReq, ctx: A): F[org.plasmalabs.node.services.ForgetPeerRes] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.node.services.NetworkControlRpcGrpc.METHOD_FORGET_PEER, dispatcher, clientOptions).flatMap(_.unaryToUnaryCall(request, m))
      }
    }
    def addPeer(request: org.plasmalabs.node.services.AddPeerReq, ctx: A): F[org.plasmalabs.node.services.AddPeerRes] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.node.services.NetworkControlRpcGrpc.METHOD_ADD_PEER, dispatcher, clientOptions).flatMap(_.unaryToUnaryCall(request, m))
      }
    }
  }
  
  protected def serviceBinding[F[_]: _root_.cats.effect.Async, A](dispatcher: _root_.cats.effect.std.Dispatcher[F], serviceImpl: NetworkControlRpcFs2Grpc[F, A], mkCtx: _root_.io.grpc.Metadata => F[A], serverOptions: _root_.fs2.grpc.server.ServerOptions): _root_.io.grpc.ServerServiceDefinition = {
    _root_.io.grpc.ServerServiceDefinition
      .builder(org.plasmalabs.node.services.NetworkControlRpcGrpc.SERVICE)
      .addMethod(org.plasmalabs.node.services.NetworkControlRpcGrpc.METHOD_GET_HOST_ID, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCall[org.plasmalabs.node.services.GetHostIdReq, org.plasmalabs.node.services.GetHostIdRes]((r, m) => mkCtx(m).flatMap(serviceImpl.getHostId(r, _))))
      .addMethod(org.plasmalabs.node.services.NetworkControlRpcGrpc.METHOD_FORGET_PEER, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCall[org.plasmalabs.node.services.ForgetPeerReq, org.plasmalabs.node.services.ForgetPeerRes]((r, m) => mkCtx(m).flatMap(serviceImpl.forgetPeer(r, _))))
      .addMethod(org.plasmalabs.node.services.NetworkControlRpcGrpc.METHOD_ADD_PEER, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCall[org.plasmalabs.node.services.AddPeerReq, org.plasmalabs.node.services.AddPeerRes]((r, m) => mkCtx(m).flatMap(serviceImpl.addPeer(r, _))))
      .build()
  }

}