package org.plasmalabs.node.services

object AddPeerReqValidator extends scalapb.validate.Validator[org.plasmalabs.node.services.AddPeerReq] {
  def validate(input: org.plasmalabs.node.services.AddPeerReq): scalapb.validate.Result =
    scalapb.validate.Result.optional(input.id) { _value =>
      org.plasmalabs.node.services.RpcHostIdValidator.validate(_value)
    } &&
    scalapb.validate.Result.run(io.envoyproxy.pgv.StringValidation.address("AddPeerReq.ip", input.ip)) &&
    scalapb.validate.ComparativeValidation.rangeGteLte("AddPeerReq.port", input.port, 1, 65535)
  
}