package org.plasmalabs.node.models

object KnownHostValidator extends scalapb.validate.Validator[org.plasmalabs.node.models.KnownHost] {
  def validate(input: org.plasmalabs.node.models.KnownHost): scalapb.validate.Result =
    scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("KnownHost.id", input.id, 32)) &&
    scalapb.validate.Result.run(io.envoyproxy.pgv.StringValidation.minLength("KnownHost.host", input.host, 1))&&
    scalapb.validate.Result.run(io.envoyproxy.pgv.StringValidation.maxLength("KnownHost.host", input.host, 255))
  
}