package org.plasmalabs.indexer.services

object TxoValidator extends scalapb.validate.Validator[org.plasmalabs.indexer.services.Txo] {
  def validate(input: org.plasmalabs.indexer.services.Txo): scalapb.validate.Result =
    org.plasmalabs.sdk.models.transaction.UnspentTransactionOutputValidator.validate(input.transactionOutput) &&
    org.plasmalabs.sdk.models.TransactionOutputAddressValidator.validate(input.outputAddress) &&
    scalapb.validate.Result.optional(input.spender) { _value =>
      org.plasmalabs.indexer.services.TxoValidator.SpenderValidator.validate(_value)
    }
  
  object SpenderValidator extends scalapb.validate.Validator[org.plasmalabs.indexer.services.Txo.Spender] {
    def validate(input: org.plasmalabs.indexer.services.Txo.Spender): scalapb.validate.Result =
      org.plasmalabs.sdk.models.TransactionInputAddressValidator.validate(input.inputAddress) &&
      org.plasmalabs.sdk.models.transaction.SpentTransactionOutputValidator.validate(input.input)
    
  }
}