package org.plasmalabs.indexer.services

import _root_.cats.syntax.all._

trait TransactionServiceFs2GrpcTrailers[F[_], A] {
  def getTransactionById(request: org.plasmalabs.indexer.services.GetTransactionByIdRequest, ctx: A): F[(org.plasmalabs.indexer.services.TransactionResponse, _root_.io.grpc.Metadata)]
  def getTransactionByLockAddressStream(request: org.plasmalabs.indexer.services.QueryByLockAddressRequest, ctx: A): _root_.fs2.Stream[F, org.plasmalabs.indexer.services.TransactionResponse]
  def getTxosByLockAddress(request: org.plasmalabs.indexer.services.QueryByLockAddressRequest, ctx: A): F[(org.plasmalabs.indexer.services.TxoLockAddressResponse, _root_.io.grpc.Metadata)]
  def getTxosByLockAddressStream(request: org.plasmalabs.indexer.services.QueryByLockAddressRequest, ctx: A): _root_.fs2.Stream[F, org.plasmalabs.indexer.services.TxoLockAddressResponse]
  def getTxosByAssetLabel(request: org.plasmalabs.indexer.services.QueryByAssetLabelRequest, ctx: A): _root_.fs2.Stream[F, org.plasmalabs.indexer.services.TxoResponse]
  def createOnChainTransactionIndex(request: org.plasmalabs.indexer.services.CreateOnChainTransactionIndexRequest, ctx: A): F[(org.plasmalabs.indexer.services.CreateOnChainTransactionIndexResponse, _root_.io.grpc.Metadata)]
  def getExistingTransactionIndexes(request: org.plasmalabs.indexer.services.GetExistingTransactionIndexesRequest, ctx: A): F[(org.plasmalabs.indexer.services.GetExistingTransactionIndexesResponse, _root_.io.grpc.Metadata)]
  def getIndexedTransactions(request: org.plasmalabs.indexer.services.GetIndexedTransactionsRequest, ctx: A): _root_.fs2.Stream[F, org.plasmalabs.indexer.services.TransactionResponse]
  def dropIndex(request: org.plasmalabs.indexer.services.DropIndexRequest, ctx: A): F[(org.plasmalabs.indexer.services.DropIndexResponse, _root_.io.grpc.Metadata)]
}

object TransactionServiceFs2GrpcTrailers extends _root_.fs2.grpc.GeneratedCompanion[TransactionServiceFs2GrpcTrailers] {
  
  def serviceDescriptor: _root_.io.grpc.ServiceDescriptor = org.plasmalabs.indexer.services.TransactionServiceGrpc.SERVICE
  
  def mkClient[F[_]: _root_.cats.effect.Async, A](dispatcher: _root_.cats.effect.std.Dispatcher[F], channel: _root_.io.grpc.Channel, mkMetadata: A => F[_root_.io.grpc.Metadata], clientOptions: _root_.fs2.grpc.client.ClientOptions): TransactionServiceFs2GrpcTrailers[F, A] = new TransactionServiceFs2GrpcTrailers[F, A] {
    def getTransactionById(request: org.plasmalabs.indexer.services.GetTransactionByIdRequest, ctx: A): F[(org.plasmalabs.indexer.services.TransactionResponse, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_GET_TRANSACTION_BY_ID, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
    def getTransactionByLockAddressStream(request: org.plasmalabs.indexer.services.QueryByLockAddressRequest, ctx: A): _root_.fs2.Stream[F, org.plasmalabs.indexer.services.TransactionResponse] = {
      _root_.fs2.Stream.eval(mkMetadata(ctx)).flatMap { m =>
        _root_.fs2.Stream.eval(_root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_GET_TRANSACTION_BY_LOCK_ADDRESS_STREAM, dispatcher, clientOptions)).flatMap(_.unaryToStreamingCall(request, m))
      }
    }
    def getTxosByLockAddress(request: org.plasmalabs.indexer.services.QueryByLockAddressRequest, ctx: A): F[(org.plasmalabs.indexer.services.TxoLockAddressResponse, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_GET_TXOS_BY_LOCK_ADDRESS, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
    def getTxosByLockAddressStream(request: org.plasmalabs.indexer.services.QueryByLockAddressRequest, ctx: A): _root_.fs2.Stream[F, org.plasmalabs.indexer.services.TxoLockAddressResponse] = {
      _root_.fs2.Stream.eval(mkMetadata(ctx)).flatMap { m =>
        _root_.fs2.Stream.eval(_root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_GET_TXOS_BY_LOCK_ADDRESS_STREAM, dispatcher, clientOptions)).flatMap(_.unaryToStreamingCall(request, m))
      }
    }
    def getTxosByAssetLabel(request: org.plasmalabs.indexer.services.QueryByAssetLabelRequest, ctx: A): _root_.fs2.Stream[F, org.plasmalabs.indexer.services.TxoResponse] = {
      _root_.fs2.Stream.eval(mkMetadata(ctx)).flatMap { m =>
        _root_.fs2.Stream.eval(_root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_GET_TXOS_BY_ASSET_LABEL, dispatcher, clientOptions)).flatMap(_.unaryToStreamingCall(request, m))
      }
    }
    def createOnChainTransactionIndex(request: org.plasmalabs.indexer.services.CreateOnChainTransactionIndexRequest, ctx: A): F[(org.plasmalabs.indexer.services.CreateOnChainTransactionIndexResponse, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_CREATE_ON_CHAIN_TRANSACTION_INDEX, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
    def getExistingTransactionIndexes(request: org.plasmalabs.indexer.services.GetExistingTransactionIndexesRequest, ctx: A): F[(org.plasmalabs.indexer.services.GetExistingTransactionIndexesResponse, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_GET_EXISTING_TRANSACTION_INDEXES, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
    def getIndexedTransactions(request: org.plasmalabs.indexer.services.GetIndexedTransactionsRequest, ctx: A): _root_.fs2.Stream[F, org.plasmalabs.indexer.services.TransactionResponse] = {
      _root_.fs2.Stream.eval(mkMetadata(ctx)).flatMap { m =>
        _root_.fs2.Stream.eval(_root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_GET_INDEXED_TRANSACTIONS, dispatcher, clientOptions)).flatMap(_.unaryToStreamingCall(request, m))
      }
    }
    def dropIndex(request: org.plasmalabs.indexer.services.DropIndexRequest, ctx: A): F[(org.plasmalabs.indexer.services.DropIndexResponse, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_DROP_INDEX, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
  }
  
  protected def serviceBinding[F[_]: _root_.cats.effect.Async, A](dispatcher: _root_.cats.effect.std.Dispatcher[F], serviceImpl: TransactionServiceFs2GrpcTrailers[F, A], mkCtx: _root_.io.grpc.Metadata => F[A], serverOptions: _root_.fs2.grpc.server.ServerOptions): _root_.io.grpc.ServerServiceDefinition = {
    _root_.io.grpc.ServerServiceDefinition
      .builder(org.plasmalabs.indexer.services.TransactionServiceGrpc.SERVICE)
      .addMethod(org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_GET_TRANSACTION_BY_ID, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.indexer.services.GetTransactionByIdRequest, org.plasmalabs.indexer.services.TransactionResponse]((r, m) => mkCtx(m).flatMap(serviceImpl.getTransactionById(r, _))))
      .addMethod(org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_GET_TRANSACTION_BY_LOCK_ADDRESS_STREAM, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToStreamingCall[org.plasmalabs.indexer.services.QueryByLockAddressRequest, org.plasmalabs.indexer.services.TransactionResponse]((r, m) => _root_.fs2.Stream.eval(mkCtx(m)).flatMap(serviceImpl.getTransactionByLockAddressStream(r, _))))
      .addMethod(org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_GET_TXOS_BY_LOCK_ADDRESS, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.indexer.services.QueryByLockAddressRequest, org.plasmalabs.indexer.services.TxoLockAddressResponse]((r, m) => mkCtx(m).flatMap(serviceImpl.getTxosByLockAddress(r, _))))
      .addMethod(org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_GET_TXOS_BY_LOCK_ADDRESS_STREAM, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToStreamingCall[org.plasmalabs.indexer.services.QueryByLockAddressRequest, org.plasmalabs.indexer.services.TxoLockAddressResponse]((r, m) => _root_.fs2.Stream.eval(mkCtx(m)).flatMap(serviceImpl.getTxosByLockAddressStream(r, _))))
      .addMethod(org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_GET_TXOS_BY_ASSET_LABEL, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToStreamingCall[org.plasmalabs.indexer.services.QueryByAssetLabelRequest, org.plasmalabs.indexer.services.TxoResponse]((r, m) => _root_.fs2.Stream.eval(mkCtx(m)).flatMap(serviceImpl.getTxosByAssetLabel(r, _))))
      .addMethod(org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_CREATE_ON_CHAIN_TRANSACTION_INDEX, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.indexer.services.CreateOnChainTransactionIndexRequest, org.plasmalabs.indexer.services.CreateOnChainTransactionIndexResponse]((r, m) => mkCtx(m).flatMap(serviceImpl.createOnChainTransactionIndex(r, _))))
      .addMethod(org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_GET_EXISTING_TRANSACTION_INDEXES, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.indexer.services.GetExistingTransactionIndexesRequest, org.plasmalabs.indexer.services.GetExistingTransactionIndexesResponse]((r, m) => mkCtx(m).flatMap(serviceImpl.getExistingTransactionIndexes(r, _))))
      .addMethod(org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_GET_INDEXED_TRANSACTIONS, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToStreamingCall[org.plasmalabs.indexer.services.GetIndexedTransactionsRequest, org.plasmalabs.indexer.services.TransactionResponse]((r, m) => _root_.fs2.Stream.eval(mkCtx(m)).flatMap(serviceImpl.getIndexedTransactions(r, _))))
      .addMethod(org.plasmalabs.indexer.services.TransactionServiceGrpc.METHOD_DROP_INDEX, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.indexer.services.DropIndexRequest, org.plasmalabs.indexer.services.DropIndexResponse]((r, m) => mkCtx(m).flatMap(serviceImpl.dropIndex(r, _))))
      .build()
  }

}