package org.plasmalabs.indexer.services

import _root_.cats.syntax.all._

trait NetworkMetricsServiceFs2GrpcTrailers[F[_], A] {
  def getTxoStats(request: org.plasmalabs.indexer.services.GetTxoStatsReq, ctx: A): F[(org.plasmalabs.indexer.services.GetTxoStatsRes, _root_.io.grpc.Metadata)]
  def getBlockchainSizeStats(request: org.plasmalabs.indexer.services.BlockchainSizeStatsReq, ctx: A): F[(org.plasmalabs.indexer.services.BlockchainSizeStatsRes, _root_.io.grpc.Metadata)]
  def getBlockStats(request: org.plasmalabs.indexer.services.BlockStatsReq, ctx: A): F[(org.plasmalabs.indexer.services.BlockStatsRes, _root_.io.grpc.Metadata)]
}

object NetworkMetricsServiceFs2GrpcTrailers extends _root_.fs2.grpc.GeneratedCompanion[NetworkMetricsServiceFs2GrpcTrailers] {
  
  def serviceDescriptor: _root_.io.grpc.ServiceDescriptor = org.plasmalabs.indexer.services.NetworkMetricsServiceGrpc.SERVICE
  
  def mkClient[F[_]: _root_.cats.effect.Async, A](dispatcher: _root_.cats.effect.std.Dispatcher[F], channel: _root_.io.grpc.Channel, mkMetadata: A => F[_root_.io.grpc.Metadata], clientOptions: _root_.fs2.grpc.client.ClientOptions): NetworkMetricsServiceFs2GrpcTrailers[F, A] = new NetworkMetricsServiceFs2GrpcTrailers[F, A] {
    def getTxoStats(request: org.plasmalabs.indexer.services.GetTxoStatsReq, ctx: A): F[(org.plasmalabs.indexer.services.GetTxoStatsRes, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.indexer.services.NetworkMetricsServiceGrpc.METHOD_GET_TXO_STATS, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
    def getBlockchainSizeStats(request: org.plasmalabs.indexer.services.BlockchainSizeStatsReq, ctx: A): F[(org.plasmalabs.indexer.services.BlockchainSizeStatsRes, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.indexer.services.NetworkMetricsServiceGrpc.METHOD_GET_BLOCKCHAIN_SIZE_STATS, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
    def getBlockStats(request: org.plasmalabs.indexer.services.BlockStatsReq, ctx: A): F[(org.plasmalabs.indexer.services.BlockStatsRes, _root_.io.grpc.Metadata)] = {
      mkMetadata(ctx).flatMap { m =>
        _root_.fs2.grpc.client.Fs2ClientCall[F](channel, org.plasmalabs.indexer.services.NetworkMetricsServiceGrpc.METHOD_GET_BLOCK_STATS, dispatcher, clientOptions).flatMap(_.unaryToUnaryCallTrailers(request, m))
      }
    }
  }
  
  protected def serviceBinding[F[_]: _root_.cats.effect.Async, A](dispatcher: _root_.cats.effect.std.Dispatcher[F], serviceImpl: NetworkMetricsServiceFs2GrpcTrailers[F, A], mkCtx: _root_.io.grpc.Metadata => F[A], serverOptions: _root_.fs2.grpc.server.ServerOptions): _root_.io.grpc.ServerServiceDefinition = {
    _root_.io.grpc.ServerServiceDefinition
      .builder(org.plasmalabs.indexer.services.NetworkMetricsServiceGrpc.SERVICE)
      .addMethod(org.plasmalabs.indexer.services.NetworkMetricsServiceGrpc.METHOD_GET_TXO_STATS, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.indexer.services.GetTxoStatsReq, org.plasmalabs.indexer.services.GetTxoStatsRes]((r, m) => mkCtx(m).flatMap(serviceImpl.getTxoStats(r, _))))
      .addMethod(org.plasmalabs.indexer.services.NetworkMetricsServiceGrpc.METHOD_GET_BLOCKCHAIN_SIZE_STATS, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.indexer.services.BlockchainSizeStatsReq, org.plasmalabs.indexer.services.BlockchainSizeStatsRes]((r, m) => mkCtx(m).flatMap(serviceImpl.getBlockchainSizeStats(r, _))))
      .addMethod(org.plasmalabs.indexer.services.NetworkMetricsServiceGrpc.METHOD_GET_BLOCK_STATS, _root_.fs2.grpc.server.Fs2ServerCallHandler[F](dispatcher, serverOptions).unaryToUnaryCallTrailers[org.plasmalabs.indexer.services.BlockStatsReq, org.plasmalabs.indexer.services.BlockStatsRes]((r, m) => mkCtx(m).flatMap(serviceImpl.getBlockStats(r, _))))
      .build()
  }

}