package org.plasmalabs.indexer.services

object AssetLabelValidator extends scalapb.validate.Validator[org.plasmalabs.indexer.services.AssetLabel] {
  def validate(input: org.plasmalabs.indexer.services.AssetLabel): scalapb.validate.Result =
    scalapb.validate.Result.optional(input.label.empty) { _value =>
      org.plasmalabs.indexer.services.AssetLabelValidator.EmptyValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.label.v1Label) { _value =>
      org.plasmalabs.indexer.services.AssetLabelValidator.V1LabelValidator.validate(_value)
    } &&
    scalapb.validate.Result.optional(input.label.tam2Label) { _value =>
      org.plasmalabs.indexer.services.AssetLabelValidator.Tam2LabelValidator.validate(_value)
    }
  
  object EmptyValidator extends scalapb.validate.Validator[org.plasmalabs.indexer.services.AssetLabel.Empty] {
    def validate(input: org.plasmalabs.indexer.services.AssetLabel.Empty): scalapb.validate.Result =
      scalapb.validate.Success
    
  }
  object V1LabelValidator extends scalapb.validate.Validator[org.plasmalabs.indexer.services.AssetLabel.V1Label] {
    def validate(input: org.plasmalabs.indexer.services.AssetLabel.V1Label): scalapb.validate.Result =
      org.plasmalabs.sdk.models.LockAddressValidator.validate(input.mintingAddress)
    
  }
  object Tam2LabelValidator extends scalapb.validate.Validator[org.plasmalabs.indexer.services.AssetLabel.Tam2Label] {
    def validate(input: org.plasmalabs.indexer.services.AssetLabel.Tam2Label): scalapb.validate.Result =
      scalapb.validate.Success
    
  }
}