package org.plasmalabs.consensus.models

object SignatureKesSumValidator extends scalapb.validate.Validator[org.plasmalabs.consensus.models.SignatureKesSum] {
  def validate(input: org.plasmalabs.consensus.models.SignatureKesSum): scalapb.validate.Result =
    scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("SignatureKesSum.verificationKey", input.verificationKey, 32)) &&
    scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("SignatureKesSum.signature", input.signature, 64)) &&
    scalapb.validate.Result.repeated(input.witness.iterator) { _value =>
      scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("SignatureKesSum.witness", _value, 32))
    }
  
}