package org.plasmalabs.consensus.models

object OperationalCertificateValidator extends scalapb.validate.Validator[org.plasmalabs.consensus.models.OperationalCertificate] {
  def validate(input: org.plasmalabs.consensus.models.OperationalCertificate): scalapb.validate.Result =
    org.plasmalabs.consensus.models.VerificationKeyKesProductValidator.validate(input.parentVK) &&
    org.plasmalabs.consensus.models.SignatureKesProductValidator.validate(input.parentSignature) &&
    scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("OperationalCertificate.childVK", input.childVK, 32)) &&
    scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("OperationalCertificate.childSignature", input.childSignature, 64))
  
}