package org.plasmalabs.consensus.models

object BlockHeaderValidator extends scalapb.validate.Validator[org.plasmalabs.consensus.models.BlockHeader] {
  def validate(input: org.plasmalabs.consensus.models.BlockHeader): scalapb.validate.Result =
    scalapb.validate.Result.optional(input.headerId) { _value =>
      org.plasmalabs.consensus.models.BlockIdValidator.validate(_value)
    } &&
    org.plasmalabs.consensus.models.BlockIdValidator.validate(input.parentHeaderId) &&
    scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("BlockHeader.txRoot", input.txRoot, 32)) &&
    scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.length("BlockHeader.bloomFilter", input.bloomFilter, 256)) &&
    org.plasmalabs.consensus.models.EligibilityCertificateValidator.validate(input.eligibilityCertificate) &&
    org.plasmalabs.consensus.models.OperationalCertificateValidator.validate(input.operationalCertificate) &&
    scalapb.validate.Result.run(io.envoyproxy.pgv.BytesValidation.maxLength("BlockHeader.metadata", input.metadata, 32)) &&
    org.plasmalabs.consensus.models.StakingAddressValidator.validate(input.address) &&
    org.plasmalabs.consensus.models.ProtocolVersionValidator.validate(input.version)
  
}