// Generated by the Scala Plugin for the Protocol Buffer Compiler.
// Do not edit!
//
// Protofile syntax: PROTO3

package org.plasmalabs.consensus.models

/** Captures a block producer's consensus-commitment to a new block
  *
  * @param headerId
  *   The ID of _this_ block header.  This value is optional and its contents are not included in the signable or identifiable data.  Clients which _can_ verify
  *   this value should verify this value, but some clients may not be able to or need to, in which case this field acts as a convenience.
  * @param parentHeaderId
  *   The parent block's ID.  Each header builds from a single parent.
  * @param parentSlot
  *   The slot of the parent block
  * @param txRoot
  *   The commitment/accumulator of the block body
  *   length = 32
  * @param bloomFilter
  *   A fuzzy search for addresses associated with this block
  *   length = 256
  * @param timestamp
  *   The UTC UNIX timestamp (ms) when the block was created
  * @param height
  *   The 1-based index of this block in the blockchain
  * @param slot
  *   The time-slot in which the block producer created the block
  * @param eligibilityCertificate
  *   A certificate indicating that the block producer was eligible to make this block
  * @param operationalCertificate
  *   A certificate indicating the operator's commitment to this block
  * @param metadata
  *   Optional metadata stamped by the operator.  Must be latin-1 encoded, and must be at most 32 bytes in length.
  *   optional
  * @param address
  *   The operator's staking address
  * @param version
  *   Protocol Version
  */
@SerialVersionUID(0L)
final case class BlockHeader(
    headerId: _root_.scala.Option[org.plasmalabs.consensus.models.BlockId] = _root_.scala.None,
    parentHeaderId: org.plasmalabs.consensus.models.BlockId,
    parentSlot: _root_.scala.Long = 0L,
    txRoot: _root_.com.google.protobuf.ByteString = _root_.com.google.protobuf.ByteString.EMPTY,
    bloomFilter: _root_.com.google.protobuf.ByteString = _root_.com.google.protobuf.ByteString.EMPTY,
    timestamp: _root_.scala.Long = 0L,
    height: _root_.scala.Long = 0L,
    slot: _root_.scala.Long = 0L,
    eligibilityCertificate: org.plasmalabs.consensus.models.EligibilityCertificate,
    operationalCertificate: org.plasmalabs.consensus.models.OperationalCertificate,
    metadata: _root_.com.google.protobuf.ByteString = _root_.com.google.protobuf.ByteString.EMPTY,
    address: org.plasmalabs.consensus.models.StakingAddress,
    version: org.plasmalabs.consensus.models.ProtocolVersion,
    unknownFields: _root_.scalapb.UnknownFieldSet = _root_.scalapb.UnknownFieldSet.empty
    ) extends scalapb.GeneratedMessage with scalapb.lenses.Updatable[BlockHeader] {
    @transient
    private[this] var __serializedSizeMemoized: _root_.scala.Int = 0
    private[this] def __computeSerializedSize(): _root_.scala.Int = {
      var __size = 0
      if (headerId.isDefined) {
        val __value = headerId.get
        __size += 1 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
      };
      
      {
        val __value = parentHeaderId
        __size += 1 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
      };
      
      {
        val __value = parentSlot
        if (__value != 0L) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeUInt64Size(2, __value)
        }
      };
      
      {
        val __value = txRoot
        if (!__value.isEmpty) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeBytesSize(3, __value)
        }
      };
      
      {
        val __value = bloomFilter
        if (!__value.isEmpty) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeBytesSize(4, __value)
        }
      };
      
      {
        val __value = timestamp
        if (__value != 0L) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeUInt64Size(5, __value)
        }
      };
      
      {
        val __value = height
        if (__value != 0L) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeUInt64Size(6, __value)
        }
      };
      
      {
        val __value = slot
        if (__value != 0L) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeUInt64Size(7, __value)
        }
      };
      
      {
        val __value = eligibilityCertificate
        __size += 1 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
      };
      
      {
        val __value = operationalCertificate
        __size += 1 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
      };
      
      {
        val __value = metadata
        if (!__value.isEmpty) {
          __size += _root_.com.google.protobuf.CodedOutputStream.computeBytesSize(10, __value)
        }
      };
      
      {
        val __value = address
        __size += 1 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
      };
      
      {
        val __value = version
        __size += 1 + _root_.com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(__value.serializedSize) + __value.serializedSize
      };
      __size += unknownFields.serializedSize
      __size
    }
    override def serializedSize: _root_.scala.Int = {
      var __size = __serializedSizeMemoized
      if (__size == 0) {
        __size = __computeSerializedSize() + 1
        __serializedSizeMemoized = __size
      }
      __size - 1
      
    }
    def writeTo(`_output__`: _root_.com.google.protobuf.CodedOutputStream): _root_.scala.Unit = {
      
      {
        val __v = parentHeaderId
        _output__.writeTag(1, 2)
        _output__.writeUInt32NoTag(__v.serializedSize)
        __v.writeTo(_output__)
      };
      {
        val __v = parentSlot
        if (__v != 0L) {
          _output__.writeUInt64(2, __v)
        }
      };
      {
        val __v = txRoot
        if (!__v.isEmpty) {
          _output__.writeBytes(3, __v)
        }
      };
      {
        val __v = bloomFilter
        if (!__v.isEmpty) {
          _output__.writeBytes(4, __v)
        }
      };
      {
        val __v = timestamp
        if (__v != 0L) {
          _output__.writeUInt64(5, __v)
        }
      };
      {
        val __v = height
        if (__v != 0L) {
          _output__.writeUInt64(6, __v)
        }
      };
      {
        val __v = slot
        if (__v != 0L) {
          _output__.writeUInt64(7, __v)
        }
      };
      
      {
        val __v = eligibilityCertificate
        _output__.writeTag(8, 2)
        _output__.writeUInt32NoTag(__v.serializedSize)
        __v.writeTo(_output__)
      };
      
      {
        val __v = operationalCertificate
        _output__.writeTag(9, 2)
        _output__.writeUInt32NoTag(__v.serializedSize)
        __v.writeTo(_output__)
      };
      {
        val __v = metadata
        if (!__v.isEmpty) {
          _output__.writeBytes(10, __v)
        }
      };
      
      {
        val __v = address
        _output__.writeTag(11, 2)
        _output__.writeUInt32NoTag(__v.serializedSize)
        __v.writeTo(_output__)
      };
      headerId.foreach { __v =>
        val __m = __v
        _output__.writeTag(12, 2)
        _output__.writeUInt32NoTag(__m.serializedSize)
        __m.writeTo(_output__)
      };
      
      {
        val __v = version
        _output__.writeTag(13, 2)
        _output__.writeUInt32NoTag(__v.serializedSize)
        __v.writeTo(_output__)
      };
      unknownFields.writeTo(_output__)
    }
    def getHeaderId: org.plasmalabs.consensus.models.BlockId = headerId.getOrElse(org.plasmalabs.consensus.models.BlockId.defaultInstance)
    def clearHeaderId: BlockHeader = copy(headerId = _root_.scala.None)
    def withHeaderId(__v: org.plasmalabs.consensus.models.BlockId): BlockHeader = copy(headerId = Option(__v))
    def withParentHeaderId(__v: org.plasmalabs.consensus.models.BlockId): BlockHeader = copy(parentHeaderId = __v)
    def withParentSlot(__v: _root_.scala.Long): BlockHeader = copy(parentSlot = __v)
    def withTxRoot(__v: _root_.com.google.protobuf.ByteString): BlockHeader = copy(txRoot = __v)
    def withBloomFilter(__v: _root_.com.google.protobuf.ByteString): BlockHeader = copy(bloomFilter = __v)
    def withTimestamp(__v: _root_.scala.Long): BlockHeader = copy(timestamp = __v)
    def withHeight(__v: _root_.scala.Long): BlockHeader = copy(height = __v)
    def withSlot(__v: _root_.scala.Long): BlockHeader = copy(slot = __v)
    def withEligibilityCertificate(__v: org.plasmalabs.consensus.models.EligibilityCertificate): BlockHeader = copy(eligibilityCertificate = __v)
    def withOperationalCertificate(__v: org.plasmalabs.consensus.models.OperationalCertificate): BlockHeader = copy(operationalCertificate = __v)
    def withMetadata(__v: _root_.com.google.protobuf.ByteString): BlockHeader = copy(metadata = __v)
    def withAddress(__v: org.plasmalabs.consensus.models.StakingAddress): BlockHeader = copy(address = __v)
    def withVersion(__v: org.plasmalabs.consensus.models.ProtocolVersion): BlockHeader = copy(version = __v)
    def withUnknownFields(__v: _root_.scalapb.UnknownFieldSet) = copy(unknownFields = __v)
    def discardUnknownFields = copy(unknownFields = _root_.scalapb.UnknownFieldSet.empty)
    def getFieldByNumber(__fieldNumber: _root_.scala.Int): _root_.scala.Any = {
      (__fieldNumber: @_root_.scala.unchecked) match {
        case 12 => headerId.orNull
        case 1 => parentHeaderId
        case 2 => {
          val __t = parentSlot
          if (__t != 0L) __t else null
        }
        case 3 => {
          val __t = txRoot
          if (__t != _root_.com.google.protobuf.ByteString.EMPTY) __t else null
        }
        case 4 => {
          val __t = bloomFilter
          if (__t != _root_.com.google.protobuf.ByteString.EMPTY) __t else null
        }
        case 5 => {
          val __t = timestamp
          if (__t != 0L) __t else null
        }
        case 6 => {
          val __t = height
          if (__t != 0L) __t else null
        }
        case 7 => {
          val __t = slot
          if (__t != 0L) __t else null
        }
        case 8 => eligibilityCertificate
        case 9 => operationalCertificate
        case 10 => {
          val __t = metadata
          if (__t != _root_.com.google.protobuf.ByteString.EMPTY) __t else null
        }
        case 11 => address
        case 13 => version
      }
    }
    def getField(__field: _root_.scalapb.descriptors.FieldDescriptor): _root_.scalapb.descriptors.PValue = {
      _root_.scala.Predef.require(__field.containingMessage eq companion.scalaDescriptor)
      (__field.number: @_root_.scala.unchecked) match {
        case 12 => headerId.map(_.toPMessage).getOrElse(_root_.scalapb.descriptors.PEmpty)
        case 1 => parentHeaderId.toPMessage
        case 2 => _root_.scalapb.descriptors.PLong(parentSlot)
        case 3 => _root_.scalapb.descriptors.PByteString(txRoot)
        case 4 => _root_.scalapb.descriptors.PByteString(bloomFilter)
        case 5 => _root_.scalapb.descriptors.PLong(timestamp)
        case 6 => _root_.scalapb.descriptors.PLong(height)
        case 7 => _root_.scalapb.descriptors.PLong(slot)
        case 8 => eligibilityCertificate.toPMessage
        case 9 => operationalCertificate.toPMessage
        case 10 => _root_.scalapb.descriptors.PByteString(metadata)
        case 11 => address.toPMessage
        case 13 => version.toPMessage
      }
    }
    def toProtoString: _root_.scala.Predef.String = _root_.scalapb.TextFormat.printToUnicodeString(this)
    def companion: org.plasmalabs.consensus.models.BlockHeader.type = org.plasmalabs.consensus.models.BlockHeader
    _root_.scalapb.validate.Validator.assertValid(this)(org.plasmalabs.consensus.models.BlockHeaderValidator)
    // @@protoc_insertion_point(GeneratedMessage[org.plasmalabs.consensus.models.BlockHeader])
}

object BlockHeader extends scalapb.GeneratedMessageCompanion[org.plasmalabs.consensus.models.BlockHeader] {
  implicit def messageCompanion: scalapb.GeneratedMessageCompanion[org.plasmalabs.consensus.models.BlockHeader] = this
  def parseFrom(`_input__`: _root_.com.google.protobuf.CodedInputStream): org.plasmalabs.consensus.models.BlockHeader = {
    var __requiredFields0: _root_.scala.Long = 0x1fL
    var __headerId: _root_.scala.Option[org.plasmalabs.consensus.models.BlockId] = _root_.scala.None
    var __parentHeaderId: _root_.scala.Option[org.plasmalabs.consensus.models.BlockId] = _root_.scala.None
    var __parentSlot: _root_.scala.Long = 0L
    var __txRoot: _root_.com.google.protobuf.ByteString = _root_.com.google.protobuf.ByteString.EMPTY
    var __bloomFilter: _root_.com.google.protobuf.ByteString = _root_.com.google.protobuf.ByteString.EMPTY
    var __timestamp: _root_.scala.Long = 0L
    var __height: _root_.scala.Long = 0L
    var __slot: _root_.scala.Long = 0L
    var __eligibilityCertificate: _root_.scala.Option[org.plasmalabs.consensus.models.EligibilityCertificate] = _root_.scala.None
    var __operationalCertificate: _root_.scala.Option[org.plasmalabs.consensus.models.OperationalCertificate] = _root_.scala.None
    var __metadata: _root_.com.google.protobuf.ByteString = _root_.com.google.protobuf.ByteString.EMPTY
    var __address: _root_.scala.Option[org.plasmalabs.consensus.models.StakingAddress] = _root_.scala.None
    var __version: _root_.scala.Option[org.plasmalabs.consensus.models.ProtocolVersion] = _root_.scala.None
    var `_unknownFields__`: _root_.scalapb.UnknownFieldSet.Builder = null
    var _done__ = false
    while (!_done__) {
      val _tag__ = _input__.readTag()
      _tag__ match {
        case 0 => _done__ = true
        case 98 =>
          __headerId = _root_.scala.Option(__headerId.fold(_root_.scalapb.LiteParser.readMessage[org.plasmalabs.consensus.models.BlockId](_input__))(_root_.scalapb.LiteParser.readMessage(_input__, _)))
        case 10 =>
          __parentHeaderId = _root_.scala.Some(__parentHeaderId.fold(_root_.scalapb.LiteParser.readMessage[org.plasmalabs.consensus.models.BlockId](_input__))(_root_.scalapb.LiteParser.readMessage(_input__, _)))
          __requiredFields0 &= 0xfffffffffffffffeL
        case 16 =>
          __parentSlot = _input__.readUInt64()
        case 26 =>
          __txRoot = _input__.readBytes()
        case 34 =>
          __bloomFilter = _input__.readBytes()
        case 40 =>
          __timestamp = _input__.readUInt64()
        case 48 =>
          __height = _input__.readUInt64()
        case 56 =>
          __slot = _input__.readUInt64()
        case 66 =>
          __eligibilityCertificate = _root_.scala.Some(__eligibilityCertificate.fold(_root_.scalapb.LiteParser.readMessage[org.plasmalabs.consensus.models.EligibilityCertificate](_input__))(_root_.scalapb.LiteParser.readMessage(_input__, _)))
          __requiredFields0 &= 0xfffffffffffffffdL
        case 74 =>
          __operationalCertificate = _root_.scala.Some(__operationalCertificate.fold(_root_.scalapb.LiteParser.readMessage[org.plasmalabs.consensus.models.OperationalCertificate](_input__))(_root_.scalapb.LiteParser.readMessage(_input__, _)))
          __requiredFields0 &= 0xfffffffffffffffbL
        case 82 =>
          __metadata = _input__.readBytes()
        case 90 =>
          __address = _root_.scala.Some(__address.fold(_root_.scalapb.LiteParser.readMessage[org.plasmalabs.consensus.models.StakingAddress](_input__))(_root_.scalapb.LiteParser.readMessage(_input__, _)))
          __requiredFields0 &= 0xfffffffffffffff7L
        case 106 =>
          __version = _root_.scala.Some(__version.fold(_root_.scalapb.LiteParser.readMessage[org.plasmalabs.consensus.models.ProtocolVersion](_input__))(_root_.scalapb.LiteParser.readMessage(_input__, _)))
          __requiredFields0 &= 0xffffffffffffffefL
        case tag =>
          if (_unknownFields__ == null) {
            _unknownFields__ = new _root_.scalapb.UnknownFieldSet.Builder()
          }
          _unknownFields__.parseField(tag, _input__)
      }
    }
    if (__requiredFields0 != 0L) { throw new _root_.com.google.protobuf.InvalidProtocolBufferException("Message missing required fields.") } 
    org.plasmalabs.consensus.models.BlockHeader(
        headerId = __headerId,
        parentHeaderId = __parentHeaderId.getOrElse(org.plasmalabs.consensus.models.BlockId.defaultInstance),
        parentSlot = __parentSlot,
        txRoot = __txRoot,
        bloomFilter = __bloomFilter,
        timestamp = __timestamp,
        height = __height,
        slot = __slot,
        eligibilityCertificate = __eligibilityCertificate.getOrElse(org.plasmalabs.consensus.models.EligibilityCertificate.defaultInstance),
        operationalCertificate = __operationalCertificate.getOrElse(org.plasmalabs.consensus.models.OperationalCertificate.defaultInstance),
        metadata = __metadata,
        address = __address.getOrElse(org.plasmalabs.consensus.models.StakingAddress.defaultInstance),
        version = __version.getOrElse(org.plasmalabs.consensus.models.ProtocolVersion.defaultInstance),
        unknownFields = if (_unknownFields__ == null) _root_.scalapb.UnknownFieldSet.empty else _unknownFields__.result()
    )
  }
  implicit def messageReads: _root_.scalapb.descriptors.Reads[org.plasmalabs.consensus.models.BlockHeader] = _root_.scalapb.descriptors.Reads{
    case _root_.scalapb.descriptors.PMessage(__fieldsMap) =>
      _root_.scala.Predef.require(__fieldsMap.keys.forall(_.containingMessage eq scalaDescriptor), "FieldDescriptor does not match message type.")
      org.plasmalabs.consensus.models.BlockHeader(
        headerId = __fieldsMap.get(scalaDescriptor.findFieldByNumber(12).get).flatMap(_.as[_root_.scala.Option[org.plasmalabs.consensus.models.BlockId]]),
        parentHeaderId = __fieldsMap.get(scalaDescriptor.findFieldByNumber(1).get).get.as[org.plasmalabs.consensus.models.BlockId],
        parentSlot = __fieldsMap.get(scalaDescriptor.findFieldByNumber(2).get).map(_.as[_root_.scala.Long]).getOrElse(0L),
        txRoot = __fieldsMap.get(scalaDescriptor.findFieldByNumber(3).get).map(_.as[_root_.com.google.protobuf.ByteString]).getOrElse(_root_.com.google.protobuf.ByteString.EMPTY),
        bloomFilter = __fieldsMap.get(scalaDescriptor.findFieldByNumber(4).get).map(_.as[_root_.com.google.protobuf.ByteString]).getOrElse(_root_.com.google.protobuf.ByteString.EMPTY),
        timestamp = __fieldsMap.get(scalaDescriptor.findFieldByNumber(5).get).map(_.as[_root_.scala.Long]).getOrElse(0L),
        height = __fieldsMap.get(scalaDescriptor.findFieldByNumber(6).get).map(_.as[_root_.scala.Long]).getOrElse(0L),
        slot = __fieldsMap.get(scalaDescriptor.findFieldByNumber(7).get).map(_.as[_root_.scala.Long]).getOrElse(0L),
        eligibilityCertificate = __fieldsMap.get(scalaDescriptor.findFieldByNumber(8).get).get.as[org.plasmalabs.consensus.models.EligibilityCertificate],
        operationalCertificate = __fieldsMap.get(scalaDescriptor.findFieldByNumber(9).get).get.as[org.plasmalabs.consensus.models.OperationalCertificate],
        metadata = __fieldsMap.get(scalaDescriptor.findFieldByNumber(10).get).map(_.as[_root_.com.google.protobuf.ByteString]).getOrElse(_root_.com.google.protobuf.ByteString.EMPTY),
        address = __fieldsMap.get(scalaDescriptor.findFieldByNumber(11).get).get.as[org.plasmalabs.consensus.models.StakingAddress],
        version = __fieldsMap.get(scalaDescriptor.findFieldByNumber(13).get).get.as[org.plasmalabs.consensus.models.ProtocolVersion]
      )
    case _ => throw new RuntimeException("Expected PMessage")
  }
  def javaDescriptor: _root_.com.google.protobuf.Descriptors.Descriptor = BlockHeaderProto.javaDescriptor.getMessageTypes().get(0)
  def scalaDescriptor: _root_.scalapb.descriptors.Descriptor = BlockHeaderProto.scalaDescriptor.messages(0)
  def messageCompanionForFieldNumber(__number: _root_.scala.Int): _root_.scalapb.GeneratedMessageCompanion[_] = {
    var __out: _root_.scalapb.GeneratedMessageCompanion[_] = null
    (__number: @_root_.scala.unchecked) match {
      case 12 => __out = org.plasmalabs.consensus.models.BlockId
      case 1 => __out = org.plasmalabs.consensus.models.BlockId
      case 8 => __out = org.plasmalabs.consensus.models.EligibilityCertificate
      case 9 => __out = org.plasmalabs.consensus.models.OperationalCertificate
      case 11 => __out = org.plasmalabs.consensus.models.StakingAddress
      case 13 => __out = org.plasmalabs.consensus.models.ProtocolVersion
    }
    __out
  }
  lazy val nestedMessagesCompanions: Seq[_root_.scalapb.GeneratedMessageCompanion[_ <: _root_.scalapb.GeneratedMessage]] = Seq.empty
  def enumCompanionForFieldNumber(__fieldNumber: _root_.scala.Int): _root_.scalapb.GeneratedEnumCompanion[_] = throw new MatchError(__fieldNumber)
  lazy val defaultInstance = org.plasmalabs.consensus.models.BlockHeader(
    headerId = _root_.scala.None,
    parentHeaderId = org.plasmalabs.consensus.models.BlockId.defaultInstance,
    parentSlot = 0L,
    txRoot = _root_.com.google.protobuf.ByteString.EMPTY,
    bloomFilter = _root_.com.google.protobuf.ByteString.EMPTY,
    timestamp = 0L,
    height = 0L,
    slot = 0L,
    eligibilityCertificate = org.plasmalabs.consensus.models.EligibilityCertificate.defaultInstance,
    operationalCertificate = org.plasmalabs.consensus.models.OperationalCertificate.defaultInstance,
    metadata = _root_.com.google.protobuf.ByteString.EMPTY,
    address = org.plasmalabs.consensus.models.StakingAddress.defaultInstance,
    version = org.plasmalabs.consensus.models.ProtocolVersion.defaultInstance
  )
  implicit class BlockHeaderLens[UpperPB](_l: _root_.scalapb.lenses.Lens[UpperPB, org.plasmalabs.consensus.models.BlockHeader]) extends _root_.scalapb.lenses.ObjectLens[UpperPB, org.plasmalabs.consensus.models.BlockHeader](_l) {
    def headerId: _root_.scalapb.lenses.Lens[UpperPB, org.plasmalabs.consensus.models.BlockId] = field(_.getHeaderId)((c_, f_) => c_.copy(headerId = _root_.scala.Option(f_)))
    def optionalHeaderId: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Option[org.plasmalabs.consensus.models.BlockId]] = field(_.headerId)((c_, f_) => c_.copy(headerId = f_))
    def parentHeaderId: _root_.scalapb.lenses.Lens[UpperPB, org.plasmalabs.consensus.models.BlockId] = field(_.parentHeaderId)((c_, f_) => c_.copy(parentHeaderId = f_))
    def parentSlot: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Long] = field(_.parentSlot)((c_, f_) => c_.copy(parentSlot = f_))
    def txRoot: _root_.scalapb.lenses.Lens[UpperPB, _root_.com.google.protobuf.ByteString] = field(_.txRoot)((c_, f_) => c_.copy(txRoot = f_))
    def bloomFilter: _root_.scalapb.lenses.Lens[UpperPB, _root_.com.google.protobuf.ByteString] = field(_.bloomFilter)((c_, f_) => c_.copy(bloomFilter = f_))
    def timestamp: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Long] = field(_.timestamp)((c_, f_) => c_.copy(timestamp = f_))
    def height: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Long] = field(_.height)((c_, f_) => c_.copy(height = f_))
    def slot: _root_.scalapb.lenses.Lens[UpperPB, _root_.scala.Long] = field(_.slot)((c_, f_) => c_.copy(slot = f_))
    def eligibilityCertificate: _root_.scalapb.lenses.Lens[UpperPB, org.plasmalabs.consensus.models.EligibilityCertificate] = field(_.eligibilityCertificate)((c_, f_) => c_.copy(eligibilityCertificate = f_))
    def operationalCertificate: _root_.scalapb.lenses.Lens[UpperPB, org.plasmalabs.consensus.models.OperationalCertificate] = field(_.operationalCertificate)((c_, f_) => c_.copy(operationalCertificate = f_))
    def metadata: _root_.scalapb.lenses.Lens[UpperPB, _root_.com.google.protobuf.ByteString] = field(_.metadata)((c_, f_) => c_.copy(metadata = f_))
    def address: _root_.scalapb.lenses.Lens[UpperPB, org.plasmalabs.consensus.models.StakingAddress] = field(_.address)((c_, f_) => c_.copy(address = f_))
    def version: _root_.scalapb.lenses.Lens[UpperPB, org.plasmalabs.consensus.models.ProtocolVersion] = field(_.version)((c_, f_) => c_.copy(version = f_))
  }
  final val HEADERID_FIELD_NUMBER = 12
  final val PARENTHEADERID_FIELD_NUMBER = 1
  final val PARENTSLOT_FIELD_NUMBER = 2
  final val TXROOT_FIELD_NUMBER = 3
  final val BLOOMFILTER_FIELD_NUMBER = 4
  final val TIMESTAMP_FIELD_NUMBER = 5
  final val HEIGHT_FIELD_NUMBER = 6
  final val SLOT_FIELD_NUMBER = 7
  final val ELIGIBILITYCERTIFICATE_FIELD_NUMBER = 8
  final val OPERATIONALCERTIFICATE_FIELD_NUMBER = 9
  final val METADATA_FIELD_NUMBER = 10
  final val ADDRESS_FIELD_NUMBER = 11
  final val VERSION_FIELD_NUMBER = 13
  def of(
    headerId: _root_.scala.Option[org.plasmalabs.consensus.models.BlockId],
    parentHeaderId: org.plasmalabs.consensus.models.BlockId,
    parentSlot: _root_.scala.Long,
    txRoot: _root_.com.google.protobuf.ByteString,
    bloomFilter: _root_.com.google.protobuf.ByteString,
    timestamp: _root_.scala.Long,
    height: _root_.scala.Long,
    slot: _root_.scala.Long,
    eligibilityCertificate: org.plasmalabs.consensus.models.EligibilityCertificate,
    operationalCertificate: org.plasmalabs.consensus.models.OperationalCertificate,
    metadata: _root_.com.google.protobuf.ByteString,
    address: org.plasmalabs.consensus.models.StakingAddress,
    version: org.plasmalabs.consensus.models.ProtocolVersion
  ): _root_.org.plasmalabs.consensus.models.BlockHeader = _root_.org.plasmalabs.consensus.models.BlockHeader(
    headerId,
    parentHeaderId,
    parentSlot,
    txRoot,
    bloomFilter,
    timestamp,
    height,
    slot,
    eligibilityCertificate,
    operationalCertificate,
    metadata,
    address,
    version
  )
  implicit def validator: scalapb.validate.Validator[org.plasmalabs.consensus.models.BlockHeader] = org.plasmalabs.consensus.models.BlockHeaderValidator
  // @@protoc_insertion_point(GeneratedMessageCompanion[org.plasmalabs.consensus.models.BlockHeader])
}
