/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import com.oracle.truffle.api.TruffleOptions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.pkl.core.PklBugException;
import org.pkl.core.Platform;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ProjectDependenciesManager;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.runtime.ReaderBase;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.util.ByteArrayUtils;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.HttpUtils;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.Pair;

public final class IoUtils {
    private static final Pattern uriLike = Pattern.compile("\\w+:[^\\\\].*");
    private static final Pattern windowsPathLike = Pattern.compile("\\w:\\\\.*");

    private IoUtils() {
    }

    public static URL toUrl(URI uri) throws IOException {
        try {
            return uri.toURL();
        }
        catch (Error e2) {
            if (e2.getClass().getName().equals("com.oracle.svm.core.jdk.UnsupportedFeatureError")) {
                throw new IOException("Unsupported protocol: " + uri.getScheme());
            }
            throw e2;
        }
    }

    public static boolean isUriLike(String str) {
        return uriLike.matcher(str).matches();
    }

    public static boolean isWindowsAbsolutePath(String str) {
        if (!IoUtils.isWindows().booleanValue()) {
            return false;
        }
        return windowsPathLike.matcher(str).matches();
    }

    public static URI toUri(String str) throws URISyntaxException {
        if (IoUtils.isUriLike(str)) {
            return new URI(str);
        }
        return new URI(null, null, str, null);
    }

    public static URI createUri(String str) {
        try {
            return IoUtils.toUri(str);
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException(e2.getMessage(), e2);
        }
    }

    public static URI stripFragment(URI uri) {
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null);
        }
        catch (URISyntaxException e2) {
            throw PklBugException.unreachableCode();
        }
    }

    public static String readString(URL url) throws IOException {
        if (HttpUtils.isHttpUrl(url)) {
            throw new IllegalArgumentException("Should use HTTP client to GET " + url);
        }
        try (InputStream stream = url.openStream();){
            String string = IoUtils.readString(stream);
            return string;
        }
    }

    public static String readString(InputStream inputStream) throws IOException {
        return new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
    }

    public static byte[] readBytes(URI uri) throws IOException {
        if (HttpUtils.isHttpUrl(uri)) {
            throw new IllegalArgumentException("Should use HTTP client to GET " + uri);
        }
        try (InputStream stream = IoUtils.toUrl(uri).openStream();){
            byte[] byArray = stream.readAllBytes();
            return byArray;
        }
    }

    public static String readString(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        int bytesRead = 0;
        char[] buffer = new char[8192];
        while ((bytesRead = reader.read(buffer, 0, buffer.length)) != -1) {
            builder.append(buffer, 0, bytesRead);
        }
        return builder.toString();
    }

    public static String readClassPathResourceAsString(Class<?> clazz, String path) throws IOException {
        InputStream inputStream = clazz.getResourceAsStream(path);
        if (inputStream == null) {
            throw new IOException(String.format("Cannot find class path resource `%s`.", path));
        }
        try (InputStream inputStream2 = inputStream;){
            String string = IoUtils.readString(inputStream);
            return string;
        }
    }

    public static void zipDirectory(final Path sourceDir, Path targetFile) throws IOException {
        try (final ZipOutputStream zipStream = new ZipOutputStream(Files.newOutputStream(targetFile, new OpenOption[0]));){
            Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path relativePath = IoUtils.relativize(file, sourceDir);
                    zipStream.putNextEntry(new ZipEntry(IoUtils.toNormalizedPathString(relativePath)));
                    Files.copy(file, zipStream);
                    zipStream.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static Path getCurrentWorkingDir() {
        return Path.of(System.getProperty("user.dir"), new String[0]);
    }

    public static Path getPklHomeDir() {
        return Path.of(System.getProperty("user.home"), ".pkl");
    }

    public static Path getDefaultModuleCacheDir() {
        return IoUtils.getPklHomeDir().resolve("cache");
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static Boolean isWindows() {
        return Platform.current().operatingSystem().name().equals("Windows");
    }

    public static String getName(String path) {
        int lastSep = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        return path.substring(lastSep + 1);
    }

    public static String getName(Path path) {
        return IoUtils.getName(path.toString());
    }

    public static String getNameWithoutExtension(String path) {
        int lastSep = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        int lastDot = path.lastIndexOf(46);
        return lastDot == -1 || lastDot < lastSep ? path.substring(lastSep + 1) : path.substring(lastSep + 1, lastDot);
    }

    public static String takeLastSegment(String name, char separator) {
        int lastSep = name.lastIndexOf(separator);
        return name.substring(lastSep + 1);
    }

    public static String dropLastSegment(String name, char separator) {
        int lastSep = name.lastIndexOf(separator);
        return lastSep == -1 ? name : name.substring(0, lastSep);
    }

    @Nullable
    public static Path toPath(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("Expected absolute URI, but got: " + uri);
        }
        try {
            return Path.of(uri);
        }
        catch (IllegalArgumentException | FileSystemNotFoundException e2) {
            return null;
        }
    }

    private static String doInferModuleName(URI moduleUri) {
        String path = moduleUri.getPath();
        if (path == null) {
            return IoUtils.takeLastSegment(IoUtils.dropLastSegment(moduleUri.getSchemeSpecificPart(), ':'), '.');
        }
        return IoUtils.getNameWithoutExtension(path);
    }

    public static String inferModuleName(ModuleKey moduleKey) {
        URI moduleUri = moduleKey.getUri();
        if ("jar".equalsIgnoreCase(moduleUri.getScheme())) {
            String uriString = moduleUri.toString();
            int index = IoUtils.getExclamationMarkIndex(uriString);
            String path = uriString.substring(index + 1);
            return IoUtils.getNameWithoutExtension(path);
        }
        if (moduleKey.hasFragmentPaths()) {
            String fragment = moduleUri.getFragment();
            return IoUtils.getNameWithoutExtension(fragment);
        }
        return IoUtils.doInferModuleName(moduleUri);
    }

    public static URI ensurePathEndsWithSlash(URI uri) {
        try {
            if (uri.isOpaque()) {
                return uri;
            }
            if (uri.getPath().endsWith("/")) {
                return uri;
            }
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath() + "/", uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    public static URI resolve(ReaderBase reader, URI baseUri, String importUri) {
        return IoUtils.resolve(reader, baseUri, IoUtils.createUri(importUri));
    }

    public static URI resolve(ReaderBase reader, URI baseUri, URI importUri) {
        if (reader.hasFragmentPaths() && !importUri.isAbsolute() && importUri.getPath() != null) {
            String fragment = baseUri.getFragment();
            URI newFragment = IoUtils.resolve(IoUtils.createUri(fragment), importUri);
            return IoUtils.stripFragment(baseUri).resolve("#" + newFragment);
        }
        return IoUtils.resolve(baseUri, importUri);
    }

    private static URI resolveTripleDotImport(SecurityManager securityManager, ModuleKey moduleKey, String tripleDotPath) throws IOException, SecurityManagerException {
        URI candidateUri;
        String candidatePath;
        URI moduleKeyUri = moduleKey.getUri();
        if (!moduleKey.isLocal() || !moduleKey.hasHierarchicalUris()) {
            throw new VmExceptionBuilder().evalError("cannotResolveTripleDotImports", moduleKeyUri).build();
        }
        String currentPath = moduleKey.hasFragmentPaths() ? moduleKeyUri.getFragment() : moduleKeyUri.getPath();
        String effectiveImportPath = tripleDotPath.isEmpty() ? currentPath.substring(currentPath.lastIndexOf(47) + 1) : tripleDotPath;
        int index = currentPath.lastIndexOf(47);
        index = currentPath.lastIndexOf(47, index - 1);
        String basePath = currentPath;
        while (index > 0) {
            basePath = basePath.substring(0, index + 1);
            candidatePath = basePath + effectiveImportPath;
            candidateUri = IoUtils.resolve((ReaderBase)moduleKey, moduleKeyUri, candidatePath);
            if (!candidatePath.equals(currentPath) && moduleKey.hasElement(securityManager, candidateUri)) {
                return IoUtils.fixTripleSlashUri(moduleKeyUri, candidateUri);
            }
            index = basePath.lastIndexOf(47, index - 1);
        }
        candidatePath = "/" + effectiveImportPath;
        candidateUri = IoUtils.resolve((ReaderBase)moduleKey, moduleKeyUri, candidatePath);
        if (!candidatePath.equals(currentPath) && moduleKey.hasElement(securityManager, candidateUri)) {
            return IoUtils.fixTripleSlashUri(moduleKeyUri, candidateUri);
        }
        throw new FileNotFoundException();
    }

    public static Pair<String, String> parseDependencyNotation(String importPath) {
        int idx = importPath.indexOf(47);
        if (idx == -1) {
            return Pair.of(importPath.substring(1), "/");
        }
        return Pair.of(importPath.substring(1, idx), importPath.substring(idx));
    }

    private static URI resolveProjectDependency(ModuleKey moduleKey, String notation) {
        Pair<String, String> parsed = IoUtils.parseDependencyNotation(notation);
        String name = parsed.getFirst();
        String path = parsed.getSecond();
        ProjectDependenciesManager projectDependenciesManager = VmContext.get(null).getProjectDependenciesManager();
        if (!moduleKey.hasHierarchicalUris() && projectDependenciesManager != null) {
            throw new PackageLoadError("cannotResolveDependencyWithoutHierarchicalUris", projectDependenciesManager.getProjectFileUri());
        }
        if (projectDependenciesManager == null || !projectDependenciesManager.hasUri(moduleKey.getUri())) {
            throw new PackageLoadError("cannotResolveDependencyNoProject", new Object[0]);
        }
        Dependency dependency = projectDependenciesManager.getDependencies().get(name);
        if (dependency != null) {
            return dependency.getPackageUri().toPackageAssetUri(path).getUri();
        }
        throw new PackageLoadError("cannotFindDependencyInProject", name);
    }

    public static URI resolve(SecurityManager securityManager, ModuleKey moduleKey, URI importUri) throws URISyntaxException, IOException, SecurityManagerException {
        if (importUri.isAbsolute()) {
            return moduleKey.resolveUri(importUri);
        }
        String tripleDotPath = IoUtils.parseTripleDotPath(importUri);
        if (tripleDotPath != null) {
            return IoUtils.resolveTripleDotImport(securityManager, moduleKey, tripleDotPath);
        }
        String moduleScheme = moduleKey.getUri().getScheme();
        boolean isPackage = moduleScheme.equalsIgnoreCase("package") || moduleScheme.equalsIgnoreCase("projectpackage");
        String relativePart = importUri.getSchemeSpecificPart();
        if (relativePart.startsWith("@") && !isPackage) {
            return IoUtils.resolveProjectDependency(moduleKey, relativePart);
        }
        return moduleKey.resolveUri(importUri);
    }

    public static URI resolve(URI baseUri, URI newUri) {
        if (newUri.isAbsolute()) {
            return newUri;
        }
        String scheme = baseUri.getScheme();
        if ("jar".equalsIgnoreCase(scheme)) {
            String baseUriString = baseUri.toString();
            int index = IoUtils.getExclamationMarkIndex(baseUriString);
            String jarUri = baseUriString.substring(0, index + 1);
            String jarPath = baseUriString.substring(index + 1);
            URI resolvedPath = IoUtils.resolve(URI.create(jarPath), newUri);
            return URI.create(jarUri + resolvedPath);
        }
        return IoUtils.fixTripleSlashUri(baseUri, baseUri.resolve(newUri));
    }

    public static URI resolve(URI uri, String str) {
        try {
            return IoUtils.resolve(uri, IoUtils.toUri(str));
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException(e2.getMessage(), e2);
        }
    }

    public static URI relativize(URI uri, URI base) {
        if (uri.isOpaque() || base.isOpaque() || !Objects.equals(uri.getScheme(), base.getScheme()) || !Objects.equals(uri.getAuthority(), base.getAuthority())) {
            return uri;
        }
        String uriPath = uri.normalize().getPath();
        String basePath = base.normalize().getPath();
        try {
            int start2;
            if (basePath.isEmpty()) {
                return uri;
            }
            List<String> uriParts = Arrays.asList(uriPath.split("/"));
            List<String> baseParts = Arrays.asList(basePath.split("/"));
            if (!basePath.endsWith("/")) {
                baseParts = baseParts.subList(0, baseParts.size() - 1);
            }
            if (uriParts.equals(baseParts)) {
                return new URI(null, null, null, -1, "", uri.getQuery(), uri.getFragment());
            }
            for (start2 = 0; start2 < Math.min(uriParts.size(), baseParts.size()) && uriParts.get(start2).equals(baseParts.get(start2)); ++start2) {
            }
            List<String> uriPartsRemaining = uriParts.subList(start2, uriParts.size());
            List<String> basePartsRemainig = baseParts.subList(start2, baseParts.size());
            if (basePartsRemainig.isEmpty()) {
                return new URI(null, null, null, -1, String.join((CharSequence)"/", uriPartsRemaining), uri.getQuery(), uri.getFragment());
            }
            String resultingPath = "../".repeat(basePartsRemainig.size()) + String.join((CharSequence)"/", uriPartsRemaining);
            return new URI(null, null, null, -1, resultingPath, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e2) {
            throw PklBugException.unreachableCode();
        }
    }

    public static Path relativize(Path path, Path base) {
        if (IoUtils.isWindows().booleanValue() && path.isAbsolute() && base.isAbsolute() && !path.getRoot().equals(base.getRoot())) {
            return path;
        }
        return base.relativize(path);
    }

    public static boolean isWhitespace(String str) {
        return str.codePoints().allMatch(Character::isWhitespace);
    }

    public static String capitalize(String str) {
        if (str.isEmpty()) {
            return str;
        }
        int cp = str.codePointAt(0);
        if (Character.isTitleCase(cp)) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        builder.appendCodePoint(Character.toTitleCase(cp));
        builder.append(str.substring(Character.charCount(cp)));
        return builder.toString();
    }

    public static int getMaxLineLength(String str) {
        return str.lines().map(String::length).max(Comparator.naturalOrder()).orElse(0);
    }

    public static <T> ServiceLoader<T> createServiceLoader(Class<T> serviceClass) {
        if (TruffleOptions.AOT) {
            return ServiceLoader.load(serviceClass);
        }
        return ServiceLoader.load(serviceClass, IoUtils.class.getClassLoader());
    }

    public static boolean isTestMode() {
        return Boolean.getBoolean("org.pkl.testMode");
    }

    public static void setTestMode() {
        System.setProperty("org.pkl.testMode", "true");
    }

    public static void setSystemProxy(URI proxyAddress) {
        System.setProperty("http.proxyHost", proxyAddress.getHost());
        System.setProperty("http.proxyPort", proxyAddress.getPort() == -1 ? "80" : String.valueOf(proxyAddress.getPort()));
    }

    @Nullable
    public static String parseTripleDotPath(URI importUri) throws URISyntaxException {
        String importScheme = importUri.getScheme();
        if (importScheme != null) {
            return null;
        }
        String schemeSpecificPart = importUri.getSchemeSpecificPart();
        if (!schemeSpecificPart.startsWith("...")) {
            return null;
        }
        if (schemeSpecificPart.length() == 3) {
            return "";
        }
        if (schemeSpecificPart.charAt(3) != '/' || schemeSpecificPart.length() == 4) {
            throw new URISyntaxException(importUri.toString(), ErrorMessages.create("invalidTripleDotSyntax", new Object[0]));
        }
        return schemeSpecificPart.substring(4);
    }

    public static String toUnicodeEscape(int ch) {
        String hex = Integer.toHexString(ch);
        return switch (hex.length()) {
            case 1 -> "\\u000" + hex;
            case 2 -> "\\u00" + hex;
            case 3 -> "\\u0" + hex;
            case 4 -> "\\u" + hex;
            default -> throw new IllegalArgumentException(String.valueOf(ch));
        };
    }

    public static String toHexEscape(int ch) {
        String hex = Integer.toHexString(ch);
        return switch (hex.length()) {
            case 1 -> "\\x0" + hex;
            case 2 -> "\\x" + hex;
            default -> throw new IllegalArgumentException(String.valueOf(ch));
        };
    }

    public static boolean isHexDigit(char ch) {
        return switch (ch) {
            case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'a', 'b', 'c', 'd', 'e', 'f' -> true;
            default -> false;
        };
    }

    public static boolean isHexDigitOrUnderscore(char ch) {
        return switch (ch) {
            case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '_', 'a', 'b', 'c', 'd', 'e', 'f' -> true;
            default -> false;
        };
    }

    public static boolean isDecimalDigit(char ch) {
        return switch (ch) {
            case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' -> true;
            default -> false;
        };
    }

    public static boolean isDecimalDigitOrUnderscore(char ch) {
        return switch (ch) {
            case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_' -> true;
            default -> false;
        };
    }

    public static boolean isNonZeroDecimalDigit(char ch) {
        return switch (ch) {
            case '1', '2', '3', '4', '5', '6', '7', '8', '9' -> true;
            default -> false;
        };
    }

    public static boolean isOctalDigit(char ch) {
        return switch (ch) {
            case '0', '1', '2', '3', '4', '5', '6', '7' -> true;
            default -> false;
        };
    }

    public static boolean isOctalDigitOrUnderscore(char ch) {
        return switch (ch) {
            case '0', '1', '2', '3', '4', '5', '6', '7', '_' -> true;
            default -> false;
        };
    }

    public static boolean isBinaryDigitOrUnderscore(char ch) {
        return switch (ch) {
            case '0', '1', '_' -> true;
            default -> false;
        };
    }

    public static URI fixTripleSlashUri(URI baseUri, URI newUri) {
        if (baseUri.getScheme() != null && baseUri.getScheme().equalsIgnoreCase(newUri.getScheme()) && baseUri.getSchemeSpecificPart().startsWith("///") && newUri.getHost() == null) {
            try {
                return new URI(newUri.getScheme(), newUri.getUserInfo(), "", newUri.getPort(), newUri.getPath(), newUri.getQuery(), newUri.getFragment());
            }
            catch (URISyntaxException e2) {
                throw new IllegalArgumentException(e2.getMessage(), e2);
            }
        }
        return newUri;
    }

    public static boolean isReservedFilenameChar(char character) {
        if (IoUtils.isWindows().booleanValue()) {
            return IoUtils.isReservedWindowsFilenameChar(character);
        }
        return character == '\u0000' || character == '/';
    }

    public static boolean isReservedWindowsFilenameChar(char character) {
        return switch (character) {
            case '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '*', '/', ':', '<', '>', '?', '\\', '|' -> true;
            default -> false;
        };
    }

    public static String encodePath(String path) {
        if (path.isEmpty()) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char character = path.charAt(i);
            if (IoUtils.isReservedWindowsFilenameChar(character) && character != '/') {
                sb.append('(');
                sb.append(ByteArrayUtils.toHex(new byte[]{(byte)character}));
                sb.append(")");
                continue;
            }
            if (character == '(') {
                sb.append("((");
                continue;
            }
            sb.append(character);
        }
        return sb.toString();
    }

    public static String toNormalizedPathString(Path path) {
        if (IoUtils.isWindows().booleanValue()) {
            return path.toString().replace("\\", "/");
        }
        return path.toString();
    }

    private static int getExclamationMarkIndex(String jarUri) {
        int index = jarUri.indexOf(33);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid `jar:` URI (missing `!`): " + jarUri);
        }
        return index;
    }
}

