/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Objects;
import java.util.function.BiFunction;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.pkl.core.util.Nullable;

public final class EconomicMaps {
    private EconomicMaps() {
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> EconomicMap<K, V> create() {
        return EconomicMap.create();
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> EconomicMap<K, V> create(int initialSize) {
        return EconomicMap.create((int)initialSize);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> EconomicMap<K, V> of(K key2, V value2) {
        EconomicMap result = EconomicMap.create((int)1);
        result.put(key2, value2);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> EconomicMap<K, V> of(K key1, V value1, K key2, V value2) {
        EconomicMap result = EconomicMap.create((int)2);
        result.put(key1, value1);
        result.put(key2, value2);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> EconomicMap<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3) {
        EconomicMap result = EconomicMap.create((int)3);
        result.put(key1, value1);
        result.put(key2, value2);
        result.put(key3, value3);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> EconomicMap<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        EconomicMap result = EconomicMap.create((int)4);
        result.put(key1, value1);
        result.put(key2, value2);
        result.put(key3, value3);
        result.put(key4, value4);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    @Nullable
    public static <K, V> V get(UnmodifiableEconomicMap<K, V> self, K key2) {
        return (V)self.get(key2);
    }

    @CompilerDirectives.TruffleBoundary
    @Nullable
    public static <K, V> V get(UnmodifiableEconomicMap<K, V> self, K key2, V defaultValue) {
        return (V)self.get(key2, defaultValue);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> boolean containsKey(UnmodifiableEconomicMap<K, V> self, K key2) {
        return self.containsKey(key2);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> int size(UnmodifiableEconomicMap<K, V> self) {
        return self.size();
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> boolean isEmpty(UnmodifiableEconomicMap<K, V> self) {
        return self.isEmpty();
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> Iterable<V> getValues(UnmodifiableEconomicMap<K, V> self) {
        return self.getValues();
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> Iterable<K> getKeys(UnmodifiableEconomicMap<K, V> self) {
        return self.getKeys();
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> UnmodifiableMapCursor<K, V> getEntries(UnmodifiableEconomicMap<K, V> self) {
        return self.getEntries();
    }

    @CompilerDirectives.TruffleBoundary
    @Nullable
    public static <K, V> V put(EconomicMap<K, V> self, K key2, @Nullable V value2) {
        return (V)self.put(key2, value2);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> void putAll(EconomicMap<K, V> self, EconomicMap<K, V> other) {
        self.putAll(other);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> void putAll(EconomicMap<K, V> self, UnmodifiableEconomicMap<? extends K, ? extends V> other) {
        self.putAll(other);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> void clear(EconomicMap<K, V> self) {
        self.clear();
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> V removeKey(EconomicMap<K, V> self, K key2) {
        return (V)self.removeKey(key2);
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> MapCursor<K, V> getEntries(EconomicMap<K, V> self) {
        return self.getEntries();
    }

    @CompilerDirectives.TruffleBoundary
    public static <K, V> void replaceAll(EconomicMap<K, V> self, BiFunction<? super K, ? super V, ? extends V> function) {
        self.replaceAll(function);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean equals(UnmodifiableEconomicMap map1, UnmodifiableEconomicMap map2) {
        if (map1 == map2) {
            return true;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        UnmodifiableMapCursor cursor = map1.getEntries();
        while (cursor.advance()) {
            Object key1 = cursor.getKey();
            Object value1 = cursor.getValue();
            Object value2 = map2.get(key1);
            if (!(value2 == null ? value1 != null || !map2.containsKey(key1) : !value2.equals(value1))) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public static int hashCode(UnmodifiableEconomicMap<?, ?> map2) {
        int result = 0;
        UnmodifiableMapCursor cursor = map2.getEntries();
        while (cursor.advance()) {
            result += cursor.getKey().hashCode() ^ Objects.hashCode(cursor.getValue());
        }
        return result;
    }
}

