/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import java.util.PrimitiveIterator;
import java.util.Set;
import org.pkl.core.PClassInfo;
import org.pkl.core.PType;
import org.pkl.core.util.Nullable;

public final class CodeGeneratorUtils {
    private static final int UNDERSCORE = 95;

    private CodeGeneratorUtils() {
    }

    public static boolean isRepresentableAsEnum(PType type, @Nullable Set<String> collector) {
        if (type instanceof PType.StringLiteral) {
            PType.StringLiteral stringLiteralType = (PType.StringLiteral)type;
            if (collector != null) {
                collector.add(stringLiteralType.getLiteral());
            }
            return true;
        }
        if (type instanceof PType.Alias) {
            PType.Alias aliasType = (PType.Alias)type;
            return CodeGeneratorUtils.isRepresentableAsEnum(aliasType.getAliasedType(), collector);
        }
        if (type instanceof PType.Union) {
            PType.Union unionType = (PType.Union)type;
            for (PType elementType : unionType.getElementTypes()) {
                if (CodeGeneratorUtils.isRepresentableAsEnum(elementType, collector)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isRepresentableAsString(PType type) {
        if (type instanceof PType.StringLiteral) {
            return true;
        }
        if (type instanceof PType.Class) {
            PType.Class classType = (PType.Class)type;
            return classType.getPClass().getInfo() == PClassInfo.String;
        }
        if (type instanceof PType.Alias) {
            PType.Alias aliasType = (PType.Alias)type;
            return CodeGeneratorUtils.isRepresentableAsString(aliasType.getAliasedType());
        }
        if (type instanceof PType.Union) {
            PType.Union unionType = (PType.Union)type;
            for (PType elementType : unionType.getElementTypes()) {
                if (CodeGeneratorUtils.isRepresentableAsString(elementType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static String toEnumConstantName(String pklStringLiteral) {
        if (pklStringLiteral.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int firstCodePoint = pklStringLiteral.codePointAt(0);
        if (Character.getType(firstCodePoint) == 9) {
            builder.appendCodePoint(95);
        }
        PrimitiveIterator.OfInt iterator = pklStringLiteral.codePoints().iterator();
        boolean seenPotentialWordEnd = false;
        while (iterator.hasNext()) {
            int codePoint = iterator.nextInt();
            int category = Character.getType(codePoint);
            if (CodeGeneratorUtils.isPunctuationOrSpacing(category)) {
                builder.appendCodePoint(95);
                seenPotentialWordEnd = false;
                continue;
            }
            if (!CodeGeneratorUtils.isValidIdentifierPart(codePoint, category)) {
                return null;
            }
            boolean isUpperCase = Character.isUpperCase(codePoint);
            if (seenPotentialWordEnd && isUpperCase) {
                builder.appendCodePoint(95).appendCodePoint(codePoint);
                seenPotentialWordEnd = false;
                continue;
            }
            builder.appendCodePoint(isUpperCase ? codePoint : Character.toUpperCase(codePoint));
            seenPotentialWordEnd = !isUpperCase;
        }
        return builder.toString();
    }

    private static boolean isValidIdentifierPart(int codePoint, int category) {
        return switch (category) {
            case 1, 2, 3, 4, 5, 9, 10 -> true;
            default -> codePoint == 95;
        };
    }

    private static boolean isPunctuationOrSpacing(int category) {
        return switch (category) {
            case 12, 13, 14, 20, 21, 22, 23, 24, 29, 30 -> true;
            default -> false;
        };
    }
}

