/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.test.report;

import java.io.IOException;
import java.io.Writer;
import java.util.stream.Collectors;
import org.pkl.core.runtime.TestResults;
import org.pkl.core.stdlib.test.report.TestReport;
import org.pkl.core.util.StringUtils;

public final class SimpleReport
implements TestReport {
    @Override
    public void report(TestResults results, Writer writer) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("module ");
        builder.append(results.getModuleName());
        builder.append(" (").append(results.getDisplayUri()).append(")\n");
        StringUtils.joinToStringBuilder(builder, results.getResults(), "\n", res -> this.reportResult((TestResults.TestResult)res, builder));
        builder.append("\n");
        writer.append(builder);
    }

    private void reportResult(TestResults.TestResult result, StringBuilder builder) {
        builder.append("  ").append(result.getName());
        if (result.isExampleWritten()) {
            builder.append(" \u270d\ufe0f");
        } else if (result.isSuccess()) {
            builder.append(" \u2705");
        } else {
            builder.append(" \u274c\n");
            StringUtils.joinToStringBuilder(builder, result.getFailures(), "\n", failure -> SimpleReport.reportFailure(failure, builder));
            StringUtils.joinToStringBuilder(builder, result.getErrors(), "\n", error -> {
                builder.append("    Error:\n");
                SimpleReport.appendPadded(builder, error.getException().getMessage(), "        ");
            });
        }
    }

    public static void reportFailure(TestResults.Failure failure, StringBuilder builder) {
        SimpleReport.appendPadded(builder, failure.getRendered(), "    ");
    }

    private static void appendPadded(StringBuilder builder, String lines, String padding) {
        StringUtils.joinToStringBuilder(builder, lines.lines().collect(Collectors.toList()), "\n", str -> builder.append(padding).append((String)str));
    }
}

