/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.type.ResolveDeclaredTypeNode;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;

public final class ResolveQualifiedDeclaredTypeNode
extends ResolveDeclaredTypeNode {
    private final SourceSection moduleNameSection;
    private final SourceSection typeNameSection;
    private final Identifier moduleName;
    private final Identifier typeName;

    public ResolveQualifiedDeclaredTypeNode(SourceSection sourceSection, SourceSection moduleNameSection, SourceSection typeNameSection, Identifier moduleName, Identifier typeName) {
        super(sourceSection);
        this.moduleNameSection = moduleNameSection;
        this.typeNameSection = typeNameSection;
        this.moduleName = moduleName;
        this.typeName = typeName;
        assert (moduleName.isLocalProp());
        assert (typeName.isRegular());
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        VmTyped importedModule;
        CompilerDirectives.transferToInterpreter();
        VmTyped enclosingModule = this.getEnclosingModule(VmUtils.getOwner((Frame)frame));
        for (VmTyped currModule = importedModule = this.getImport(enclosingModule, this.moduleName, this.moduleNameSection); currModule != null; currModule = currModule.getParent()) {
            Object result = this.getType(currModule, this.typeName, this.sourceSection);
            if (result == null) continue;
            return result;
        }
        throw this.exceptionBuilder().evalError("cannotFindQualifiedType", this.typeName, importedModule.getModuleInfo().getModuleName()).withSourceSection(this.typeNameSection).build();
    }
}

